/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a custom data identifier that produced a sensitive data finding, and the sensitive data
 * that it detected for the finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomDetection implements SdkPojo, Serializable, ToCopyableBuilder<CustomDetection.Builder, CustomDetection> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CustomDetection::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Long> COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("count")
            .getter(getter(CustomDetection::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CustomDetection::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Occurrences> OCCURRENCES_FIELD = SdkField.<Occurrences> builder(MarshallingType.SDK_POJO)
            .memberName("occurrences").getter(getter(CustomDetection::occurrences)).setter(setter(Builder::occurrences))
            .constructor(Occurrences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("occurrences").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COUNT_FIELD,
            NAME_FIELD, OCCURRENCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Long count;

    private final String name;

    private final Occurrences occurrences;

    private CustomDetection(BuilderImpl builder) {
        this.arn = builder.arn;
        this.count = builder.count;
        this.name = builder.name;
        this.occurrences = builder.occurrences;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom data identifier.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom data identifier.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The total number of occurrences of the sensitive data that the custom data identifier detected.
     * </p>
     * 
     * @return The total number of occurrences of the sensitive data that the custom data identifier detected.
     */
    public final Long count() {
        return count;
    }

    /**
     * <p>
     * The name of the custom data identifier.
     * </p>
     * 
     * @return The name of the custom data identifier.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A finding
     * includes location data for a maximum of 15 occurrences of sensitive data.
     * </p>
     * 
     * @return The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A
     *         finding includes location data for a maximum of 15 occurrences of sensitive data.
     */
    public final Occurrences occurrences() {
        return occurrences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(occurrences());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomDetection)) {
            return false;
        }
        CustomDetection other = (CustomDetection) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(count(), other.count())
                && Objects.equals(name(), other.name()) && Objects.equals(occurrences(), other.occurrences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomDetection").add("Arn", arn()).add("Count", count()).add("Name", name())
                .add("Occurrences", occurrences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "occurrences":
            return Optional.ofNullable(clazz.cast(occurrences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomDetection, T> g) {
        return obj -> g.apply((CustomDetection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomDetection> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom data identifier.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the custom data identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The total number of occurrences of the sensitive data that the custom data identifier detected.
         * </p>
         * 
         * @param count
         *        The total number of occurrences of the sensitive data that the custom data identifier detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);

        /**
         * <p>
         * The name of the custom data identifier.
         * </p>
         * 
         * @param name
         *        The name of the custom data identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A finding
         * includes location data for a maximum of 15 occurrences of sensitive data.
         * </p>
         * 
         * @param occurrences
         *        The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A
         *        finding includes location data for a maximum of 15 occurrences of sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrences(Occurrences occurrences);

        /**
         * <p>
         * The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A finding
         * includes location data for a maximum of 15 occurrences of sensitive data.
         * </p>
         * This is a convenience that creates an instance of the {@link Occurrences.Builder} avoiding the need to create
         * one manually via {@link Occurrences#builder()}.
         *
         * When the {@link Consumer} completes, {@link Occurrences.Builder#build()} is called immediately and its result
         * is passed to {@link #occurrences(Occurrences)}.
         * 
         * @param occurrences
         *        a consumer that will call methods on {@link Occurrences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #occurrences(Occurrences)
         */
        default Builder occurrences(Consumer<Occurrences.Builder> occurrences) {
            return occurrences(Occurrences.builder().applyMutation(occurrences).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Long count;

        private String name;

        private Occurrences occurrences;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomDetection model) {
            arn(model.arn);
            count(model.count);
            name(model.name);
            occurrences(model.occurrences);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Long getCount() {
            return count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Occurrences.Builder getOccurrences() {
            return occurrences != null ? occurrences.toBuilder() : null;
        }

        @Override
        public final Builder occurrences(Occurrences occurrences) {
            this.occurrences = occurrences;
            return this;
        }

        public final void setOccurrences(Occurrences.BuilderImpl occurrences) {
            this.occurrences = occurrences != null ? occurrences.build() : null;
        }

        @Override
        public CustomDetection build() {
            return new CustomDetection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
