/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.BucketCountByEffectivePermission;
import software.amazon.awssdk.services.macie2.model.BucketCountByEncryptionType;
import software.amazon.awssdk.services.macie2.model.BucketCountBySharedAccessType;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.ObjectLevelStatistics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBucketStatisticsResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, GetBucketStatisticsResponse> {
    private static final SdkField<Long> BUCKET_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(GetBucketStatisticsResponse.getter(GetBucketStatisticsResponse::bucketCount)).setter(GetBucketStatisticsResponse.setter(Builder::bucketCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCount").build()}).build();
    private static final SdkField<BucketCountByEffectivePermission> BUCKET_COUNT_BY_EFFECTIVE_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetBucketStatisticsResponse.getter(GetBucketStatisticsResponse::bucketCountByEffectivePermission)).setter(GetBucketStatisticsResponse.setter(Builder::bucketCountByEffectivePermission)).constructor(BucketCountByEffectivePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCountByEffectivePermission").build()}).build();
    private static final SdkField<BucketCountByEncryptionType> BUCKET_COUNT_BY_ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetBucketStatisticsResponse.getter(GetBucketStatisticsResponse::bucketCountByEncryptionType)).setter(GetBucketStatisticsResponse.setter(Builder::bucketCountByEncryptionType)).constructor(BucketCountByEncryptionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCountByEncryptionType").build()}).build();
    private static final SdkField<BucketCountBySharedAccessType> BUCKET_COUNT_BY_SHARED_ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetBucketStatisticsResponse.getter(GetBucketStatisticsResponse::bucketCountBySharedAccessType)).setter(GetBucketStatisticsResponse.setter(Builder::bucketCountBySharedAccessType)).constructor(BucketCountBySharedAccessType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCountBySharedAccessType").build()}).build();
    private static final SdkField<Long> CLASSIFIABLE_OBJECT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(GetBucketStatisticsResponse.getter(GetBucketStatisticsResponse::classifiableObjectCount)).setter(GetBucketStatisticsResponse.setter(Builder::classifiableObjectCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classifiableObjectCount").build()}).build();
    private static final SdkField<Long> CLASSIFIABLE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(GetBucketStatisticsResponse.getter(GetBucketStatisticsResponse::classifiableSizeInBytes)).setter(GetBucketStatisticsResponse.setter(Builder::classifiableSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classifiableSizeInBytes").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetBucketStatisticsResponse.getter(GetBucketStatisticsResponse::lastUpdated)).setter(GetBucketStatisticsResponse.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Long> OBJECT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(GetBucketStatisticsResponse.getter(GetBucketStatisticsResponse::objectCount)).setter(GetBucketStatisticsResponse.setter(Builder::objectCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectCount").build()}).build();
    private static final SdkField<Long> SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(GetBucketStatisticsResponse.getter(GetBucketStatisticsResponse::sizeInBytes)).setter(GetBucketStatisticsResponse.setter(Builder::sizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInBytes").build()}).build();
    private static final SdkField<Long> SIZE_IN_BYTES_COMPRESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(GetBucketStatisticsResponse.getter(GetBucketStatisticsResponse::sizeInBytesCompressed)).setter(GetBucketStatisticsResponse.setter(Builder::sizeInBytesCompressed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInBytesCompressed").build()}).build();
    private static final SdkField<ObjectLevelStatistics> UNCLASSIFIABLE_OBJECT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetBucketStatisticsResponse.getter(GetBucketStatisticsResponse::unclassifiableObjectCount)).setter(GetBucketStatisticsResponse.setter(Builder::unclassifiableObjectCount)).constructor(ObjectLevelStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unclassifiableObjectCount").build()}).build();
    private static final SdkField<ObjectLevelStatistics> UNCLASSIFIABLE_OBJECT_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetBucketStatisticsResponse.getter(GetBucketStatisticsResponse::unclassifiableObjectSizeInBytes)).setter(GetBucketStatisticsResponse.setter(Builder::unclassifiableObjectSizeInBytes)).constructor(ObjectLevelStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unclassifiableObjectSizeInBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_COUNT_FIELD, BUCKET_COUNT_BY_EFFECTIVE_PERMISSION_FIELD, BUCKET_COUNT_BY_ENCRYPTION_TYPE_FIELD, BUCKET_COUNT_BY_SHARED_ACCESS_TYPE_FIELD, CLASSIFIABLE_OBJECT_COUNT_FIELD, CLASSIFIABLE_SIZE_IN_BYTES_FIELD, LAST_UPDATED_FIELD, OBJECT_COUNT_FIELD, SIZE_IN_BYTES_FIELD, SIZE_IN_BYTES_COMPRESSED_FIELD, UNCLASSIFIABLE_OBJECT_COUNT_FIELD, UNCLASSIFIABLE_OBJECT_SIZE_IN_BYTES_FIELD));
    private final Long bucketCount;
    private final BucketCountByEffectivePermission bucketCountByEffectivePermission;
    private final BucketCountByEncryptionType bucketCountByEncryptionType;
    private final BucketCountBySharedAccessType bucketCountBySharedAccessType;
    private final Long classifiableObjectCount;
    private final Long classifiableSizeInBytes;
    private final Instant lastUpdated;
    private final Long objectCount;
    private final Long sizeInBytes;
    private final Long sizeInBytesCompressed;
    private final ObjectLevelStatistics unclassifiableObjectCount;
    private final ObjectLevelStatistics unclassifiableObjectSizeInBytes;

    private GetBucketStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.bucketCount = builder.bucketCount;
        this.bucketCountByEffectivePermission = builder.bucketCountByEffectivePermission;
        this.bucketCountByEncryptionType = builder.bucketCountByEncryptionType;
        this.bucketCountBySharedAccessType = builder.bucketCountBySharedAccessType;
        this.classifiableObjectCount = builder.classifiableObjectCount;
        this.classifiableSizeInBytes = builder.classifiableSizeInBytes;
        this.lastUpdated = builder.lastUpdated;
        this.objectCount = builder.objectCount;
        this.sizeInBytes = builder.sizeInBytes;
        this.sizeInBytesCompressed = builder.sizeInBytesCompressed;
        this.unclassifiableObjectCount = builder.unclassifiableObjectCount;
        this.unclassifiableObjectSizeInBytes = builder.unclassifiableObjectSizeInBytes;
    }

    public Long bucketCount() {
        return this.bucketCount;
    }

    public BucketCountByEffectivePermission bucketCountByEffectivePermission() {
        return this.bucketCountByEffectivePermission;
    }

    public BucketCountByEncryptionType bucketCountByEncryptionType() {
        return this.bucketCountByEncryptionType;
    }

    public BucketCountBySharedAccessType bucketCountBySharedAccessType() {
        return this.bucketCountBySharedAccessType;
    }

    public Long classifiableObjectCount() {
        return this.classifiableObjectCount;
    }

    public Long classifiableSizeInBytes() {
        return this.classifiableSizeInBytes;
    }

    public Instant lastUpdated() {
        return this.lastUpdated;
    }

    public Long objectCount() {
        return this.objectCount;
    }

    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public Long sizeInBytesCompressed() {
        return this.sizeInBytesCompressed;
    }

    public ObjectLevelStatistics unclassifiableObjectCount() {
        return this.unclassifiableObjectCount;
    }

    public ObjectLevelStatistics unclassifiableObjectSizeInBytes() {
        return this.unclassifiableObjectSizeInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketCountByEffectivePermission());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketCountByEncryptionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketCountBySharedAccessType());
        hashCode = 31 * hashCode + Objects.hashCode(this.classifiableObjectCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.classifiableSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytesCompressed());
        hashCode = 31 * hashCode + Objects.hashCode(this.unclassifiableObjectCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unclassifiableObjectSizeInBytes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketStatisticsResponse)) {
            return false;
        }
        GetBucketStatisticsResponse other = (GetBucketStatisticsResponse)((Object)obj);
        return Objects.equals(this.bucketCount(), other.bucketCount()) && Objects.equals(this.bucketCountByEffectivePermission(), other.bucketCountByEffectivePermission()) && Objects.equals(this.bucketCountByEncryptionType(), other.bucketCountByEncryptionType()) && Objects.equals(this.bucketCountBySharedAccessType(), other.bucketCountBySharedAccessType()) && Objects.equals(this.classifiableObjectCount(), other.classifiableObjectCount()) && Objects.equals(this.classifiableSizeInBytes(), other.classifiableSizeInBytes()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.objectCount(), other.objectCount()) && Objects.equals(this.sizeInBytes(), other.sizeInBytes()) && Objects.equals(this.sizeInBytesCompressed(), other.sizeInBytesCompressed()) && Objects.equals(this.unclassifiableObjectCount(), other.unclassifiableObjectCount()) && Objects.equals(this.unclassifiableObjectSizeInBytes(), other.unclassifiableObjectSizeInBytes());
    }

    public String toString() {
        return ToString.builder((String)"GetBucketStatisticsResponse").add("BucketCount", (Object)this.bucketCount()).add("BucketCountByEffectivePermission", (Object)this.bucketCountByEffectivePermission()).add("BucketCountByEncryptionType", (Object)this.bucketCountByEncryptionType()).add("BucketCountBySharedAccessType", (Object)this.bucketCountBySharedAccessType()).add("ClassifiableObjectCount", (Object)this.classifiableObjectCount()).add("ClassifiableSizeInBytes", (Object)this.classifiableSizeInBytes()).add("LastUpdated", (Object)this.lastUpdated()).add("ObjectCount", (Object)this.objectCount()).add("SizeInBytes", (Object)this.sizeInBytes()).add("SizeInBytesCompressed", (Object)this.sizeInBytesCompressed()).add("UnclassifiableObjectCount", (Object)this.unclassifiableObjectCount()).add("UnclassifiableObjectSizeInBytes", (Object)this.unclassifiableObjectSizeInBytes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketCount": {
                return Optional.ofNullable(clazz.cast(this.bucketCount()));
            }
            case "bucketCountByEffectivePermission": {
                return Optional.ofNullable(clazz.cast(this.bucketCountByEffectivePermission()));
            }
            case "bucketCountByEncryptionType": {
                return Optional.ofNullable(clazz.cast(this.bucketCountByEncryptionType()));
            }
            case "bucketCountBySharedAccessType": {
                return Optional.ofNullable(clazz.cast(this.bucketCountBySharedAccessType()));
            }
            case "classifiableObjectCount": {
                return Optional.ofNullable(clazz.cast(this.classifiableObjectCount()));
            }
            case "classifiableSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.classifiableSizeInBytes()));
            }
            case "lastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "objectCount": {
                return Optional.ofNullable(clazz.cast(this.objectCount()));
            }
            case "sizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.sizeInBytes()));
            }
            case "sizeInBytesCompressed": {
                return Optional.ofNullable(clazz.cast(this.sizeInBytesCompressed()));
            }
            case "unclassifiableObjectCount": {
                return Optional.ofNullable(clazz.cast(this.unclassifiableObjectCount()));
            }
            case "unclassifiableObjectSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.unclassifiableObjectSizeInBytes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketStatisticsResponse, T> g) {
        return obj -> g.apply((GetBucketStatisticsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private Long bucketCount;
        private BucketCountByEffectivePermission bucketCountByEffectivePermission;
        private BucketCountByEncryptionType bucketCountByEncryptionType;
        private BucketCountBySharedAccessType bucketCountBySharedAccessType;
        private Long classifiableObjectCount;
        private Long classifiableSizeInBytes;
        private Instant lastUpdated;
        private Long objectCount;
        private Long sizeInBytes;
        private Long sizeInBytesCompressed;
        private ObjectLevelStatistics unclassifiableObjectCount;
        private ObjectLevelStatistics unclassifiableObjectSizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketStatisticsResponse model) {
            super(model);
            this.bucketCount(model.bucketCount);
            this.bucketCountByEffectivePermission(model.bucketCountByEffectivePermission);
            this.bucketCountByEncryptionType(model.bucketCountByEncryptionType);
            this.bucketCountBySharedAccessType(model.bucketCountBySharedAccessType);
            this.classifiableObjectCount(model.classifiableObjectCount);
            this.classifiableSizeInBytes(model.classifiableSizeInBytes);
            this.lastUpdated(model.lastUpdated);
            this.objectCount(model.objectCount);
            this.sizeInBytes(model.sizeInBytes);
            this.sizeInBytesCompressed(model.sizeInBytesCompressed);
            this.unclassifiableObjectCount(model.unclassifiableObjectCount);
            this.unclassifiableObjectSizeInBytes(model.unclassifiableObjectSizeInBytes);
        }

        public final Long getBucketCount() {
            return this.bucketCount;
        }

        @Override
        public final Builder bucketCount(Long bucketCount) {
            this.bucketCount = bucketCount;
            return this;
        }

        public final void setBucketCount(Long bucketCount) {
            this.bucketCount = bucketCount;
        }

        public final BucketCountByEffectivePermission.Builder getBucketCountByEffectivePermission() {
            return this.bucketCountByEffectivePermission != null ? this.bucketCountByEffectivePermission.toBuilder() : null;
        }

        @Override
        public final Builder bucketCountByEffectivePermission(BucketCountByEffectivePermission bucketCountByEffectivePermission) {
            this.bucketCountByEffectivePermission = bucketCountByEffectivePermission;
            return this;
        }

        public final void setBucketCountByEffectivePermission(BucketCountByEffectivePermission.BuilderImpl bucketCountByEffectivePermission) {
            this.bucketCountByEffectivePermission = bucketCountByEffectivePermission != null ? bucketCountByEffectivePermission.build() : null;
        }

        public final BucketCountByEncryptionType.Builder getBucketCountByEncryptionType() {
            return this.bucketCountByEncryptionType != null ? this.bucketCountByEncryptionType.toBuilder() : null;
        }

        @Override
        public final Builder bucketCountByEncryptionType(BucketCountByEncryptionType bucketCountByEncryptionType) {
            this.bucketCountByEncryptionType = bucketCountByEncryptionType;
            return this;
        }

        public final void setBucketCountByEncryptionType(BucketCountByEncryptionType.BuilderImpl bucketCountByEncryptionType) {
            this.bucketCountByEncryptionType = bucketCountByEncryptionType != null ? bucketCountByEncryptionType.build() : null;
        }

        public final BucketCountBySharedAccessType.Builder getBucketCountBySharedAccessType() {
            return this.bucketCountBySharedAccessType != null ? this.bucketCountBySharedAccessType.toBuilder() : null;
        }

        @Override
        public final Builder bucketCountBySharedAccessType(BucketCountBySharedAccessType bucketCountBySharedAccessType) {
            this.bucketCountBySharedAccessType = bucketCountBySharedAccessType;
            return this;
        }

        public final void setBucketCountBySharedAccessType(BucketCountBySharedAccessType.BuilderImpl bucketCountBySharedAccessType) {
            this.bucketCountBySharedAccessType = bucketCountBySharedAccessType != null ? bucketCountBySharedAccessType.build() : null;
        }

        public final Long getClassifiableObjectCount() {
            return this.classifiableObjectCount;
        }

        @Override
        public final Builder classifiableObjectCount(Long classifiableObjectCount) {
            this.classifiableObjectCount = classifiableObjectCount;
            return this;
        }

        public final void setClassifiableObjectCount(Long classifiableObjectCount) {
            this.classifiableObjectCount = classifiableObjectCount;
        }

        public final Long getClassifiableSizeInBytes() {
            return this.classifiableSizeInBytes;
        }

        @Override
        public final Builder classifiableSizeInBytes(Long classifiableSizeInBytes) {
            this.classifiableSizeInBytes = classifiableSizeInBytes;
            return this;
        }

        public final void setClassifiableSizeInBytes(Long classifiableSizeInBytes) {
            this.classifiableSizeInBytes = classifiableSizeInBytes;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final Long getObjectCount() {
            return this.objectCount;
        }

        @Override
        public final Builder objectCount(Long objectCount) {
            this.objectCount = objectCount;
            return this;
        }

        public final void setObjectCount(Long objectCount) {
            this.objectCount = objectCount;
        }

        public final Long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public final Long getSizeInBytesCompressed() {
            return this.sizeInBytesCompressed;
        }

        @Override
        public final Builder sizeInBytesCompressed(Long sizeInBytesCompressed) {
            this.sizeInBytesCompressed = sizeInBytesCompressed;
            return this;
        }

        public final void setSizeInBytesCompressed(Long sizeInBytesCompressed) {
            this.sizeInBytesCompressed = sizeInBytesCompressed;
        }

        public final ObjectLevelStatistics.Builder getUnclassifiableObjectCount() {
            return this.unclassifiableObjectCount != null ? this.unclassifiableObjectCount.toBuilder() : null;
        }

        @Override
        public final Builder unclassifiableObjectCount(ObjectLevelStatistics unclassifiableObjectCount) {
            this.unclassifiableObjectCount = unclassifiableObjectCount;
            return this;
        }

        public final void setUnclassifiableObjectCount(ObjectLevelStatistics.BuilderImpl unclassifiableObjectCount) {
            this.unclassifiableObjectCount = unclassifiableObjectCount != null ? unclassifiableObjectCount.build() : null;
        }

        public final ObjectLevelStatistics.Builder getUnclassifiableObjectSizeInBytes() {
            return this.unclassifiableObjectSizeInBytes != null ? this.unclassifiableObjectSizeInBytes.toBuilder() : null;
        }

        @Override
        public final Builder unclassifiableObjectSizeInBytes(ObjectLevelStatistics unclassifiableObjectSizeInBytes) {
            this.unclassifiableObjectSizeInBytes = unclassifiableObjectSizeInBytes;
            return this;
        }

        public final void setUnclassifiableObjectSizeInBytes(ObjectLevelStatistics.BuilderImpl unclassifiableObjectSizeInBytes) {
            this.unclassifiableObjectSizeInBytes = unclassifiableObjectSizeInBytes != null ? unclassifiableObjectSizeInBytes.build() : null;
        }

        @Override
        public GetBucketStatisticsResponse build() {
            return new GetBucketStatisticsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBucketStatisticsResponse> {
        public Builder bucketCount(Long var1);

        public Builder bucketCountByEffectivePermission(BucketCountByEffectivePermission var1);

        default public Builder bucketCountByEffectivePermission(Consumer<BucketCountByEffectivePermission.Builder> bucketCountByEffectivePermission) {
            return this.bucketCountByEffectivePermission((BucketCountByEffectivePermission)((BucketCountByEffectivePermission.Builder)BucketCountByEffectivePermission.builder().applyMutation(bucketCountByEffectivePermission)).build());
        }

        public Builder bucketCountByEncryptionType(BucketCountByEncryptionType var1);

        default public Builder bucketCountByEncryptionType(Consumer<BucketCountByEncryptionType.Builder> bucketCountByEncryptionType) {
            return this.bucketCountByEncryptionType((BucketCountByEncryptionType)((BucketCountByEncryptionType.Builder)BucketCountByEncryptionType.builder().applyMutation(bucketCountByEncryptionType)).build());
        }

        public Builder bucketCountBySharedAccessType(BucketCountBySharedAccessType var1);

        default public Builder bucketCountBySharedAccessType(Consumer<BucketCountBySharedAccessType.Builder> bucketCountBySharedAccessType) {
            return this.bucketCountBySharedAccessType((BucketCountBySharedAccessType)((BucketCountBySharedAccessType.Builder)BucketCountBySharedAccessType.builder().applyMutation(bucketCountBySharedAccessType)).build());
        }

        public Builder classifiableObjectCount(Long var1);

        public Builder classifiableSizeInBytes(Long var1);

        public Builder lastUpdated(Instant var1);

        public Builder objectCount(Long var1);

        public Builder sizeInBytes(Long var1);

        public Builder sizeInBytesCompressed(Long var1);

        public Builder unclassifiableObjectCount(ObjectLevelStatistics var1);

        default public Builder unclassifiableObjectCount(Consumer<ObjectLevelStatistics.Builder> unclassifiableObjectCount) {
            return this.unclassifiableObjectCount((ObjectLevelStatistics)((ObjectLevelStatistics.Builder)ObjectLevelStatistics.builder().applyMutation(unclassifiableObjectCount)).build());
        }

        public Builder unclassifiableObjectSizeInBytes(ObjectLevelStatistics var1);

        default public Builder unclassifiableObjectSizeInBytes(Consumer<ObjectLevelStatistics.Builder> unclassifiableObjectSizeInBytes) {
            return this.unclassifiableObjectSizeInBytes((ObjectLevelStatistics)((ObjectLevelStatistics.Builder)ObjectLevelStatistics.builder().applyMutation(unclassifiableObjectSizeInBytes)).build());
        }
    }
}

