/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.macie2.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.macie2.model.AccessDeniedException;
import software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersRequest;
import software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersResponse;
import software.amazon.awssdk.services.macie2.model.ConflictException;
import software.amazon.awssdk.services.macie2.model.CreateClassificationJobRequest;
import software.amazon.awssdk.services.macie2.model.CreateClassificationJobResponse;
import software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.CreateFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.CreateInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.CreateMemberRequest;
import software.amazon.awssdk.services.macie2.model.CreateMemberResponse;
import software.amazon.awssdk.services.macie2.model.CreateSampleFindingsRequest;
import software.amazon.awssdk.services.macie2.model.CreateSampleFindingsResponse;
import software.amazon.awssdk.services.macie2.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.DeleteCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.DeleteCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.DeleteFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.DeleteFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.DeleteMemberRequest;
import software.amazon.awssdk.services.macie2.model.DeleteMemberResponse;
import software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest;
import software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse;
import software.amazon.awssdk.services.macie2.model.DescribeClassificationJobRequest;
import software.amazon.awssdk.services.macie2.model.DescribeClassificationJobResponse;
import software.amazon.awssdk.services.macie2.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.DisableMacieRequest;
import software.amazon.awssdk.services.macie2.model.DisableMacieResponse;
import software.amazon.awssdk.services.macie2.model.DisableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.macie2.model.DisableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.macie2.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.macie2.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.macie2.model.DisassociateMemberRequest;
import software.amazon.awssdk.services.macie2.model.DisassociateMemberResponse;
import software.amazon.awssdk.services.macie2.model.EnableMacieRequest;
import software.amazon.awssdk.services.macie2.model.EnableMacieResponse;
import software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.macie2.model.GetBucketStatisticsRequest;
import software.amazon.awssdk.services.macie2.model.GetBucketStatisticsResponse;
import software.amazon.awssdk.services.macie2.model.GetClassificationExportConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.GetClassificationExportConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.GetFindingStatisticsRequest;
import software.amazon.awssdk.services.macie2.model.GetFindingStatisticsResponse;
import software.amazon.awssdk.services.macie2.model.GetFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.GetFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.GetFindingsRequest;
import software.amazon.awssdk.services.macie2.model.GetFindingsResponse;
import software.amazon.awssdk.services.macie2.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.macie2.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.macie2.model.GetMacieSessionRequest;
import software.amazon.awssdk.services.macie2.model.GetMacieSessionResponse;
import software.amazon.awssdk.services.macie2.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.macie2.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.macie2.model.GetMemberRequest;
import software.amazon.awssdk.services.macie2.model.GetMemberResponse;
import software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest;
import software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse;
import software.amazon.awssdk.services.macie2.model.GetUsageTotalsRequest;
import software.amazon.awssdk.services.macie2.model.GetUsageTotalsResponse;
import software.amazon.awssdk.services.macie2.model.InternalServerException;
import software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest;
import software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse;
import software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest;
import software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse;
import software.amazon.awssdk.services.macie2.model.ListFindingsFiltersRequest;
import software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse;
import software.amazon.awssdk.services.macie2.model.ListFindingsRequest;
import software.amazon.awssdk.services.macie2.model.ListFindingsResponse;
import software.amazon.awssdk.services.macie2.model.ListInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.ListInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.ListMembersRequest;
import software.amazon.awssdk.services.macie2.model.ListMembersResponse;
import software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest;
import software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse;
import software.amazon.awssdk.services.macie2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.macie2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.macie2.model.Macie2Exception;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.macie2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.macie2.model.TagResourceRequest;
import software.amazon.awssdk.services.macie2.model.TagResourceResponse;
import software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.ThrottlingException;
import software.amazon.awssdk.services.macie2.model.UntagResourceRequest;
import software.amazon.awssdk.services.macie2.model.UntagResourceResponse;
import software.amazon.awssdk.services.macie2.model.UpdateClassificationJobRequest;
import software.amazon.awssdk.services.macie2.model.UpdateClassificationJobResponse;
import software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.UpdateMacieSessionRequest;
import software.amazon.awssdk.services.macie2.model.UpdateMacieSessionResponse;
import software.amazon.awssdk.services.macie2.model.UpdateMemberSessionRequest;
import software.amazon.awssdk.services.macie2.model.UpdateMemberSessionResponse;
import software.amazon.awssdk.services.macie2.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.ValidationException;
import software.amazon.awssdk.services.macie2.paginators.DescribeBucketsIterable;
import software.amazon.awssdk.services.macie2.paginators.GetUsageStatisticsIterable;
import software.amazon.awssdk.services.macie2.paginators.ListClassificationJobsIterable;
import software.amazon.awssdk.services.macie2.paginators.ListCustomDataIdentifiersIterable;
import software.amazon.awssdk.services.macie2.paginators.ListFindingsFiltersIterable;
import software.amazon.awssdk.services.macie2.paginators.ListFindingsIterable;
import software.amazon.awssdk.services.macie2.paginators.ListInvitationsIterable;
import software.amazon.awssdk.services.macie2.paginators.ListMembersIterable;
import software.amazon.awssdk.services.macie2.paginators.ListOrganizationAdminAccountsIterable;
import software.amazon.awssdk.services.macie2.transform.AcceptInvitationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.BatchGetCustomDataIdentifiersRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateCustomDataIdentifierRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateFindingsFilterRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateInvitationsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateMemberRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateSampleFindingsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeclineInvitationsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeleteCustomDataIdentifierRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeleteFindingsFilterRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeleteInvitationsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeleteMemberRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DescribeBucketsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DescribeClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DescribeOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DisableMacieRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DisableOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DisassociateFromMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DisassociateMemberRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.EnableMacieRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.EnableOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetBucketStatisticsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetClassificationExportConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetCustomDataIdentifierRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetFindingStatisticsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetFindingsFilterRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetFindingsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetInvitationsCountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetMacieSessionRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetMemberRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetUsageStatisticsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetUsageTotalsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListClassificationJobsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListCustomDataIdentifiersRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListFindingsFiltersRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListFindingsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListInvitationsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListMembersRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListOrganizationAdminAccountsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.PutClassificationExportConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.TestCustomDataIdentifierRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateFindingsFilterRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateMacieSessionRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateMemberSessionRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateOrganizationConfigurationRequestMarshaller;

@SdkInternalApi
final class DefaultMacie2Client
implements Macie2Client {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMacie2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "macie2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptInvitationResponse acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptInvitationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptInvitation");
            AcceptInvitationResponse acceptInvitationResponse = (AcceptInvitationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptInvitation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptInvitationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new AcceptInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptInvitationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, acceptInvitationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetCustomDataIdentifiersResponse batchGetCustomDataIdentifiers(BatchGetCustomDataIdentifiersRequest batchGetCustomDataIdentifiersRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetCustomDataIdentifiersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetCustomDataIdentifiers");
            BatchGetCustomDataIdentifiersResponse batchGetCustomDataIdentifiersResponse = (BatchGetCustomDataIdentifiersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetCustomDataIdentifiers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetCustomDataIdentifiersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetCustomDataIdentifiersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetCustomDataIdentifiersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, batchGetCustomDataIdentifiersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateClassificationJobResponse createClassificationJob(CreateClassificationJobRequest createClassificationJobRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClassificationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateClassificationJob");
            CreateClassificationJobResponse createClassificationJobResponse = (CreateClassificationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClassificationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createClassificationJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateClassificationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createClassificationJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, createClassificationJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomDataIdentifierResponse createCustomDataIdentifier(CreateCustomDataIdentifierRequest createCustomDataIdentifierRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomDataIdentifierResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomDataIdentifier");
            CreateCustomDataIdentifierResponse createCustomDataIdentifierResponse = (CreateCustomDataIdentifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomDataIdentifier").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCustomDataIdentifierRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateCustomDataIdentifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCustomDataIdentifierResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, createCustomDataIdentifierRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFindingsFilterResponse createFindingsFilter(CreateFindingsFilterRequest createFindingsFilterRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFindingsFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFindingsFilter");
            CreateFindingsFilterResponse createFindingsFilterResponse = (CreateFindingsFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFindingsFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFindingsFilterRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateFindingsFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFindingsFilterResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, createFindingsFilterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInvitationsResponse createInvitations(CreateInvitationsRequest createInvitationsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInvitationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInvitations");
            CreateInvitationsResponse createInvitationsResponse = (CreateInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInvitations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createInvitationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createInvitationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, createInvitationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMemberResponse createMember(CreateMemberRequest createMemberRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMemberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMember");
            CreateMemberResponse createMemberResponse = (CreateMemberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMember").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMemberRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateMemberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMemberResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, createMemberRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSampleFindingsResponse createSampleFindings(CreateSampleFindingsRequest createSampleFindingsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSampleFindingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSampleFindings");
            CreateSampleFindingsResponse createSampleFindingsResponse = (CreateSampleFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSampleFindings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSampleFindingsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateSampleFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSampleFindingsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, createSampleFindingsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeclineInvitationsResponse declineInvitations(DeclineInvitationsRequest declineInvitationsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeclineInvitationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeclineInvitations");
            DeclineInvitationsResponse declineInvitationsResponse = (DeclineInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeclineInvitations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)declineInvitationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeclineInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return declineInvitationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, declineInvitationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCustomDataIdentifierResponse deleteCustomDataIdentifier(DeleteCustomDataIdentifierRequest deleteCustomDataIdentifierRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomDataIdentifierResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomDataIdentifier");
            DeleteCustomDataIdentifierResponse deleteCustomDataIdentifierResponse = (DeleteCustomDataIdentifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomDataIdentifier").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCustomDataIdentifierRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCustomDataIdentifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCustomDataIdentifierResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, deleteCustomDataIdentifierRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFindingsFilterResponse deleteFindingsFilter(DeleteFindingsFilterRequest deleteFindingsFilterRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFindingsFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFindingsFilter");
            DeleteFindingsFilterResponse deleteFindingsFilterResponse = (DeleteFindingsFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFindingsFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFindingsFilterRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFindingsFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFindingsFilterResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, deleteFindingsFilterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInvitationsResponse deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInvitationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInvitations");
            DeleteInvitationsResponse deleteInvitationsResponse = (DeleteInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInvitations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteInvitationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteInvitationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, deleteInvitationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMemberResponse deleteMember(DeleteMemberRequest deleteMemberRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMemberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMember");
            DeleteMemberResponse deleteMemberResponse = (DeleteMemberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMember").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMemberRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMemberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMemberResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, deleteMemberRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBucketsResponse describeBuckets(DescribeBucketsRequest describeBucketsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBucketsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBuckets");
            DescribeBucketsResponse describeBucketsResponse = (DescribeBucketsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBuckets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBucketsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBucketsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBucketsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, describeBucketsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public DescribeBucketsIterable describeBucketsPaginator(DescribeBucketsRequest describeBucketsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        return new DescribeBucketsIterable(this, this.applyPaginatorUserAgent(describeBucketsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClassificationJobResponse describeClassificationJob(DescribeClassificationJobRequest describeClassificationJobRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClassificationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClassificationJob");
            DescribeClassificationJobResponse describeClassificationJobResponse = (DescribeClassificationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClassificationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClassificationJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeClassificationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeClassificationJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, describeClassificationJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrganizationConfigurationResponse describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationConfiguration");
            DescribeOrganizationConfigurationResponse describeOrganizationConfigurationResponse = (DescribeOrganizationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrganizationConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrganizationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOrganizationConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, describeOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableMacieResponse disableMacie(DisableMacieRequest disableMacieRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableMacieResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableMacie");
            DisableMacieResponse disableMacieResponse = (DisableMacieResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableMacie").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableMacieRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DisableMacieRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableMacieResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, disableMacieRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableOrganizationAdminAccountResponse disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest disableOrganizationAdminAccountRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableOrganizationAdminAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableOrganizationAdminAccount");
            DisableOrganizationAdminAccountResponse disableOrganizationAdminAccountResponse = (DisableOrganizationAdminAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableOrganizationAdminAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableOrganizationAdminAccountRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DisableOrganizationAdminAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableOrganizationAdminAccountResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, disableOrganizationAdminAccountRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateFromMasterAccountResponse disassociateFromMasterAccount(DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateFromMasterAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateFromMasterAccount");
            DisassociateFromMasterAccountResponse disassociateFromMasterAccountResponse = (DisassociateFromMasterAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateFromMasterAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateFromMasterAccountRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateFromMasterAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateFromMasterAccountResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, disassociateFromMasterAccountRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateMemberResponse disassociateMember(DisassociateMemberRequest disassociateMemberRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateMemberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateMember");
            DisassociateMemberResponse disassociateMemberResponse = (DisassociateMemberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateMember").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateMemberRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateMemberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateMemberResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, disassociateMemberRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableMacieResponse enableMacie(EnableMacieRequest enableMacieRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableMacieResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableMacie");
            EnableMacieResponse enableMacieResponse = (EnableMacieResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableMacie").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableMacieRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new EnableMacieRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableMacieResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, enableMacieRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableOrganizationAdminAccountResponse enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest enableOrganizationAdminAccountRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableOrganizationAdminAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableOrganizationAdminAccount");
            EnableOrganizationAdminAccountResponse enableOrganizationAdminAccountResponse = (EnableOrganizationAdminAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableOrganizationAdminAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableOrganizationAdminAccountRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new EnableOrganizationAdminAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableOrganizationAdminAccountResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, enableOrganizationAdminAccountRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketStatisticsResponse getBucketStatistics(GetBucketStatisticsRequest getBucketStatisticsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBucketStatisticsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketStatistics");
            GetBucketStatisticsResponse getBucketStatisticsResponse = (GetBucketStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBucketStatisticsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetBucketStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBucketStatisticsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, getBucketStatisticsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetClassificationExportConfigurationResponse getClassificationExportConfiguration(GetClassificationExportConfigurationRequest getClassificationExportConfigurationRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetClassificationExportConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetClassificationExportConfiguration");
            GetClassificationExportConfigurationResponse getClassificationExportConfigurationResponse = (GetClassificationExportConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetClassificationExportConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getClassificationExportConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetClassificationExportConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getClassificationExportConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, getClassificationExportConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCustomDataIdentifierResponse getCustomDataIdentifier(GetCustomDataIdentifierRequest getCustomDataIdentifierRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCustomDataIdentifierResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCustomDataIdentifier");
            GetCustomDataIdentifierResponse getCustomDataIdentifierResponse = (GetCustomDataIdentifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCustomDataIdentifier").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCustomDataIdentifierRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetCustomDataIdentifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCustomDataIdentifierResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, getCustomDataIdentifierRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFindingStatisticsResponse getFindingStatistics(GetFindingStatisticsRequest getFindingStatisticsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFindingStatisticsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFindingStatistics");
            GetFindingStatisticsResponse getFindingStatisticsResponse = (GetFindingStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFindingStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFindingStatisticsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetFindingStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFindingStatisticsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, getFindingStatisticsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFindingsResponse getFindings(GetFindingsRequest getFindingsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFindingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFindings");
            GetFindingsResponse getFindingsResponse = (GetFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFindings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFindingsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFindingsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, getFindingsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFindingsFilterResponse getFindingsFilter(GetFindingsFilterRequest getFindingsFilterRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFindingsFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFindingsFilter");
            GetFindingsFilterResponse getFindingsFilterResponse = (GetFindingsFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFindingsFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFindingsFilterRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetFindingsFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFindingsFilterResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, getFindingsFilterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInvitationsCountResponse getInvitationsCount(GetInvitationsCountRequest getInvitationsCountRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInvitationsCountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInvitationsCount");
            GetInvitationsCountResponse getInvitationsCountResponse = (GetInvitationsCountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInvitationsCount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getInvitationsCountRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetInvitationsCountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInvitationsCountResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, getInvitationsCountRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMacieSessionResponse getMacieSession(GetMacieSessionRequest getMacieSessionRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMacieSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMacieSession");
            GetMacieSessionResponse getMacieSessionResponse = (GetMacieSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMacieSession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMacieSessionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetMacieSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMacieSessionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, getMacieSessionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMasterAccountResponse getMasterAccount(GetMasterAccountRequest getMasterAccountRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMasterAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMasterAccount");
            GetMasterAccountResponse getMasterAccountResponse = (GetMasterAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMasterAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMasterAccountRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetMasterAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMasterAccountResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, getMasterAccountRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMemberResponse getMember(GetMemberRequest getMemberRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMemberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMember");
            GetMemberResponse getMemberResponse = (GetMemberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMember").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMemberRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetMemberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMemberResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, getMemberRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUsageStatisticsResponse getUsageStatistics(GetUsageStatisticsRequest getUsageStatisticsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUsageStatisticsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUsageStatistics");
            GetUsageStatisticsResponse getUsageStatisticsResponse = (GetUsageStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUsageStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getUsageStatisticsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetUsageStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUsageStatisticsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, getUsageStatisticsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public GetUsageStatisticsIterable getUsageStatisticsPaginator(GetUsageStatisticsRequest getUsageStatisticsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        return new GetUsageStatisticsIterable(this, this.applyPaginatorUserAgent(getUsageStatisticsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUsageTotalsResponse getUsageTotals(GetUsageTotalsRequest getUsageTotalsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUsageTotalsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUsageTotals");
            GetUsageTotalsResponse getUsageTotalsResponse = (GetUsageTotalsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUsageTotals").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getUsageTotalsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetUsageTotalsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUsageTotalsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, getUsageTotalsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClassificationJobsResponse listClassificationJobs(ListClassificationJobsRequest listClassificationJobsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClassificationJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListClassificationJobs");
            ListClassificationJobsResponse listClassificationJobsResponse = (ListClassificationJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClassificationJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listClassificationJobsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListClassificationJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listClassificationJobsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, listClassificationJobsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListClassificationJobsIterable listClassificationJobsPaginator(ListClassificationJobsRequest listClassificationJobsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        return new ListClassificationJobsIterable(this, this.applyPaginatorUserAgent(listClassificationJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCustomDataIdentifiersResponse listCustomDataIdentifiers(ListCustomDataIdentifiersRequest listCustomDataIdentifiersRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomDataIdentifiersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomDataIdentifiers");
            ListCustomDataIdentifiersResponse listCustomDataIdentifiersResponse = (ListCustomDataIdentifiersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomDataIdentifiers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCustomDataIdentifiersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListCustomDataIdentifiersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCustomDataIdentifiersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, listCustomDataIdentifiersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListCustomDataIdentifiersIterable listCustomDataIdentifiersPaginator(ListCustomDataIdentifiersRequest listCustomDataIdentifiersRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        return new ListCustomDataIdentifiersIterable(this, this.applyPaginatorUserAgent(listCustomDataIdentifiersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFindingsResponse listFindings(ListFindingsRequest listFindingsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFindingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFindings");
            ListFindingsResponse listFindingsResponse = (ListFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFindings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFindingsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFindingsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, listFindingsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListFindingsIterable listFindingsPaginator(ListFindingsRequest listFindingsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        return new ListFindingsIterable(this, this.applyPaginatorUserAgent(listFindingsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFindingsFiltersResponse listFindingsFilters(ListFindingsFiltersRequest listFindingsFiltersRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFindingsFiltersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFindingsFilters");
            ListFindingsFiltersResponse listFindingsFiltersResponse = (ListFindingsFiltersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFindingsFilters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFindingsFiltersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListFindingsFiltersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFindingsFiltersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, listFindingsFiltersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListFindingsFiltersIterable listFindingsFiltersPaginator(ListFindingsFiltersRequest listFindingsFiltersRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        return new ListFindingsFiltersIterable(this, this.applyPaginatorUserAgent(listFindingsFiltersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInvitationsResponse listInvitations(ListInvitationsRequest listInvitationsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInvitationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInvitations");
            ListInvitationsResponse listInvitationsResponse = (ListInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInvitations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listInvitationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listInvitationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, listInvitationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListInvitationsIterable listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        return new ListInvitationsIterable(this, this.applyPaginatorUserAgent(listInvitationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMembersResponse listMembers(ListMembersRequest listMembersRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMembers");
            ListMembersResponse listMembersResponse = (ListMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMembers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMembersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMembersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, listMembersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListMembersIterable listMembersPaginator(ListMembersRequest listMembersRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        return new ListMembersIterable(this, this.applyPaginatorUserAgent(listMembersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOrganizationAdminAccountsResponse listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOrganizationAdminAccountsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOrganizationAdminAccounts");
            ListOrganizationAdminAccountsResponse listOrganizationAdminAccountsResponse = (ListOrganizationAdminAccountsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOrganizationAdminAccounts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listOrganizationAdminAccountsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListOrganizationAdminAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOrganizationAdminAccountsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, listOrganizationAdminAccountsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListOrganizationAdminAccountsIterable listOrganizationAdminAccountsPaginator(ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        return new ListOrganizationAdminAccountsIterable(this, this.applyPaginatorUserAgent(listOrganizationAdminAccountsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutClassificationExportConfigurationResponse putClassificationExportConfiguration(PutClassificationExportConfigurationRequest putClassificationExportConfigurationRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutClassificationExportConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutClassificationExportConfiguration");
            PutClassificationExportConfigurationResponse putClassificationExportConfigurationResponse = (PutClassificationExportConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutClassificationExportConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putClassificationExportConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutClassificationExportConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putClassificationExportConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, putClassificationExportConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestCustomDataIdentifierResponse testCustomDataIdentifier(TestCustomDataIdentifierRequest testCustomDataIdentifierRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestCustomDataIdentifierResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestCustomDataIdentifier");
            TestCustomDataIdentifierResponse testCustomDataIdentifierResponse = (TestCustomDataIdentifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestCustomDataIdentifier").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testCustomDataIdentifierRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TestCustomDataIdentifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return testCustomDataIdentifierResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, testCustomDataIdentifierRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateClassificationJobResponse updateClassificationJob(UpdateClassificationJobRequest updateClassificationJobRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClassificationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateClassificationJob");
            UpdateClassificationJobResponse updateClassificationJobResponse = (UpdateClassificationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateClassificationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateClassificationJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateClassificationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateClassificationJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, updateClassificationJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFindingsFilterResponse updateFindingsFilter(UpdateFindingsFilterRequest updateFindingsFilterRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFindingsFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFindingsFilter");
            UpdateFindingsFilterResponse updateFindingsFilterResponse = (UpdateFindingsFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFindingsFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFindingsFilterRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFindingsFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFindingsFilterResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, updateFindingsFilterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateMacieSessionResponse updateMacieSession(UpdateMacieSessionRequest updateMacieSessionRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMacieSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMacieSession");
            UpdateMacieSessionResponse updateMacieSessionResponse = (UpdateMacieSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMacieSession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateMacieSessionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateMacieSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateMacieSessionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, updateMacieSessionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateMemberSessionResponse updateMemberSession(UpdateMemberSessionRequest updateMemberSessionRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMemberSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMemberSession");
            UpdateMemberSessionResponse updateMemberSessionResponse = (UpdateMemberSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMemberSession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateMemberSessionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateMemberSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateMemberSessionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, updateMemberSessionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOrganizationConfigurationResponse updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) throws ValidationException, InternalServerException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, Macie2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateOrganizationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateOrganizationConfiguration");
            UpdateOrganizationConfigurationResponse updateOrganizationConfigurationResponse = (UpdateOrganizationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateOrganizationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateOrganizationConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateOrganizationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateOrganizationConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMacie2Client.resolveMetricPublishers(this.clientConfiguration, updateOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(Macie2Exception::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends Macie2Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.60").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((Macie2Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

