/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.machinelearning.model.EDPSecurityGroupIdsCopier;
import software.amazon.awssdk.services.machinelearning.model.RDSDatabase;
import software.amazon.awssdk.services.machinelearning.model.RDSDatabaseCredentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RDSDataSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RDSDataSpec> {
    private static final SdkField<RDSDatabase> DATABASE_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatabaseInformation").getter(RDSDataSpec.getter(RDSDataSpec::databaseInformation)).setter(RDSDataSpec.setter(Builder::databaseInformation)).constructor(RDSDatabase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInformation").build()}).build();
    private static final SdkField<String> SELECT_SQL_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectSqlQuery").getter(RDSDataSpec.getter(RDSDataSpec::selectSqlQuery)).setter(RDSDataSpec.setter(Builder::selectSqlQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectSqlQuery").build()}).build();
    private static final SdkField<RDSDatabaseCredentials> DATABASE_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatabaseCredentials").getter(RDSDataSpec.getter(RDSDataSpec::databaseCredentials)).setter(RDSDataSpec.setter(Builder::databaseCredentials)).constructor(RDSDatabaseCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseCredentials").build()}).build();
    private static final SdkField<String> S3_STAGING_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3StagingLocation").getter(RDSDataSpec.getter(RDSDataSpec::s3StagingLocation)).setter(RDSDataSpec.setter(Builder::s3StagingLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3StagingLocation").build()}).build();
    private static final SdkField<String> DATA_REARRANGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataRearrangement").getter(RDSDataSpec.getter(RDSDataSpec::dataRearrangement)).setter(RDSDataSpec.setter(Builder::dataRearrangement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRearrangement").build()}).build();
    private static final SdkField<String> DATA_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSchema").getter(RDSDataSpec.getter(RDSDataSpec::dataSchema)).setter(RDSDataSpec.setter(Builder::dataSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSchema").build()}).build();
    private static final SdkField<String> DATA_SCHEMA_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSchemaUri").getter(RDSDataSpec.getter(RDSDataSpec::dataSchemaUri)).setter(RDSDataSpec.setter(Builder::dataSchemaUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSchemaUri").build()}).build();
    private static final SdkField<String> RESOURCE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceRole").getter(RDSDataSpec.getter(RDSDataSpec::resourceRole)).setter(RDSDataSpec.setter(Builder::resourceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRole").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRole").getter(RDSDataSpec.getter(RDSDataSpec::serviceRole)).setter(RDSDataSpec.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(RDSDataSpec.getter(RDSDataSpec::subnetId)).setter(RDSDataSpec.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(RDSDataSpec.getter(RDSDataSpec::securityGroupIds)).setter(RDSDataSpec.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_INFORMATION_FIELD, SELECT_SQL_QUERY_FIELD, DATABASE_CREDENTIALS_FIELD, S3_STAGING_LOCATION_FIELD, DATA_REARRANGEMENT_FIELD, DATA_SCHEMA_FIELD, DATA_SCHEMA_URI_FIELD, RESOURCE_ROLE_FIELD, SERVICE_ROLE_FIELD, SUBNET_ID_FIELD, SECURITY_GROUP_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DatabaseInformation", DATABASE_INFORMATION_FIELD);
            this.put("SelectSqlQuery", SELECT_SQL_QUERY_FIELD);
            this.put("DatabaseCredentials", DATABASE_CREDENTIALS_FIELD);
            this.put("S3StagingLocation", S3_STAGING_LOCATION_FIELD);
            this.put("DataRearrangement", DATA_REARRANGEMENT_FIELD);
            this.put("DataSchema", DATA_SCHEMA_FIELD);
            this.put("DataSchemaUri", DATA_SCHEMA_URI_FIELD);
            this.put("ResourceRole", RESOURCE_ROLE_FIELD);
            this.put("ServiceRole", SERVICE_ROLE_FIELD);
            this.put("SubnetId", SUBNET_ID_FIELD);
            this.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final RDSDatabase databaseInformation;
    private final String selectSqlQuery;
    private final RDSDatabaseCredentials databaseCredentials;
    private final String s3StagingLocation;
    private final String dataRearrangement;
    private final String dataSchema;
    private final String dataSchemaUri;
    private final String resourceRole;
    private final String serviceRole;
    private final String subnetId;
    private final List<String> securityGroupIds;

    private RDSDataSpec(BuilderImpl builder) {
        this.databaseInformation = builder.databaseInformation;
        this.selectSqlQuery = builder.selectSqlQuery;
        this.databaseCredentials = builder.databaseCredentials;
        this.s3StagingLocation = builder.s3StagingLocation;
        this.dataRearrangement = builder.dataRearrangement;
        this.dataSchema = builder.dataSchema;
        this.dataSchemaUri = builder.dataSchemaUri;
        this.resourceRole = builder.resourceRole;
        this.serviceRole = builder.serviceRole;
        this.subnetId = builder.subnetId;
        this.securityGroupIds = builder.securityGroupIds;
    }

    public final RDSDatabase databaseInformation() {
        return this.databaseInformation;
    }

    public final String selectSqlQuery() {
        return this.selectSqlQuery;
    }

    public final RDSDatabaseCredentials databaseCredentials() {
        return this.databaseCredentials;
    }

    public final String s3StagingLocation() {
        return this.s3StagingLocation;
    }

    public final String dataRearrangement() {
        return this.dataRearrangement;
    }

    public final String dataSchema() {
        return this.dataSchema;
    }

    public final String dataSchemaUri() {
        return this.dataSchemaUri;
    }

    public final String resourceRole() {
        return this.resourceRole;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectSqlQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3StagingLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRearrangement());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSchemaUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDataSpec)) {
            return false;
        }
        RDSDataSpec other = (RDSDataSpec)obj;
        return Objects.equals(this.databaseInformation(), other.databaseInformation()) && Objects.equals(this.selectSqlQuery(), other.selectSqlQuery()) && Objects.equals(this.databaseCredentials(), other.databaseCredentials()) && Objects.equals(this.s3StagingLocation(), other.s3StagingLocation()) && Objects.equals(this.dataRearrangement(), other.dataRearrangement()) && Objects.equals(this.dataSchema(), other.dataSchema()) && Objects.equals(this.dataSchemaUri(), other.dataSchemaUri()) && Objects.equals(this.resourceRole(), other.resourceRole()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.subnetId(), other.subnetId()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds());
    }

    public final String toString() {
        return ToString.builder((String)"RDSDataSpec").add("DatabaseInformation", (Object)this.databaseInformation()).add("SelectSqlQuery", (Object)this.selectSqlQuery()).add("DatabaseCredentials", (Object)this.databaseCredentials()).add("S3StagingLocation", (Object)this.s3StagingLocation()).add("DataRearrangement", (Object)this.dataRearrangement()).add("DataSchema", (Object)this.dataSchema()).add("DataSchemaUri", (Object)this.dataSchemaUri()).add("ResourceRole", (Object)this.resourceRole()).add("ServiceRole", (Object)this.serviceRole()).add("SubnetId", (Object)this.subnetId()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseInformation": {
                return Optional.ofNullable(clazz.cast(this.databaseInformation()));
            }
            case "SelectSqlQuery": {
                return Optional.ofNullable(clazz.cast(this.selectSqlQuery()));
            }
            case "DatabaseCredentials": {
                return Optional.ofNullable(clazz.cast(this.databaseCredentials()));
            }
            case "S3StagingLocation": {
                return Optional.ofNullable(clazz.cast(this.s3StagingLocation()));
            }
            case "DataRearrangement": {
                return Optional.ofNullable(clazz.cast(this.dataRearrangement()));
            }
            case "DataSchema": {
                return Optional.ofNullable(clazz.cast(this.dataSchema()));
            }
            case "DataSchemaUri": {
                return Optional.ofNullable(clazz.cast(this.dataSchemaUri()));
            }
            case "ResourceRole": {
                return Optional.ofNullable(clazz.cast(this.resourceRole()));
            }
            case "ServiceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RDSDataSpec, T> g) {
        return obj -> g.apply((RDSDataSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RDSDatabase databaseInformation;
        private String selectSqlQuery;
        private RDSDatabaseCredentials databaseCredentials;
        private String s3StagingLocation;
        private String dataRearrangement;
        private String dataSchema;
        private String dataSchemaUri;
        private String resourceRole;
        private String serviceRole;
        private String subnetId;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDataSpec model) {
            this.databaseInformation(model.databaseInformation);
            this.selectSqlQuery(model.selectSqlQuery);
            this.databaseCredentials(model.databaseCredentials);
            this.s3StagingLocation(model.s3StagingLocation);
            this.dataRearrangement(model.dataRearrangement);
            this.dataSchema(model.dataSchema);
            this.dataSchemaUri(model.dataSchemaUri);
            this.resourceRole(model.resourceRole);
            this.serviceRole(model.serviceRole);
            this.subnetId(model.subnetId);
            this.securityGroupIds(model.securityGroupIds);
        }

        public final RDSDatabase.Builder getDatabaseInformation() {
            return this.databaseInformation != null ? this.databaseInformation.toBuilder() : null;
        }

        public final void setDatabaseInformation(RDSDatabase.BuilderImpl databaseInformation) {
            this.databaseInformation = databaseInformation != null ? databaseInformation.build() : null;
        }

        @Override
        public final Builder databaseInformation(RDSDatabase databaseInformation) {
            this.databaseInformation = databaseInformation;
            return this;
        }

        public final String getSelectSqlQuery() {
            return this.selectSqlQuery;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final RDSDatabaseCredentials.Builder getDatabaseCredentials() {
            return this.databaseCredentials != null ? this.databaseCredentials.toBuilder() : null;
        }

        public final void setDatabaseCredentials(RDSDatabaseCredentials.BuilderImpl databaseCredentials) {
            this.databaseCredentials = databaseCredentials != null ? databaseCredentials.build() : null;
        }

        @Override
        public final Builder databaseCredentials(RDSDatabaseCredentials databaseCredentials) {
            this.databaseCredentials = databaseCredentials;
            return this;
        }

        public final String getS3StagingLocation() {
            return this.s3StagingLocation;
        }

        public final void setS3StagingLocation(String s3StagingLocation) {
            this.s3StagingLocation = s3StagingLocation;
        }

        @Override
        public final Builder s3StagingLocation(String s3StagingLocation) {
            this.s3StagingLocation = s3StagingLocation;
            return this;
        }

        public final String getDataRearrangement() {
            return this.dataRearrangement;
        }

        public final void setDataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
        }

        @Override
        public final Builder dataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
            return this;
        }

        public final String getDataSchema() {
            return this.dataSchema;
        }

        public final void setDataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
        }

        @Override
        public final Builder dataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
            return this;
        }

        public final String getDataSchemaUri() {
            return this.dataSchemaUri;
        }

        public final void setDataSchemaUri(String dataSchemaUri) {
            this.dataSchemaUri = dataSchemaUri;
        }

        @Override
        public final Builder dataSchemaUri(String dataSchemaUri) {
            this.dataSchemaUri = dataSchemaUri;
            return this;
        }

        public final String getResourceRole() {
            return this.resourceRole;
        }

        public final void setResourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
        }

        @Override
        public final Builder resourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = EDPSecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = EDPSecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public RDSDataSpec build() {
            return new RDSDataSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RDSDataSpec> {
        public Builder databaseInformation(RDSDatabase var1);

        default public Builder databaseInformation(Consumer<RDSDatabase.Builder> databaseInformation) {
            return this.databaseInformation((RDSDatabase)((RDSDatabase.Builder)RDSDatabase.builder().applyMutation(databaseInformation)).build());
        }

        public Builder selectSqlQuery(String var1);

        public Builder databaseCredentials(RDSDatabaseCredentials var1);

        default public Builder databaseCredentials(Consumer<RDSDatabaseCredentials.Builder> databaseCredentials) {
            return this.databaseCredentials((RDSDatabaseCredentials)((RDSDatabaseCredentials.Builder)RDSDatabaseCredentials.builder().applyMutation(databaseCredentials)).build());
        }

        public Builder s3StagingLocation(String var1);

        public Builder dataRearrangement(String var1);

        public Builder dataSchema(String var1);

        public Builder dataSchemaUri(String var1);

        public Builder resourceRole(String var1);

        public Builder serviceRole(String var1);

        public Builder subnetId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);
    }
}

