/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.RedshiftDatabase;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RedshiftDatabaseMarshaller {
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final MarshallingInfo<String> CLUSTERIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterIdentifier").isBinary(false).build();
    private static final RedshiftDatabaseMarshaller INSTANCE = new RedshiftDatabaseMarshaller();

    private RedshiftDatabaseMarshaller() {
    }

    public static RedshiftDatabaseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RedshiftDatabase redshiftDatabase, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)redshiftDatabase, (String)"redshiftDatabase");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)redshiftDatabase.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)redshiftDatabase.clusterIdentifier(), CLUSTERIDENTIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

