/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.GetDataSourceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetDataSourceRequestModelMarshaller {
    private static final MarshallingInfo<String> DATASOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSourceId").isBinary(false).build();
    private static final MarshallingInfo<Boolean> VERBOSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Verbose").isBinary(false).build();
    private static final GetDataSourceRequestModelMarshaller INSTANCE = new GetDataSourceRequestModelMarshaller();

    private GetDataSourceRequestModelMarshaller() {
    }

    public static GetDataSourceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetDataSourceRequest getDataSourceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getDataSourceRequest), (String)"getDataSourceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getDataSourceRequest.dataSourceId(), DATASOURCEID_BINDING);
            protocolMarshaller.marshall((Object)getDataSourceRequest.verbose(), VERBOSE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

