/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDataSourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateDataSourceRequest> {
    private final String dataSourceId;
    private final String dataSourceName;

    private UpdateDataSourceRequest(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
    }

    public String dataSourceId() {
        return this.dataSourceId;
    }

    public String dataSourceName() {
        return this.dataSourceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dataSourceId() == null ? 0 : this.dataSourceId().hashCode());
        hashCode = 31 * hashCode + (this.dataSourceName() == null ? 0 : this.dataSourceName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourceRequest)) {
            return false;
        }
        UpdateDataSourceRequest other = (UpdateDataSourceRequest)((Object)obj);
        if (other.dataSourceId() == null ^ this.dataSourceId() == null) {
            return false;
        }
        if (other.dataSourceId() != null && !other.dataSourceId().equals(this.dataSourceId())) {
            return false;
        }
        if (other.dataSourceName() == null ^ this.dataSourceName() == null) {
            return false;
        }
        return other.dataSourceName() == null || other.dataSourceName().equals(this.dataSourceName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dataSourceId() != null) {
            sb.append("DataSourceId: ").append(this.dataSourceId()).append(",");
        }
        if (this.dataSourceName() != null) {
            sb.append("DataSourceName: ").append(this.dataSourceName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.of(clazz.cast(this.dataSourceId()));
            }
            case "DataSourceName": {
                return Optional.of(clazz.cast(this.dataSourceName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String dataSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourceRequest model) {
            this.dataSourceId(model.dataSourceId);
            this.dataSourceName(model.dataSourceName);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public UpdateDataSourceRequest build() {
            return new UpdateDataSourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateDataSourceRequest> {
        public Builder dataSourceId(String var1);

        public Builder dataSourceName(String var1);
    }
}

