/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.RDSDatabase;

@SdkInternalApi
public class RDSDatabaseMarshaller {
    private static final MarshallingInfo<String> INSTANCEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceIdentifier").build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").build();
    private static final RDSDatabaseMarshaller INSTANCE = new RDSDatabaseMarshaller();

    public static RDSDatabaseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RDSDatabase rdsDatabase, ProtocolMarshaller protocolMarshaller) {
        if (rdsDatabase == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)rdsDatabase.instanceIdentifier(), INSTANCEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)rdsDatabase.databaseName(), DATABASENAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

