/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.protocol.OperationInfo;
import software.amazon.awssdk.protocol.Protocol;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.machinelearning.model.GetDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.transform.GetDataSourceRequestModelMarshaller;

@SdkInternalApi
public class GetDataSourceRequestMarshaller
implements Marshaller<Request<GetDataSourceRequest>, GetDataSourceRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON).requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AmazonML_20141212.GetDataSource").serviceName("MachineLearningClient").build();
    private final SdkJsonProtocolFactory protocolFactory;

    public GetDataSourceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetDataSourceRequest> marshall(GetDataSourceRequest getDataSourceRequest) {
        if (getDataSourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (Object)getDataSourceRequest);
            protocolMarshaller.startMarshalling();
            GetDataSourceRequestModelMarshaller.getInstance().marshall(getDataSourceRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

