/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.internal;

import java.util.UUID;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRdsRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Request;
import software.amazon.awssdk.services.machinelearning.model.CreateEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateMlModelRequest;

@SdkProtectedApi
@ReviewBeforeRelease(value="They should be using the idempotency trait")
public final class RandomIdInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest request = context.request();
        if (request instanceof CreateBatchPredictionRequest) {
            CreateBatchPredictionRequest copy = (CreateBatchPredictionRequest)request;
            if (copy.batchPredictionDataSourceId() == null) {
                return (SdkRequest)copy.toBuilder().batchPredictionDataSourceId(UUID.randomUUID().toString()).build();
            }
            return copy;
        }
        if (request instanceof CreateDataSourceFromRdsRequest) {
            CreateDataSourceFromRdsRequest copy = (CreateDataSourceFromRdsRequest)request;
            if (copy.dataSourceId() == null) {
                copy = (CreateDataSourceFromRdsRequest)((Object)copy.toBuilder().dataSourceId(UUID.randomUUID().toString()).build());
            }
            return copy;
        }
        if (request instanceof CreateDataSourceFromRedshiftRequest) {
            CreateDataSourceFromRedshiftRequest copy = (CreateDataSourceFromRedshiftRequest)request;
            if (copy.dataSourceId() == null) {
                copy = (CreateDataSourceFromRedshiftRequest)((Object)copy.toBuilder().dataSourceId(UUID.randomUUID().toString()).build());
            }
            return copy;
        }
        if (request instanceof CreateDataSourceFromS3Request) {
            CreateDataSourceFromS3Request copy = (CreateDataSourceFromS3Request)request;
            if (copy.dataSourceId() == null) {
                copy = (CreateDataSourceFromS3Request)((Object)copy.toBuilder().dataSourceId(UUID.randomUUID().toString()).build());
            }
            return copy;
        }
        if (request instanceof CreateEvaluationRequest) {
            CreateEvaluationRequest copy = (CreateEvaluationRequest)request;
            if (copy.evaluationId() == null) {
                copy = (CreateEvaluationRequest)((Object)copy.toBuilder().evaluationId(UUID.randomUUID().toString()).build());
            }
            return copy;
        }
        if (request instanceof CreateMlModelRequest) {
            CreateMlModelRequest copy = (CreateMlModelRequest)request;
            if (copy.mlModelId() == null) {
                copy = (CreateMlModelRequest)((Object)copy.toBuilder().mlModelId(UUID.randomUUID().toString()).build());
            }
            return copy;
        }
        return request;
    }
}

