/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRdsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateDataSourceFromRdsRequestModelMarshaller {
    private static final MarshallingInfo<String> DATASOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSourceId").isBinary(false).build();
    private static final MarshallingInfo<String> DATASOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSourceName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RDSDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RDSData").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final MarshallingInfo<Boolean> COMPUTESTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeStatistics").isBinary(false).build();
    private static final CreateDataSourceFromRdsRequestModelMarshaller INSTANCE = new CreateDataSourceFromRdsRequestModelMarshaller();

    private CreateDataSourceFromRdsRequestModelMarshaller() {
    }

    public static CreateDataSourceFromRdsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateDataSourceFromRdsRequest createDataSourceFromRdsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createDataSourceFromRdsRequest), (String)"createDataSourceFromRdsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createDataSourceFromRdsRequest.dataSourceId(), DATASOURCEID_BINDING);
            protocolMarshaller.marshall((Object)createDataSourceFromRdsRequest.dataSourceName(), DATASOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)createDataSourceFromRdsRequest.rdsData(), RDSDATA_BINDING);
            protocolMarshaller.marshall((Object)createDataSourceFromRdsRequest.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)createDataSourceFromRdsRequest.computeStatistics(), COMPUTESTATISTICS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

