/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Date;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.machinelearning.model.EntityStatus;
import software.amazon.awssdk.services.machinelearning.model.MLModelType;
import software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointInfo;
import software.amazon.awssdk.services.machinelearning.model.TrainingParametersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMLModelResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetMLModelResponse> {
    private final String mlModelId;
    private final String trainingDataSourceId;
    private final String createdByIamUser;
    private final Date createdAt;
    private final Date lastUpdatedAt;
    private final String name;
    private final String status;
    private final Long sizeInBytes;
    private final RealtimeEndpointInfo endpointInfo;
    private final Map<String, String> trainingParameters;
    private final String inputDataLocationS3;
    private final String mlModelType;
    private final Float scoreThreshold;
    private final Date scoreThresholdLastUpdatedAt;
    private final String logUri;
    private final String message;
    private final Long computeTime;
    private final Date finishedAt;
    private final Date startedAt;
    private final String recipe;
    private final String schema;

    private GetMLModelResponse(BuilderImpl builder) {
        this.mlModelId = builder.mlModelId;
        this.trainingDataSourceId = builder.trainingDataSourceId;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.sizeInBytes = builder.sizeInBytes;
        this.endpointInfo = builder.endpointInfo;
        this.trainingParameters = builder.trainingParameters;
        this.inputDataLocationS3 = builder.inputDataLocationS3;
        this.mlModelType = builder.mlModelType;
        this.scoreThreshold = builder.scoreThreshold;
        this.scoreThresholdLastUpdatedAt = builder.scoreThresholdLastUpdatedAt;
        this.logUri = builder.logUri;
        this.message = builder.message;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
        this.recipe = builder.recipe;
        this.schema = builder.schema;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public String trainingDataSourceId() {
        return this.trainingDataSourceId;
    }

    public String createdByIamUser() {
        return this.createdByIamUser;
    }

    public Date createdAt() {
        return this.createdAt;
    }

    public Date lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public String name() {
        return this.name;
    }

    public String status() {
        return this.status;
    }

    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public RealtimeEndpointInfo endpointInfo() {
        return this.endpointInfo;
    }

    public Map<String, String> trainingParameters() {
        return this.trainingParameters;
    }

    public String inputDataLocationS3() {
        return this.inputDataLocationS3;
    }

    public String mlModelType() {
        return this.mlModelType;
    }

    public Float scoreThreshold() {
        return this.scoreThreshold;
    }

    public Date scoreThresholdLastUpdatedAt() {
        return this.scoreThresholdLastUpdatedAt;
    }

    public String logUri() {
        return this.logUri;
    }

    public String message() {
        return this.message;
    }

    public Long computeTime() {
        return this.computeTime;
    }

    public Date finishedAt() {
        return this.finishedAt;
    }

    public Date startedAt() {
        return this.startedAt;
    }

    public String recipe() {
        return this.recipe;
    }

    public String schema() {
        return this.schema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.mlModelId() == null ? 0 : this.mlModelId().hashCode());
        hashCode = 31 * hashCode + (this.trainingDataSourceId() == null ? 0 : this.trainingDataSourceId().hashCode());
        hashCode = 31 * hashCode + (this.createdByIamUser() == null ? 0 : this.createdByIamUser().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedAt() == null ? 0 : this.lastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.sizeInBytes() == null ? 0 : this.sizeInBytes().hashCode());
        hashCode = 31 * hashCode + (this.endpointInfo() == null ? 0 : this.endpointInfo().hashCode());
        hashCode = 31 * hashCode + (this.trainingParameters() == null ? 0 : this.trainingParameters().hashCode());
        hashCode = 31 * hashCode + (this.inputDataLocationS3() == null ? 0 : this.inputDataLocationS3().hashCode());
        hashCode = 31 * hashCode + (this.mlModelType() == null ? 0 : this.mlModelType().hashCode());
        hashCode = 31 * hashCode + (this.scoreThreshold() == null ? 0 : this.scoreThreshold().hashCode());
        hashCode = 31 * hashCode + (this.scoreThresholdLastUpdatedAt() == null ? 0 : this.scoreThresholdLastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.logUri() == null ? 0 : this.logUri().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.computeTime() == null ? 0 : this.computeTime().hashCode());
        hashCode = 31 * hashCode + (this.finishedAt() == null ? 0 : this.finishedAt().hashCode());
        hashCode = 31 * hashCode + (this.startedAt() == null ? 0 : this.startedAt().hashCode());
        hashCode = 31 * hashCode + (this.recipe() == null ? 0 : this.recipe().hashCode());
        hashCode = 31 * hashCode + (this.schema() == null ? 0 : this.schema().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMLModelResponse)) {
            return false;
        }
        GetMLModelResponse other = (GetMLModelResponse)((Object)obj);
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.trainingDataSourceId() == null ^ this.trainingDataSourceId() == null) {
            return false;
        }
        if (other.trainingDataSourceId() != null && !other.trainingDataSourceId().equals(this.trainingDataSourceId())) {
            return false;
        }
        if (other.createdByIamUser() == null ^ this.createdByIamUser() == null) {
            return false;
        }
        if (other.createdByIamUser() != null && !other.createdByIamUser().equals(this.createdByIamUser())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.lastUpdatedAt() == null ^ this.lastUpdatedAt() == null) {
            return false;
        }
        if (other.lastUpdatedAt() != null && !other.lastUpdatedAt().equals(this.lastUpdatedAt())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.sizeInBytes() == null ^ this.sizeInBytes() == null) {
            return false;
        }
        if (other.sizeInBytes() != null && !other.sizeInBytes().equals(this.sizeInBytes())) {
            return false;
        }
        if (other.endpointInfo() == null ^ this.endpointInfo() == null) {
            return false;
        }
        if (other.endpointInfo() != null && !other.endpointInfo().equals(this.endpointInfo())) {
            return false;
        }
        if (other.trainingParameters() == null ^ this.trainingParameters() == null) {
            return false;
        }
        if (other.trainingParameters() != null && !other.trainingParameters().equals(this.trainingParameters())) {
            return false;
        }
        if (other.inputDataLocationS3() == null ^ this.inputDataLocationS3() == null) {
            return false;
        }
        if (other.inputDataLocationS3() != null && !other.inputDataLocationS3().equals(this.inputDataLocationS3())) {
            return false;
        }
        if (other.mlModelType() == null ^ this.mlModelType() == null) {
            return false;
        }
        if (other.mlModelType() != null && !other.mlModelType().equals(this.mlModelType())) {
            return false;
        }
        if (other.scoreThreshold() == null ^ this.scoreThreshold() == null) {
            return false;
        }
        if (other.scoreThreshold() != null && !other.scoreThreshold().equals(this.scoreThreshold())) {
            return false;
        }
        if (other.scoreThresholdLastUpdatedAt() == null ^ this.scoreThresholdLastUpdatedAt() == null) {
            return false;
        }
        if (other.scoreThresholdLastUpdatedAt() != null && !other.scoreThresholdLastUpdatedAt().equals(this.scoreThresholdLastUpdatedAt())) {
            return false;
        }
        if (other.logUri() == null ^ this.logUri() == null) {
            return false;
        }
        if (other.logUri() != null && !other.logUri().equals(this.logUri())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.computeTime() == null ^ this.computeTime() == null) {
            return false;
        }
        if (other.computeTime() != null && !other.computeTime().equals(this.computeTime())) {
            return false;
        }
        if (other.finishedAt() == null ^ this.finishedAt() == null) {
            return false;
        }
        if (other.finishedAt() != null && !other.finishedAt().equals(this.finishedAt())) {
            return false;
        }
        if (other.startedAt() == null ^ this.startedAt() == null) {
            return false;
        }
        if (other.startedAt() != null && !other.startedAt().equals(this.startedAt())) {
            return false;
        }
        if (other.recipe() == null ^ this.recipe() == null) {
            return false;
        }
        if (other.recipe() != null && !other.recipe().equals(this.recipe())) {
            return false;
        }
        if (other.schema() == null ^ this.schema() == null) {
            return false;
        }
        return other.schema() == null || other.schema().equals(this.schema());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mlModelId() != null) {
            sb.append("MLModelId: ").append(this.mlModelId()).append(",");
        }
        if (this.trainingDataSourceId() != null) {
            sb.append("TrainingDataSourceId: ").append(this.trainingDataSourceId()).append(",");
        }
        if (this.createdByIamUser() != null) {
            sb.append("CreatedByIamUser: ").append(this.createdByIamUser()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.lastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.lastUpdatedAt()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.sizeInBytes() != null) {
            sb.append("SizeInBytes: ").append(this.sizeInBytes()).append(",");
        }
        if (this.endpointInfo() != null) {
            sb.append("EndpointInfo: ").append(this.endpointInfo()).append(",");
        }
        if (this.trainingParameters() != null) {
            sb.append("TrainingParameters: ").append(this.trainingParameters()).append(",");
        }
        if (this.inputDataLocationS3() != null) {
            sb.append("InputDataLocationS3: ").append(this.inputDataLocationS3()).append(",");
        }
        if (this.mlModelType() != null) {
            sb.append("MLModelType: ").append(this.mlModelType()).append(",");
        }
        if (this.scoreThreshold() != null) {
            sb.append("ScoreThreshold: ").append(this.scoreThreshold()).append(",");
        }
        if (this.scoreThresholdLastUpdatedAt() != null) {
            sb.append("ScoreThresholdLastUpdatedAt: ").append(this.scoreThresholdLastUpdatedAt()).append(",");
        }
        if (this.logUri() != null) {
            sb.append("LogUri: ").append(this.logUri()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.computeTime() != null) {
            sb.append("ComputeTime: ").append(this.computeTime()).append(",");
        }
        if (this.finishedAt() != null) {
            sb.append("FinishedAt: ").append(this.finishedAt()).append(",");
        }
        if (this.startedAt() != null) {
            sb.append("StartedAt: ").append(this.startedAt()).append(",");
        }
        if (this.recipe() != null) {
            sb.append("Recipe: ").append(this.recipe()).append(",");
        }
        if (this.schema() != null) {
            sb.append("Schema: ").append(this.schema()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String mlModelId;
        private String trainingDataSourceId;
        private String createdByIamUser;
        private Date createdAt;
        private Date lastUpdatedAt;
        private String name;
        private String status;
        private Long sizeInBytes;
        private RealtimeEndpointInfo endpointInfo;
        private Map<String, String> trainingParameters = new SdkInternalMap();
        private String inputDataLocationS3;
        private String mlModelType;
        private Float scoreThreshold;
        private Date scoreThresholdLastUpdatedAt;
        private String logUri;
        private String message;
        private Long computeTime;
        private Date finishedAt;
        private Date startedAt;
        private String recipe;
        private String schema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMLModelResponse model) {
            this.setMLModelId(model.mlModelId);
            this.setTrainingDataSourceId(model.trainingDataSourceId);
            this.setCreatedByIamUser(model.createdByIamUser);
            this.setCreatedAt(model.createdAt);
            this.setLastUpdatedAt(model.lastUpdatedAt);
            this.setName(model.name);
            this.setStatus(model.status);
            this.setSizeInBytes(model.sizeInBytes);
            this.setEndpointInfo(model.endpointInfo);
            this.setTrainingParameters(model.trainingParameters);
            this.setInputDataLocationS3(model.inputDataLocationS3);
            this.setMLModelType(model.mlModelType);
            this.setScoreThreshold(model.scoreThreshold);
            this.setScoreThresholdLastUpdatedAt(model.scoreThresholdLastUpdatedAt);
            this.setLogUri(model.logUri);
            this.setMessage(model.message);
            this.setComputeTime(model.computeTime);
            this.setFinishedAt(model.finishedAt);
            this.setStartedAt(model.startedAt);
            this.setRecipe(model.recipe);
            this.setSchema(model.schema);
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getTrainingDataSourceId() {
            return this.trainingDataSourceId;
        }

        @Override
        public final Builder trainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
            return this;
        }

        public final void setTrainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
        }

        public final String getCreatedByIamUser() {
            return this.createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        public final Date getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Date createdAt) {
            this.createdAt = StandardMemberCopier.copy((Date)createdAt);
            return this;
        }

        public final void setCreatedAt(Date createdAt) {
            this.createdAt = StandardMemberCopier.copy((Date)createdAt);
        }

        public final Date getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Date lastUpdatedAt) {
            this.lastUpdatedAt = StandardMemberCopier.copy((Date)lastUpdatedAt);
            return this;
        }

        public final void setLastUpdatedAt(Date lastUpdatedAt) {
            this.lastUpdatedAt = StandardMemberCopier.copy((Date)lastUpdatedAt);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(EntityStatus status) {
            this.status(status.toString());
        }

        public final Long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public final RealtimeEndpointInfo getEndpointInfo() {
            return this.endpointInfo;
        }

        @Override
        public final Builder endpointInfo(RealtimeEndpointInfo endpointInfo) {
            this.endpointInfo = endpointInfo;
            return this;
        }

        public final void setEndpointInfo(RealtimeEndpointInfo endpointInfo) {
            this.endpointInfo = endpointInfo;
        }

        public final Map<String, String> getTrainingParameters() {
            return this.trainingParameters;
        }

        @Override
        public final Builder trainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
            return this;
        }

        public final void setTrainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
        }

        public final String getInputDataLocationS3() {
            return this.inputDataLocationS3;
        }

        @Override
        public final Builder inputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
            return this;
        }

        public final void setInputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
        }

        public final String getMLModelType() {
            return this.mlModelType;
        }

        @Override
        public final Builder mlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
            return this;
        }

        @Override
        public final Builder mlModelType(MLModelType mlModelType) {
            this.mlModelType(mlModelType.toString());
            return this;
        }

        public final void setMLModelType(String mlModelType) {
            this.mlModelType = mlModelType;
        }

        public final void setMLModelType(MLModelType mlModelType) {
            this.mlModelType(mlModelType.toString());
        }

        public final Float getScoreThreshold() {
            return this.scoreThreshold;
        }

        @Override
        public final Builder scoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
            return this;
        }

        public final void setScoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
        }

        public final Date getScoreThresholdLastUpdatedAt() {
            return this.scoreThresholdLastUpdatedAt;
        }

        @Override
        public final Builder scoreThresholdLastUpdatedAt(Date scoreThresholdLastUpdatedAt) {
            this.scoreThresholdLastUpdatedAt = StandardMemberCopier.copy((Date)scoreThresholdLastUpdatedAt);
            return this;
        }

        public final void setScoreThresholdLastUpdatedAt(Date scoreThresholdLastUpdatedAt) {
            this.scoreThresholdLastUpdatedAt = StandardMemberCopier.copy((Date)scoreThresholdLastUpdatedAt);
        }

        public final String getLogUri() {
            return this.logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Long getComputeTime() {
            return this.computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        public final Date getFinishedAt() {
            return this.finishedAt;
        }

        @Override
        public final Builder finishedAt(Date finishedAt) {
            this.finishedAt = StandardMemberCopier.copy((Date)finishedAt);
            return this;
        }

        public final void setFinishedAt(Date finishedAt) {
            this.finishedAt = StandardMemberCopier.copy((Date)finishedAt);
        }

        public final Date getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Date startedAt) {
            this.startedAt = StandardMemberCopier.copy((Date)startedAt);
            return this;
        }

        public final void setStartedAt(Date startedAt) {
            this.startedAt = StandardMemberCopier.copy((Date)startedAt);
        }

        public final String getRecipe() {
            return this.recipe;
        }

        @Override
        public final Builder recipe(String recipe) {
            this.recipe = recipe;
            return this;
        }

        public final void setRecipe(String recipe) {
            this.recipe = recipe;
        }

        public final String getSchema() {
            return this.schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        public GetMLModelResponse build() {
            return new GetMLModelResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetMLModelResponse> {
        public Builder mlModelId(String var1);

        public Builder trainingDataSourceId(String var1);

        public Builder createdByIamUser(String var1);

        public Builder createdAt(Date var1);

        public Builder lastUpdatedAt(Date var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(EntityStatus var1);

        public Builder sizeInBytes(Long var1);

        public Builder endpointInfo(RealtimeEndpointInfo var1);

        public Builder trainingParameters(Map<String, String> var1);

        public Builder inputDataLocationS3(String var1);

        public Builder mlModelType(String var1);

        public Builder mlModelType(MLModelType var1);

        public Builder scoreThreshold(Float var1);

        public Builder scoreThresholdLastUpdatedAt(Date var1);

        public Builder logUri(String var1);

        public Builder message(String var1);

        public Builder computeTime(Long var1);

        public Builder finishedAt(Date var1);

        public Builder startedAt(Date var1);

        public Builder recipe(String var1);

        public Builder schema(String var1);
    }
}

