/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information related to a job step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobStep implements SdkPojo, Serializable, ToCopyableBuilder<JobStep.Builder, JobStep> {
    private static final SdkField<String> PROC_STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("procStepName").getter(getter(JobStep::procStepName)).setter(setter(Builder::procStepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("procStepName").build()).build();

    private static final SdkField<Integer> PROC_STEP_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("procStepNumber").getter(getter(JobStep::procStepNumber)).setter(setter(Builder::procStepNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("procStepNumber").build()).build();

    private static final SdkField<Integer> STEP_CHECKPOINT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("stepCheckpoint").getter(getter(JobStep::stepCheckpoint)).setter(setter(Builder::stepCheckpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepCheckpoint").build()).build();

    private static final SdkField<String> STEP_CHECKPOINT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepCheckpointStatus").getter(getter(JobStep::stepCheckpointStatus))
            .setter(setter(Builder::stepCheckpointStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepCheckpointStatus").build())
            .build();

    private static final SdkField<Instant> STEP_CHECKPOINT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("stepCheckpointTime").getter(getter(JobStep::stepCheckpointTime))
            .setter(setter(Builder::stepCheckpointTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepCheckpointTime").build())
            .build();

    private static final SdkField<String> STEP_COND_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepCondCode").getter(getter(JobStep::stepCondCode)).setter(setter(Builder::stepCondCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepCondCode").build()).build();

    private static final SdkField<String> STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepName").getter(getter(JobStep::stepName)).setter(setter(Builder::stepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()).build();

    private static final SdkField<Integer> STEP_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("stepNumber").getter(getter(JobStep::stepNumber)).setter(setter(Builder::stepNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepNumber").build()).build();

    private static final SdkField<Boolean> STEP_RESTARTABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("stepRestartable").getter(getter(JobStep::stepRestartable)).setter(setter(Builder::stepRestartable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepRestartable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROC_STEP_NAME_FIELD,
            PROC_STEP_NUMBER_FIELD, STEP_CHECKPOINT_FIELD, STEP_CHECKPOINT_STATUS_FIELD, STEP_CHECKPOINT_TIME_FIELD,
            STEP_COND_CODE_FIELD, STEP_NAME_FIELD, STEP_NUMBER_FIELD, STEP_RESTARTABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String procStepName;

    private final Integer procStepNumber;

    private final Integer stepCheckpoint;

    private final String stepCheckpointStatus;

    private final Instant stepCheckpointTime;

    private final String stepCondCode;

    private final String stepName;

    private final Integer stepNumber;

    private final Boolean stepRestartable;

    private JobStep(BuilderImpl builder) {
        this.procStepName = builder.procStepName;
        this.procStepNumber = builder.procStepNumber;
        this.stepCheckpoint = builder.stepCheckpoint;
        this.stepCheckpointStatus = builder.stepCheckpointStatus;
        this.stepCheckpointTime = builder.stepCheckpointTime;
        this.stepCondCode = builder.stepCondCode;
        this.stepName = builder.stepName;
        this.stepNumber = builder.stepNumber;
        this.stepRestartable = builder.stepRestartable;
    }

    /**
     * <p>
     * The name of a procedure step.
     * </p>
     * 
     * @return The name of a procedure step.
     */
    public final String procStepName() {
        return procStepName;
    }

    /**
     * <p>
     * The number of a procedure step.
     * </p>
     * 
     * @return The number of a procedure step.
     */
    public final Integer procStepNumber() {
        return procStepNumber;
    }

    /**
     * <p>
     * A registered step-level checkpoint identifier that can be used for restarting an Amazon Web Services Blu Age
     * application batch job.
     * </p>
     * 
     * @return A registered step-level checkpoint identifier that can be used for restarting an Amazon Web Services Blu
     *         Age application batch job.
     */
    public final Integer stepCheckpoint() {
        return stepCheckpoint;
    }

    /**
     * <p>
     * The step-level checkpoint status for an Amazon Web Services Blu Age application batch job.
     * </p>
     * 
     * @return The step-level checkpoint status for an Amazon Web Services Blu Age application batch job.
     */
    public final String stepCheckpointStatus() {
        return stepCheckpointStatus;
    }

    /**
     * <p>
     * The step-level checkpoint status for an Amazon Web Services Blu Age application batch job.
     * </p>
     * 
     * @return The step-level checkpoint status for an Amazon Web Services Blu Age application batch job.
     */
    public final Instant stepCheckpointTime() {
        return stepCheckpointTime;
    }

    /**
     * <p>
     * The condition code of a step.
     * </p>
     * 
     * @return The condition code of a step.
     */
    public final String stepCondCode() {
        return stepCondCode;
    }

    /**
     * <p>
     * The name of a step.
     * </p>
     * 
     * @return The name of a step.
     */
    public final String stepName() {
        return stepName;
    }

    /**
     * <p>
     * The number of a step.
     * </p>
     * 
     * @return The number of a step.
     */
    public final Integer stepNumber() {
        return stepNumber;
    }

    /**
     * <p>
     * Specifies if a step can be restarted or not.
     * </p>
     * 
     * @return Specifies if a step can be restarted or not.
     */
    public final Boolean stepRestartable() {
        return stepRestartable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(procStepName());
        hashCode = 31 * hashCode + Objects.hashCode(procStepNumber());
        hashCode = 31 * hashCode + Objects.hashCode(stepCheckpoint());
        hashCode = 31 * hashCode + Objects.hashCode(stepCheckpointStatus());
        hashCode = 31 * hashCode + Objects.hashCode(stepCheckpointTime());
        hashCode = 31 * hashCode + Objects.hashCode(stepCondCode());
        hashCode = 31 * hashCode + Objects.hashCode(stepName());
        hashCode = 31 * hashCode + Objects.hashCode(stepNumber());
        hashCode = 31 * hashCode + Objects.hashCode(stepRestartable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobStep)) {
            return false;
        }
        JobStep other = (JobStep) obj;
        return Objects.equals(procStepName(), other.procStepName()) && Objects.equals(procStepNumber(), other.procStepNumber())
                && Objects.equals(stepCheckpoint(), other.stepCheckpoint())
                && Objects.equals(stepCheckpointStatus(), other.stepCheckpointStatus())
                && Objects.equals(stepCheckpointTime(), other.stepCheckpointTime())
                && Objects.equals(stepCondCode(), other.stepCondCode()) && Objects.equals(stepName(), other.stepName())
                && Objects.equals(stepNumber(), other.stepNumber()) && Objects.equals(stepRestartable(), other.stepRestartable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobStep").add("ProcStepName", procStepName()).add("ProcStepNumber", procStepNumber())
                .add("StepCheckpoint", stepCheckpoint()).add("StepCheckpointStatus", stepCheckpointStatus())
                .add("StepCheckpointTime", stepCheckpointTime()).add("StepCondCode", stepCondCode()).add("StepName", stepName())
                .add("StepNumber", stepNumber()).add("StepRestartable", stepRestartable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "procStepName":
            return Optional.ofNullable(clazz.cast(procStepName()));
        case "procStepNumber":
            return Optional.ofNullable(clazz.cast(procStepNumber()));
        case "stepCheckpoint":
            return Optional.ofNullable(clazz.cast(stepCheckpoint()));
        case "stepCheckpointStatus":
            return Optional.ofNullable(clazz.cast(stepCheckpointStatus()));
        case "stepCheckpointTime":
            return Optional.ofNullable(clazz.cast(stepCheckpointTime()));
        case "stepCondCode":
            return Optional.ofNullable(clazz.cast(stepCondCode()));
        case "stepName":
            return Optional.ofNullable(clazz.cast(stepName()));
        case "stepNumber":
            return Optional.ofNullable(clazz.cast(stepNumber()));
        case "stepRestartable":
            return Optional.ofNullable(clazz.cast(stepRestartable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("procStepName", PROC_STEP_NAME_FIELD);
        map.put("procStepNumber", PROC_STEP_NUMBER_FIELD);
        map.put("stepCheckpoint", STEP_CHECKPOINT_FIELD);
        map.put("stepCheckpointStatus", STEP_CHECKPOINT_STATUS_FIELD);
        map.put("stepCheckpointTime", STEP_CHECKPOINT_TIME_FIELD);
        map.put("stepCondCode", STEP_COND_CODE_FIELD);
        map.put("stepName", STEP_NAME_FIELD);
        map.put("stepNumber", STEP_NUMBER_FIELD);
        map.put("stepRestartable", STEP_RESTARTABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobStep, T> g) {
        return obj -> g.apply((JobStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobStep> {
        /**
         * <p>
         * The name of a procedure step.
         * </p>
         * 
         * @param procStepName
         *        The name of a procedure step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder procStepName(String procStepName);

        /**
         * <p>
         * The number of a procedure step.
         * </p>
         * 
         * @param procStepNumber
         *        The number of a procedure step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder procStepNumber(Integer procStepNumber);

        /**
         * <p>
         * A registered step-level checkpoint identifier that can be used for restarting an Amazon Web Services Blu Age
         * application batch job.
         * </p>
         * 
         * @param stepCheckpoint
         *        A registered step-level checkpoint identifier that can be used for restarting an Amazon Web Services
         *        Blu Age application batch job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepCheckpoint(Integer stepCheckpoint);

        /**
         * <p>
         * The step-level checkpoint status for an Amazon Web Services Blu Age application batch job.
         * </p>
         * 
         * @param stepCheckpointStatus
         *        The step-level checkpoint status for an Amazon Web Services Blu Age application batch job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepCheckpointStatus(String stepCheckpointStatus);

        /**
         * <p>
         * The step-level checkpoint status for an Amazon Web Services Blu Age application batch job.
         * </p>
         * 
         * @param stepCheckpointTime
         *        The step-level checkpoint status for an Amazon Web Services Blu Age application batch job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepCheckpointTime(Instant stepCheckpointTime);

        /**
         * <p>
         * The condition code of a step.
         * </p>
         * 
         * @param stepCondCode
         *        The condition code of a step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepCondCode(String stepCondCode);

        /**
         * <p>
         * The name of a step.
         * </p>
         * 
         * @param stepName
         *        The name of a step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepName(String stepName);

        /**
         * <p>
         * The number of a step.
         * </p>
         * 
         * @param stepNumber
         *        The number of a step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepNumber(Integer stepNumber);

        /**
         * <p>
         * Specifies if a step can be restarted or not.
         * </p>
         * 
         * @param stepRestartable
         *        Specifies if a step can be restarted or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepRestartable(Boolean stepRestartable);
    }

    static final class BuilderImpl implements Builder {
        private String procStepName;

        private Integer procStepNumber;

        private Integer stepCheckpoint;

        private String stepCheckpointStatus;

        private Instant stepCheckpointTime;

        private String stepCondCode;

        private String stepName;

        private Integer stepNumber;

        private Boolean stepRestartable;

        private BuilderImpl() {
        }

        private BuilderImpl(JobStep model) {
            procStepName(model.procStepName);
            procStepNumber(model.procStepNumber);
            stepCheckpoint(model.stepCheckpoint);
            stepCheckpointStatus(model.stepCheckpointStatus);
            stepCheckpointTime(model.stepCheckpointTime);
            stepCondCode(model.stepCondCode);
            stepName(model.stepName);
            stepNumber(model.stepNumber);
            stepRestartable(model.stepRestartable);
        }

        public final String getProcStepName() {
            return procStepName;
        }

        public final void setProcStepName(String procStepName) {
            this.procStepName = procStepName;
        }

        @Override
        public final Builder procStepName(String procStepName) {
            this.procStepName = procStepName;
            return this;
        }

        public final Integer getProcStepNumber() {
            return procStepNumber;
        }

        public final void setProcStepNumber(Integer procStepNumber) {
            this.procStepNumber = procStepNumber;
        }

        @Override
        public final Builder procStepNumber(Integer procStepNumber) {
            this.procStepNumber = procStepNumber;
            return this;
        }

        public final Integer getStepCheckpoint() {
            return stepCheckpoint;
        }

        public final void setStepCheckpoint(Integer stepCheckpoint) {
            this.stepCheckpoint = stepCheckpoint;
        }

        @Override
        public final Builder stepCheckpoint(Integer stepCheckpoint) {
            this.stepCheckpoint = stepCheckpoint;
            return this;
        }

        public final String getStepCheckpointStatus() {
            return stepCheckpointStatus;
        }

        public final void setStepCheckpointStatus(String stepCheckpointStatus) {
            this.stepCheckpointStatus = stepCheckpointStatus;
        }

        @Override
        public final Builder stepCheckpointStatus(String stepCheckpointStatus) {
            this.stepCheckpointStatus = stepCheckpointStatus;
            return this;
        }

        public final Instant getStepCheckpointTime() {
            return stepCheckpointTime;
        }

        public final void setStepCheckpointTime(Instant stepCheckpointTime) {
            this.stepCheckpointTime = stepCheckpointTime;
        }

        @Override
        public final Builder stepCheckpointTime(Instant stepCheckpointTime) {
            this.stepCheckpointTime = stepCheckpointTime;
            return this;
        }

        public final String getStepCondCode() {
            return stepCondCode;
        }

        public final void setStepCondCode(String stepCondCode) {
            this.stepCondCode = stepCondCode;
        }

        @Override
        public final Builder stepCondCode(String stepCondCode) {
            this.stepCondCode = stepCondCode;
            return this;
        }

        public final String getStepName() {
            return stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final Integer getStepNumber() {
            return stepNumber;
        }

        public final void setStepNumber(Integer stepNumber) {
            this.stepNumber = stepNumber;
        }

        @Override
        public final Builder stepNumber(Integer stepNumber) {
            this.stepNumber = stepNumber;
            return this;
        }

        public final Boolean getStepRestartable() {
            return stepRestartable;
        }

        public final void setStepRestartable(Boolean stepRestartable) {
            this.stepRestartable = stepRestartable;
        }

        @Override
        public final Builder stepRestartable(Boolean stepRestartable) {
            this.stepRestartable = stepRestartable;
            return this;
        }

        @Override
        public JobStep build() {
            return new JobStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
