/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The application definition for a particular application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Definition implements SdkPojo, Serializable, ToCopyableBuilder<Definition.Builder, Definition> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("content")
            .getter(getter(Definition::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3Location").getter(getter(Definition::s3Location)).setter(setter(Builder::s3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            S3_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String content;

    private final String s3Location;

    private final Type type;

    private Definition(BuilderImpl builder) {
        this.content = builder.content;
        this.s3Location = builder.s3Location;
        this.type = builder.type;
    }

    /**
     * <p>
     * The content of the application definition. This is a JSON object that contains the resource
     * configuration/definitions that identify an application.
     * </p>
     * 
     * @return The content of the application definition. This is a JSON object that contains the resource
     *         configuration/definitions that identify an application.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The S3 bucket that contains the application definition.
     * </p>
     * 
     * @return The S3 bucket that contains the application definition.
     */
    public final String s3Location() {
        return s3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Definition)) {
            return false;
        }
        Definition other = (Definition) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(s3Location(), other.s3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Definition").add("Content", content()).add("S3Location", s3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "s3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #content()} initialized to the given value.
     *
     * <p>
     * The content of the application definition. This is a JSON object that contains the resource
     * configuration/definitions that identify an application.
     * </p>
     * 
     * @param content
     *        The content of the application definition. This is a JSON object that contains the resource
     *        configuration/definitions that identify an application.
     */
    public static Definition fromContent(String content) {
        return builder().content(content).build();
    }

    /**
     * Create an instance of this class with {@link #s3Location()} initialized to the given value.
     *
     * <p>
     * The S3 bucket that contains the application definition.
     * </p>
     * 
     * @param s3Location
     *        The S3 bucket that contains the application definition.
     */
    public static Definition fromS3Location(String s3Location) {
        return builder().s3Location(s3Location).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("s3Location", S3_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Definition, T> g) {
        return obj -> g.apply((Definition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Definition> {
        /**
         * <p>
         * The content of the application definition. This is a JSON object that contains the resource
         * configuration/definitions that identify an application.
         * </p>
         * 
         * @param content
         *        The content of the application definition. This is a JSON object that contains the resource
         *        configuration/definitions that identify an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The S3 bucket that contains the application definition.
         * </p>
         * 
         * @param s3Location
         *        The S3 bucket that contains the application definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(String s3Location);
    }

    static final class BuilderImpl implements Builder {
        private String content;

        private String s3Location;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Definition model) {
            content(model.content);
            s3Location(model.s3Location);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            Object oldValue = this.content;
            this.content = content;
            handleUnionValueChange(Type.CONTENT, oldValue, this.content);
        }

        @Override
        public final Builder content(String content) {
            Object oldValue = this.content;
            this.content = content;
            handleUnionValueChange(Type.CONTENT, oldValue, this.content);
            return this;
        }

        public final String getS3Location() {
            return s3Location;
        }

        public final void setS3Location(String s3Location) {
            Object oldValue = this.s3Location;
            this.s3Location = s3Location;
            handleUnionValueChange(Type.S3_LOCATION, oldValue, this.s3Location);
        }

        @Override
        public final Builder s3Location(String s3Location) {
            Object oldValue = this.s3Location;
            this.s3Location = s3Location;
            handleUnionValueChange(Type.S3_LOCATION, oldValue, this.s3Location);
            return this;
        }

        @Override
        public Definition build() {
            return new Definition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Definition#type()
     */
    public enum Type {
        CONTENT,

        S3_LOCATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
