/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentRequest extends M2Request implements
        ToCopyableBuilder<CreateEnvironmentRequest.Builder, CreateEnvironmentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateEnvironmentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateEnvironmentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineType").getter(getter(CreateEnvironmentRequest::engineTypeAsString))
            .setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineVersion").getter(getter(CreateEnvironmentRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final SdkField<HighAvailabilityConfig> HIGH_AVAILABILITY_CONFIG_FIELD = SdkField
            .<HighAvailabilityConfig> builder(MarshallingType.SDK_POJO).memberName("highAvailabilityConfig")
            .getter(getter(CreateEnvironmentRequest::highAvailabilityConfig)).setter(setter(Builder::highAvailabilityConfig))
            .constructor(HighAvailabilityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("highAvailabilityConfig").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(CreateEnvironmentRequest::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(CreateEnvironmentRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateEnvironmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkType").getter(getter(CreateEnvironmentRequest::networkTypeAsString))
            .setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkType").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("preferredMaintenanceWindow")
            .getter(getter(CreateEnvironmentRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publiclyAccessible").getter(getter(CreateEnvironmentRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(CreateEnvironmentRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StorageConfiguration>> STORAGE_CONFIGURATIONS_FIELD = SdkField
            .<List<StorageConfiguration>> builder(MarshallingType.LIST)
            .memberName("storageConfigurations")
            .getter(getter(CreateEnvironmentRequest::storageConfigurations))
            .setter(setter(Builder::storageConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StorageConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(CreateEnvironmentRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateEnvironmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, ENGINE_TYPE_FIELD, ENGINE_VERSION_FIELD, HIGH_AVAILABILITY_CONFIG_FIELD, INSTANCE_TYPE_FIELD,
            KMS_KEY_ID_FIELD, NAME_FIELD, NETWORK_TYPE_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PUBLICLY_ACCESSIBLE_FIELD,
            SECURITY_GROUP_IDS_FIELD, STORAGE_CONFIGURATIONS_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String description;

    private final String engineType;

    private final String engineVersion;

    private final HighAvailabilityConfig highAvailabilityConfig;

    private final String instanceType;

    private final String kmsKeyId;

    private final String name;

    private final String networkType;

    private final String preferredMaintenanceWindow;

    private final Boolean publiclyAccessible;

    private final List<String> securityGroupIds;

    private final List<StorageConfiguration> storageConfigurations;

    private final List<String> subnetIds;

    private final Map<String, String> tags;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.highAvailabilityConfig = builder.highAvailabilityConfig;
        this.instanceType = builder.instanceType;
        this.kmsKeyId = builder.kmsKeyId;
        this.name = builder.name;
        this.networkType = builder.networkType;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroupIds = builder.securityGroupIds;
        this.storageConfigurations = builder.storageConfigurations;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create an environment.
     * The service generates the clientToken when the API call is triggered. The token expires after one hour, so if you
     * retry the API within this timeframe with the same clientToken, you will get the same response. The service also
     * handles deleting the clientToken after it expires.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create an
     *         environment. The service generates the clientToken when the API call is triggered. The token expires
     *         after one hour, so if you retry the API within this timeframe with the same clientToken, you will get the
     *         same response. The service also handles deleting the clientToken after it expires.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description of the runtime environment.
     * </p>
     * 
     * @return The description of the runtime environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The engine type for the runtime environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The engine type for the runtime environment.
     * @see EngineType
     */
    public final EngineType engineType() {
        return EngineType.fromValue(engineType);
    }

    /**
     * <p>
     * The engine type for the runtime environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The engine type for the runtime environment.
     * @see EngineType
     */
    public final String engineTypeAsString() {
        return engineType;
    }

    /**
     * <p>
     * The version of the engine type for the runtime environment.
     * </p>
     * 
     * @return The version of the engine type for the runtime environment.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The details of a high availability configuration for this runtime environment.
     * </p>
     * 
     * @return The details of a high availability configuration for this runtime environment.
     */
    public final HighAvailabilityConfig highAvailabilityConfig() {
        return highAvailabilityConfig;
    }

    /**
     * <p>
     * The type of instance for the runtime environment.
     * </p>
     * 
     * @return The type of instance for the runtime environment.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The identifier of a customer managed key.
     * </p>
     * 
     * @return The identifier of a customer managed key.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The name of the runtime environment. Must be unique within the account.
     * </p>
     * 
     * @return The name of the runtime environment. Must be unique within the account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The network type required for the runtime environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link NetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkTypeAsString}.
     * </p>
     * 
     * @return The network type required for the runtime environment.
     * @see NetworkType
     */
    public final NetworkType networkType() {
        return NetworkType.fromValue(networkType);
    }

    /**
     * <p>
     * The network type required for the runtime environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link NetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkTypeAsString}.
     * </p>
     * 
     * @return The network type required for the runtime environment.
     * @see NetworkType
     */
    public final String networkTypeAsString() {
        return networkType;
    }

    /**
     * <p>
     * Configures the maintenance window that you want for the runtime environment. The maintenance window must have the
     * format <code>ddd:hh24:mi-ddd:hh24:mi</code> and must be less than 24 hours. The following two examples are valid
     * maintenance windows: <code>sun:23:45-mon:00:15</code> or <code>sat:01:00-sat:03:00</code>.
     * </p>
     * <p>
     * If you do not provide a value, a random system-generated value will be assigned.
     * </p>
     * 
     * @return Configures the maintenance window that you want for the runtime environment. The maintenance window must
     *         have the format <code>ddd:hh24:mi-ddd:hh24:mi</code> and must be less than 24 hours. The following two
     *         examples are valid maintenance windows: <code>sun:23:45-mon:00:15</code> or
     *         <code>sat:01:00-sat:03:00</code>. </p>
     *         <p>
     *         If you do not provide a value, a random system-generated value will be assigned.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Specifies whether the runtime environment is publicly accessible.
     * </p>
     * 
     * @return Specifies whether the runtime environment is publicly accessible.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of security groups for the VPC associated with this runtime environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The list of security groups for the VPC associated with this runtime environment.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the StorageConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStorageConfigurations() {
        return storageConfigurations != null && !(storageConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional. The storage configurations for this runtime environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorageConfigurations} method.
     * </p>
     * 
     * @return Optional. The storage configurations for this runtime environment.
     */
    public final List<StorageConfiguration> storageConfigurations() {
        return storageConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of subnets associated with the VPC for this runtime environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The list of subnets associated with the VPC for this runtime environment.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the runtime environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the runtime environment.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(highAvailabilityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageConfigurations() ? storageConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(engineTypeAsString(), other.engineTypeAsString())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(highAvailabilityConfig(), other.highAvailabilityConfig())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(name(), other.name()) && Objects.equals(networkTypeAsString(), other.networkTypeAsString())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && hasStorageConfigurations() == other.hasStorageConfigurations()
                && Objects.equals(storageConfigurations(), other.storageConfigurations())
                && hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentRequest").add("ClientToken", clientToken()).add("Description", description())
                .add("EngineType", engineTypeAsString()).add("EngineVersion", engineVersion())
                .add("HighAvailabilityConfig", highAvailabilityConfig()).add("InstanceType", instanceType())
                .add("KmsKeyId", kmsKeyId()).add("Name", name()).add("NetworkType", networkTypeAsString())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("PubliclyAccessible", publiclyAccessible())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("StorageConfigurations", hasStorageConfigurations() ? storageConfigurations() : null)
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "engineType":
            return Optional.ofNullable(clazz.cast(engineTypeAsString()));
        case "engineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "highAvailabilityConfig":
            return Optional.ofNullable(clazz.cast(highAvailabilityConfig()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "networkType":
            return Optional.ofNullable(clazz.cast(networkTypeAsString()));
        case "preferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "publiclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "storageConfigurations":
            return Optional.ofNullable(clazz.cast(storageConfigurations()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("engineType", ENGINE_TYPE_FIELD);
        map.put("engineVersion", ENGINE_VERSION_FIELD);
        map.put("highAvailabilityConfig", HIGH_AVAILABILITY_CONFIG_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("networkType", NETWORK_TYPE_FIELD);
        map.put("preferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("publiclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("storageConfigurations", STORAGE_CONFIGURATIONS_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends M2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateEnvironmentRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create an
         * environment. The service generates the clientToken when the API call is triggered. The token expires after
         * one hour, so if you retry the API within this timeframe with the same clientToken, you will get the same
         * response. The service also handles deleting the clientToken after it expires.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create an
         *        environment. The service generates the clientToken when the API call is triggered. The token expires
         *        after one hour, so if you retry the API within this timeframe with the same clientToken, you will get
         *        the same response. The service also handles deleting the clientToken after it expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description of the runtime environment.
         * </p>
         * 
         * @param description
         *        The description of the runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The engine type for the runtime environment.
         * </p>
         * 
         * @param engineType
         *        The engine type for the runtime environment.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(String engineType);

        /**
         * <p>
         * The engine type for the runtime environment.
         * </p>
         * 
         * @param engineType
         *        The engine type for the runtime environment.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(EngineType engineType);

        /**
         * <p>
         * The version of the engine type for the runtime environment.
         * </p>
         * 
         * @param engineVersion
         *        The version of the engine type for the runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The details of a high availability configuration for this runtime environment.
         * </p>
         * 
         * @param highAvailabilityConfig
         *        The details of a high availability configuration for this runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highAvailabilityConfig(HighAvailabilityConfig highAvailabilityConfig);

        /**
         * <p>
         * The details of a high availability configuration for this runtime environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link HighAvailabilityConfig.Builder} avoiding
         * the need to create one manually via {@link HighAvailabilityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HighAvailabilityConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #highAvailabilityConfig(HighAvailabilityConfig)}.
         * 
         * @param highAvailabilityConfig
         *        a consumer that will call methods on {@link HighAvailabilityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #highAvailabilityConfig(HighAvailabilityConfig)
         */
        default Builder highAvailabilityConfig(Consumer<HighAvailabilityConfig.Builder> highAvailabilityConfig) {
            return highAvailabilityConfig(HighAvailabilityConfig.builder().applyMutation(highAvailabilityConfig).build());
        }

        /**
         * <p>
         * The type of instance for the runtime environment.
         * </p>
         * 
         * @param instanceType
         *        The type of instance for the runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The identifier of a customer managed key.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier of a customer managed key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The name of the runtime environment. Must be unique within the account.
         * </p>
         * 
         * @param name
         *        The name of the runtime environment. Must be unique within the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The network type required for the runtime environment.
         * </p>
         * 
         * @param networkType
         *        The network type required for the runtime environment.
         * @see NetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkType
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * The network type required for the runtime environment.
         * </p>
         * 
         * @param networkType
         *        The network type required for the runtime environment.
         * @see NetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkType
         */
        Builder networkType(NetworkType networkType);

        /**
         * <p>
         * Configures the maintenance window that you want for the runtime environment. The maintenance window must have
         * the format <code>ddd:hh24:mi-ddd:hh24:mi</code> and must be less than 24 hours. The following two examples
         * are valid maintenance windows: <code>sun:23:45-mon:00:15</code> or <code>sat:01:00-sat:03:00</code>.
         * </p>
         * <p>
         * If you do not provide a value, a random system-generated value will be assigned.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        Configures the maintenance window that you want for the runtime environment. The maintenance window
         *        must have the format <code>ddd:hh24:mi-ddd:hh24:mi</code> and must be less than 24 hours. The
         *        following two examples are valid maintenance windows: <code>sun:23:45-mon:00:15</code> or
         *        <code>sat:01:00-sat:03:00</code>. </p>
         *        <p>
         *        If you do not provide a value, a random system-generated value will be assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Specifies whether the runtime environment is publicly accessible.
         * </p>
         * 
         * @param publiclyAccessible
         *        Specifies whether the runtime environment is publicly accessible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The list of security groups for the VPC associated with this runtime environment.
         * </p>
         * 
         * @param securityGroupIds
         *        The list of security groups for the VPC associated with this runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The list of security groups for the VPC associated with this runtime environment.
         * </p>
         * 
         * @param securityGroupIds
         *        The list of security groups for the VPC associated with this runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * Optional. The storage configurations for this runtime environment.
         * </p>
         * 
         * @param storageConfigurations
         *        Optional. The storage configurations for this runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfigurations(Collection<StorageConfiguration> storageConfigurations);

        /**
         * <p>
         * Optional. The storage configurations for this runtime environment.
         * </p>
         * 
         * @param storageConfigurations
         *        Optional. The storage configurations for this runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfigurations(StorageConfiguration... storageConfigurations);

        /**
         * <p>
         * Optional. The storage configurations for this runtime environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.m2.model.StorageConfiguration.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.m2.model.StorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.m2.model.StorageConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #storageConfigurations(List<StorageConfiguration>)}.
         * 
         * @param storageConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.m2.model.StorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfigurations(java.util.Collection<StorageConfiguration>)
         */
        Builder storageConfigurations(Consumer<StorageConfiguration.Builder>... storageConfigurations);

        /**
         * <p>
         * The list of subnets associated with the VPC for this runtime environment.
         * </p>
         * 
         * @param subnetIds
         *        The list of subnets associated with the VPC for this runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The list of subnets associated with the VPC for this runtime environment.
         * </p>
         * 
         * @param subnetIds
         *        The list of subnets associated with the VPC for this runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The tags for the runtime environment.
         * </p>
         * 
         * @param tags
         *        The tags for the runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends M2Request.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private String engineType;

        private String engineVersion;

        private HighAvailabilityConfig highAvailabilityConfig;

        private String instanceType;

        private String kmsKeyId;

        private String name;

        private String networkType;

        private String preferredMaintenanceWindow;

        private Boolean publiclyAccessible;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<StorageConfiguration> storageConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            engineType(model.engineType);
            engineVersion(model.engineVersion);
            highAvailabilityConfig(model.highAvailabilityConfig);
            instanceType(model.instanceType);
            kmsKeyId(model.kmsKeyId);
            name(model.name);
            networkType(model.networkType);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            publiclyAccessible(model.publiclyAccessible);
            securityGroupIds(model.securityGroupIds);
            storageConfigurations(model.storageConfigurations);
            subnetIds(model.subnetIds);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngineType() {
            return engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final HighAvailabilityConfig.Builder getHighAvailabilityConfig() {
            return highAvailabilityConfig != null ? highAvailabilityConfig.toBuilder() : null;
        }

        public final void setHighAvailabilityConfig(HighAvailabilityConfig.BuilderImpl highAvailabilityConfig) {
            this.highAvailabilityConfig = highAvailabilityConfig != null ? highAvailabilityConfig.build() : null;
        }

        @Override
        public final Builder highAvailabilityConfig(HighAvailabilityConfig highAvailabilityConfig) {
            this.highAvailabilityConfig = highAvailabilityConfig;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = String50ListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = String50ListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final List<StorageConfiguration.Builder> getStorageConfigurations() {
            List<StorageConfiguration.Builder> result = StorageConfigurationListCopier.copyToBuilder(this.storageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageConfigurations(Collection<StorageConfiguration.BuilderImpl> storageConfigurations) {
            this.storageConfigurations = StorageConfigurationListCopier.copyFromBuilder(storageConfigurations);
        }

        @Override
        public final Builder storageConfigurations(Collection<StorageConfiguration> storageConfigurations) {
            this.storageConfigurations = StorageConfigurationListCopier.copy(storageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigurations(StorageConfiguration... storageConfigurations) {
            storageConfigurations(Arrays.asList(storageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigurations(Consumer<StorageConfiguration.Builder>... storageConfigurations) {
            storageConfigurations(Stream.of(storageConfigurations)
                    .map(c -> StorageConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = String50ListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = String50ListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
