/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobIdentifier> {
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileName").getter(JobIdentifier.getter(JobIdentifier::fileName)).setter(JobIdentifier.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()}).build();
    private static final SdkField<String> SCRIPT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scriptName").getter(JobIdentifier.getter(JobIdentifier::scriptName)).setter(JobIdentifier.setter(Builder::scriptName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_NAME_FIELD, SCRIPT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fileName;
    private final String scriptName;
    private final Type type;

    private JobIdentifier(BuilderImpl builder) {
        this.fileName = builder.fileName;
        this.scriptName = builder.scriptName;
        this.type = builder.type;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final String scriptName() {
        return this.scriptName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobIdentifier)) {
            return false;
        }
        JobIdentifier other = (JobIdentifier)obj;
        return Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.scriptName(), other.scriptName());
    }

    public final String toString() {
        return ToString.builder((String)"JobIdentifier").add("FileName", (Object)this.fileName()).add("ScriptName", (Object)this.scriptName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "scriptName": {
                return Optional.ofNullable(clazz.cast(this.scriptName()));
            }
        }
        return Optional.empty();
    }

    public static JobIdentifier fromFileName(String fileName) {
        return (JobIdentifier)JobIdentifier.builder().fileName(fileName).build();
    }

    public static JobIdentifier fromScriptName(String scriptName) {
        return (JobIdentifier)JobIdentifier.builder().scriptName(scriptName).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("fileName", FILE_NAME_FIELD);
        map.put("scriptName", SCRIPT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobIdentifier, T> g) {
        return obj -> g.apply((JobIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FILE_NAME,
        SCRIPT_NAME,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String fileName;
        private String scriptName;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(JobIdentifier model) {
            this.fileName(model.fileName);
            this.scriptName(model.scriptName);
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            String oldValue = this.fileName;
            this.fileName = fileName;
            this.handleUnionValueChange(Type.FILE_NAME, oldValue, this.fileName);
        }

        @Override
        public final Builder fileName(String fileName) {
            String oldValue = this.fileName;
            this.fileName = fileName;
            this.handleUnionValueChange(Type.FILE_NAME, oldValue, this.fileName);
            return this;
        }

        public final String getScriptName() {
            return this.scriptName;
        }

        public final void setScriptName(String scriptName) {
            String oldValue = this.scriptName;
            this.scriptName = scriptName;
            this.handleUnionValueChange(Type.SCRIPT_NAME, oldValue, this.scriptName);
        }

        @Override
        public final Builder scriptName(String scriptName) {
            String oldValue = this.scriptName;
            this.scriptName = scriptName;
            this.handleUnionValueChange(Type.SCRIPT_NAME, oldValue, this.scriptName);
            return this;
        }

        public JobIdentifier build() {
            return new JobIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobIdentifier> {
        public Builder fileName(String var1);

        public Builder scriptName(String var1);
    }
}

