/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.m2.model.DataSetExportItem;
import software.amazon.awssdk.services.m2.model.DataSetExportListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSetExportConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSetExportConfig> {
    private static final SdkField<List<DataSetExportItem>> DATA_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataSets").getter(DataSetExportConfig.getter(DataSetExportConfig::dataSets)).setter(DataSetExportConfig.setter(Builder::dataSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSetExportItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Location").getter(DataSetExportConfig.getter(DataSetExportConfig::s3Location)).setter(DataSetExportConfig.setter(Builder::s3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SETS_FIELD, S3_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSetExportConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DataSetExportItem> dataSets;
    private final String s3Location;
    private final Type type;

    private DataSetExportConfig(BuilderImpl builder) {
        this.dataSets = builder.dataSets;
        this.s3Location = builder.s3Location;
        this.type = builder.type;
    }

    public final boolean hasDataSets() {
        return this.dataSets != null && !(this.dataSets instanceof SdkAutoConstructList);
    }

    public final List<DataSetExportItem> dataSets() {
        return this.dataSets;
    }

    public final String s3Location() {
        return this.s3Location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSets() ? this.dataSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetExportConfig)) {
            return false;
        }
        DataSetExportConfig other = (DataSetExportConfig)obj;
        return this.hasDataSets() == other.hasDataSets() && Objects.equals(this.dataSets(), other.dataSets()) && Objects.equals(this.s3Location(), other.s3Location());
    }

    public final String toString() {
        return ToString.builder((String)"DataSetExportConfig").add("DataSets", this.hasDataSets() ? this.dataSets() : null).add("S3Location", (Object)this.s3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSets": {
                return Optional.ofNullable(clazz.cast(this.dataSets()));
            }
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
        }
        return Optional.empty();
    }

    public static DataSetExportConfig fromDataSets(List<DataSetExportItem> dataSets) {
        return (DataSetExportConfig)DataSetExportConfig.builder().dataSets(dataSets).build();
    }

    public static DataSetExportConfig fromS3Location(String s3Location) {
        return (DataSetExportConfig)DataSetExportConfig.builder().s3Location(s3Location).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataSets", DATA_SETS_FIELD);
        map.put("s3Location", S3_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetExportConfig, T> g) {
        return obj -> g.apply((DataSetExportConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DATA_SETS,
        S3_LOCATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<DataSetExportItem> dataSets = DefaultSdkAutoConstructList.getInstance();
        private String s3Location;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetExportConfig model) {
            this.dataSets(model.dataSets);
            this.s3Location(model.s3Location);
        }

        public final List<DataSetExportItem.Builder> getDataSets() {
            List<DataSetExportItem.Builder> result = DataSetExportListCopier.copyToBuilder(this.dataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSets(Collection<DataSetExportItem.BuilderImpl> dataSets) {
            List<DataSetExportItem> oldValue = this.dataSets;
            this.dataSets = DataSetExportListCopier.copyFromBuilder(dataSets);
            this.handleUnionValueChange(Type.DATA_SETS, oldValue, this.dataSets);
        }

        @Override
        public final Builder dataSets(Collection<DataSetExportItem> dataSets) {
            List<DataSetExportItem> oldValue = this.dataSets;
            this.dataSets = DataSetExportListCopier.copy(dataSets);
            this.handleUnionValueChange(Type.DATA_SETS, oldValue, this.dataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(DataSetExportItem ... dataSets) {
            this.dataSets(Arrays.asList(dataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(Consumer<DataSetExportItem.Builder> ... dataSets) {
            this.dataSets(Stream.of(dataSets).map(c -> (DataSetExportItem)((DataSetExportItem.Builder)DataSetExportItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getS3Location() {
            return this.s3Location;
        }

        public final void setS3Location(String s3Location) {
            String oldValue = this.s3Location;
            this.s3Location = s3Location;
            this.handleUnionValueChange(Type.S3_LOCATION, oldValue, this.s3Location);
        }

        @Override
        public final Builder s3Location(String s3Location) {
            String oldValue = this.s3Location;
            this.s3Location = s3Location;
            this.handleUnionValueChange(Type.S3_LOCATION, oldValue, this.s3Location);
            return this;
        }

        public DataSetExportConfig build() {
            return new DataSetExportConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSetExportConfig> {
        public Builder dataSets(Collection<DataSetExportItem> var1);

        public Builder dataSets(DataSetExportItem ... var1);

        public Builder dataSets(Consumer<DataSetExportItem.Builder> ... var1);

        public Builder s3Location(String var1);
    }
}

