/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.m2.model.BatchJobExecutionSummary;
import software.amazon.awssdk.services.m2.model.BatchJobExecutionSummaryListCopier;
import software.amazon.awssdk.services.m2.model.M2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBatchJobExecutionsResponse
extends M2Response
implements ToCopyableBuilder<Builder, ListBatchJobExecutionsResponse> {
    private static final SdkField<List<BatchJobExecutionSummary>> BATCH_JOB_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("batchJobExecutions").getter(ListBatchJobExecutionsResponse.getter(ListBatchJobExecutionsResponse::batchJobExecutions)).setter(ListBatchJobExecutionsResponse.setter(Builder::batchJobExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchJobExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchJobExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBatchJobExecutionsResponse.getter(ListBatchJobExecutionsResponse::nextToken)).setter(ListBatchJobExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_JOB_EXECUTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBatchJobExecutionsResponse.memberNameToFieldInitializer();
    private final List<BatchJobExecutionSummary> batchJobExecutions;
    private final String nextToken;

    private ListBatchJobExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.batchJobExecutions = builder.batchJobExecutions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBatchJobExecutions() {
        return this.batchJobExecutions != null && !(this.batchJobExecutions instanceof SdkAutoConstructList);
    }

    public final List<BatchJobExecutionSummary> batchJobExecutions() {
        return this.batchJobExecutions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBatchJobExecutions() ? this.batchJobExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBatchJobExecutionsResponse)) {
            return false;
        }
        ListBatchJobExecutionsResponse other = (ListBatchJobExecutionsResponse)((Object)obj);
        return this.hasBatchJobExecutions() == other.hasBatchJobExecutions() && Objects.equals(this.batchJobExecutions(), other.batchJobExecutions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBatchJobExecutionsResponse").add("BatchJobExecutions", this.hasBatchJobExecutions() ? this.batchJobExecutions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "batchJobExecutions": {
                return Optional.ofNullable(clazz.cast(this.batchJobExecutions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("batchJobExecutions", BATCH_JOB_EXECUTIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBatchJobExecutionsResponse, T> g) {
        return obj -> g.apply((ListBatchJobExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Response.BuilderImpl
    implements Builder {
        private List<BatchJobExecutionSummary> batchJobExecutions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBatchJobExecutionsResponse model) {
            super(model);
            this.batchJobExecutions(model.batchJobExecutions);
            this.nextToken(model.nextToken);
        }

        public final List<BatchJobExecutionSummary.Builder> getBatchJobExecutions() {
            List<BatchJobExecutionSummary.Builder> result = BatchJobExecutionSummaryListCopier.copyToBuilder(this.batchJobExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchJobExecutions(Collection<BatchJobExecutionSummary.BuilderImpl> batchJobExecutions) {
            this.batchJobExecutions = BatchJobExecutionSummaryListCopier.copyFromBuilder(batchJobExecutions);
        }

        @Override
        public final Builder batchJobExecutions(Collection<BatchJobExecutionSummary> batchJobExecutions) {
            this.batchJobExecutions = BatchJobExecutionSummaryListCopier.copy(batchJobExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchJobExecutions(BatchJobExecutionSummary ... batchJobExecutions) {
            this.batchJobExecutions(Arrays.asList(batchJobExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchJobExecutions(Consumer<BatchJobExecutionSummary.Builder> ... batchJobExecutions) {
            this.batchJobExecutions(Stream.of(batchJobExecutions).map(c -> (BatchJobExecutionSummary)((BatchJobExecutionSummary.Builder)BatchJobExecutionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBatchJobExecutionsResponse build() {
            return new ListBatchJobExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends M2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBatchJobExecutionsResponse> {
        public Builder batchJobExecutions(Collection<BatchJobExecutionSummary> var1);

        public Builder batchJobExecutions(BatchJobExecutionSummary ... var1);

        public Builder batchJobExecutions(Consumer<BatchJobExecutionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

