/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.m2.model.BatchJobStepListCopier;
import software.amazon.awssdk.services.m2.model.JobStep;
import software.amazon.awssdk.services.m2.model.M2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBatchJobRestartPointsResponse
extends M2Response
implements ToCopyableBuilder<Builder, ListBatchJobRestartPointsResponse> {
    private static final SdkField<List<JobStep>> BATCH_JOB_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("batchJobSteps").getter(ListBatchJobRestartPointsResponse.getter(ListBatchJobRestartPointsResponse::batchJobSteps)).setter(ListBatchJobRestartPointsResponse.setter(Builder::batchJobSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchJobSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_JOB_STEPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("batchJobSteps", BATCH_JOB_STEPS_FIELD);
        }
    });
    private final List<JobStep> batchJobSteps;

    private ListBatchJobRestartPointsResponse(BuilderImpl builder) {
        super(builder);
        this.batchJobSteps = builder.batchJobSteps;
    }

    public final boolean hasBatchJobSteps() {
        return this.batchJobSteps != null && !(this.batchJobSteps instanceof SdkAutoConstructList);
    }

    public final List<JobStep> batchJobSteps() {
        return this.batchJobSteps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBatchJobSteps() ? this.batchJobSteps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBatchJobRestartPointsResponse)) {
            return false;
        }
        ListBatchJobRestartPointsResponse other = (ListBatchJobRestartPointsResponse)((Object)obj);
        return this.hasBatchJobSteps() == other.hasBatchJobSteps() && Objects.equals(this.batchJobSteps(), other.batchJobSteps());
    }

    public final String toString() {
        return ToString.builder((String)"ListBatchJobRestartPointsResponse").add("BatchJobSteps", this.hasBatchJobSteps() ? this.batchJobSteps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "batchJobSteps": {
                return Optional.ofNullable(clazz.cast(this.batchJobSteps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListBatchJobRestartPointsResponse, T> g) {
        return obj -> g.apply((ListBatchJobRestartPointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Response.BuilderImpl
    implements Builder {
        private List<JobStep> batchJobSteps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBatchJobRestartPointsResponse model) {
            super(model);
            this.batchJobSteps(model.batchJobSteps);
        }

        public final List<JobStep.Builder> getBatchJobSteps() {
            List<JobStep.Builder> result = BatchJobStepListCopier.copyToBuilder(this.batchJobSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchJobSteps(Collection<JobStep.BuilderImpl> batchJobSteps) {
            this.batchJobSteps = BatchJobStepListCopier.copyFromBuilder(batchJobSteps);
        }

        @Override
        public final Builder batchJobSteps(Collection<JobStep> batchJobSteps) {
            this.batchJobSteps = BatchJobStepListCopier.copy(batchJobSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchJobSteps(JobStep ... batchJobSteps) {
            this.batchJobSteps(Arrays.asList(batchJobSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchJobSteps(Consumer<JobStep.Builder> ... batchJobSteps) {
            this.batchJobSteps(Stream.of(batchJobSteps).map(c -> (JobStep)((JobStep.Builder)JobStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBatchJobRestartPointsResponse build() {
            return new ListBatchJobRestartPointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends M2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBatchJobRestartPointsResponse> {
        public Builder batchJobSteps(Collection<JobStep> var1);

        public Builder batchJobSteps(JobStep ... var1);

        public Builder batchJobSteps(Consumer<JobStep.Builder> ... var1);
    }
}

