/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2Client;
import software.amazon.awssdk.services.m2.internal.UserAgentUtils;
import software.amazon.awssdk.services.m2.model.EnvironmentSummary;
import software.amazon.awssdk.services.m2.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.m2.model.ListEnvironmentsResponse;

public class ListEnvironmentsIterable
implements SdkIterable<ListEnvironmentsResponse> {
    private final M2Client client;
    private final ListEnvironmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentsIterable(M2Client client, ListEnvironmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnvironmentsResponseFetcher();
    }

    public Iterator<ListEnvironmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EnvironmentSummary> environments() {
        Function<ListEnvironmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.environments() != null) {
                return response.environments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentsResponseFetcher
    implements SyncPageFetcher<ListEnvironmentsResponse> {
        private ListEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnvironmentsResponse nextPage(ListEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentsIterable.this.client.listEnvironments(ListEnvironmentsIterable.this.firstRequest);
            }
            return ListEnvironmentsIterable.this.client.listEnvironments((ListEnvironmentsRequest)((Object)ListEnvironmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

