/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EnvironmentLifecycle {
    CREATING("Creating"),
    AVAILABLE("Available"),
    DELETING("Deleting"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EnvironmentLifecycle> VALUE_MAP;
    private final String value;

    private EnvironmentLifecycle(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EnvironmentLifecycle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EnvironmentLifecycle> knownValues() {
        EnumSet<EnvironmentLifecycle> knownValues = EnumSet.allOf(EnvironmentLifecycle.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EnvironmentLifecycle.class, EnvironmentLifecycle::toString);
    }
}

