/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lookoutvision.DefaultLookoutVisionClientBuilder;
import software.amazon.awssdk.services.lookoutvision.LookoutVisionClientBuilder;
import software.amazon.awssdk.services.lookoutvision.LookoutVisionServiceClientConfiguration;
import software.amazon.awssdk.services.lookoutvision.model.AccessDeniedException;
import software.amazon.awssdk.services.lookoutvision.model.ConflictException;
import software.amazon.awssdk.services.lookoutvision.model.CreateDatasetRequest;
import software.amazon.awssdk.services.lookoutvision.model.CreateDatasetResponse;
import software.amazon.awssdk.services.lookoutvision.model.CreateModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.CreateModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.CreateProjectRequest;
import software.amazon.awssdk.services.lookoutvision.model.CreateProjectResponse;
import software.amazon.awssdk.services.lookoutvision.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.lookoutvision.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.lookoutvision.model.DeleteModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.DeleteModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.DeleteProjectRequest;
import software.amazon.awssdk.services.lookoutvision.model.DeleteProjectResponse;
import software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobRequest;
import software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobResponse;
import software.amazon.awssdk.services.lookoutvision.model.DescribeModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.DescribeModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.DescribeProjectRequest;
import software.amazon.awssdk.services.lookoutvision.model.DescribeProjectResponse;
import software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesRequest;
import software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesResponse;
import software.amazon.awssdk.services.lookoutvision.model.InternalServerException;
import software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesResponse;
import software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsResponse;
import software.amazon.awssdk.services.lookoutvision.model.ListModelsRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse;
import software.amazon.awssdk.services.lookoutvision.model.ListProjectsRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse;
import software.amazon.awssdk.services.lookoutvision.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lookoutvision.model.LookoutVisionException;
import software.amazon.awssdk.services.lookoutvision.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lookoutvision.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobRequest;
import software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobResponse;
import software.amazon.awssdk.services.lookoutvision.model.StartModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.StartModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.StopModelRequest;
import software.amazon.awssdk.services.lookoutvision.model.StopModelResponse;
import software.amazon.awssdk.services.lookoutvision.model.TagResourceRequest;
import software.amazon.awssdk.services.lookoutvision.model.TagResourceResponse;
import software.amazon.awssdk.services.lookoutvision.model.ThrottlingException;
import software.amazon.awssdk.services.lookoutvision.model.UntagResourceRequest;
import software.amazon.awssdk.services.lookoutvision.model.UntagResourceResponse;
import software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesRequest;
import software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesResponse;
import software.amazon.awssdk.services.lookoutvision.model.ValidationException;
import software.amazon.awssdk.services.lookoutvision.paginators.ListDatasetEntriesIterable;
import software.amazon.awssdk.services.lookoutvision.paginators.ListModelPackagingJobsIterable;
import software.amazon.awssdk.services.lookoutvision.paginators.ListModelsIterable;
import software.amazon.awssdk.services.lookoutvision.paginators.ListProjectsIterable;

@SdkPublicApi
@ThreadSafe
public interface LookoutVisionClient
extends AwsClient {
    public static final String SERVICE_NAME = "lookoutvision";
    public static final String SERVICE_METADATA_ID = "lookoutvision";

    default public CreateDatasetResponse createDataset(CreateDatasetRequest createDatasetRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public CreateDatasetResponse createDataset(Consumer<CreateDatasetRequest.Builder> createDatasetRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.createDataset((CreateDatasetRequest)((Object)((CreateDatasetRequest.Builder)CreateDatasetRequest.builder().applyMutation(createDatasetRequest)).build()));
    }

    default public CreateModelResponse createModel(CreateModelRequest createModelRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public CreateModelResponse createModel(Consumer<CreateModelRequest.Builder> createModelRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.createModel((CreateModelRequest)((Object)((CreateModelRequest.Builder)CreateModelRequest.builder().applyMutation(createModelRequest)).build()));
    }

    default public CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public CreateProjectResponse createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.createProject((CreateProjectRequest)((Object)((CreateProjectRequest.Builder)CreateProjectRequest.builder().applyMutation(createProjectRequest)).build()));
    }

    default public DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public DeleteDatasetResponse deleteDataset(Consumer<DeleteDatasetRequest.Builder> deleteDatasetRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.deleteDataset((DeleteDatasetRequest)((Object)((DeleteDatasetRequest.Builder)DeleteDatasetRequest.builder().applyMutation(deleteDatasetRequest)).build()));
    }

    default public DeleteModelResponse deleteModel(DeleteModelRequest deleteModelRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public DeleteModelResponse deleteModel(Consumer<DeleteModelRequest.Builder> deleteModelRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.deleteModel((DeleteModelRequest)((Object)((DeleteModelRequest.Builder)DeleteModelRequest.builder().applyMutation(deleteModelRequest)).build()));
    }

    default public DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public DeleteProjectResponse deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.deleteProject((DeleteProjectRequest)((Object)((DeleteProjectRequest.Builder)DeleteProjectRequest.builder().applyMutation(deleteProjectRequest)).build()));
    }

    default public DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public DescribeDatasetResponse describeDataset(Consumer<DescribeDatasetRequest.Builder> describeDatasetRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.describeDataset((DescribeDatasetRequest)((Object)((DescribeDatasetRequest.Builder)DescribeDatasetRequest.builder().applyMutation(describeDatasetRequest)).build()));
    }

    default public DescribeModelResponse describeModel(DescribeModelRequest describeModelRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public DescribeModelResponse describeModel(Consumer<DescribeModelRequest.Builder> describeModelRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.describeModel((DescribeModelRequest)((Object)((DescribeModelRequest.Builder)DescribeModelRequest.builder().applyMutation(describeModelRequest)).build()));
    }

    default public DescribeModelPackagingJobResponse describeModelPackagingJob(DescribeModelPackagingJobRequest describeModelPackagingJobRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public DescribeModelPackagingJobResponse describeModelPackagingJob(Consumer<DescribeModelPackagingJobRequest.Builder> describeModelPackagingJobRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.describeModelPackagingJob((DescribeModelPackagingJobRequest)((Object)((DescribeModelPackagingJobRequest.Builder)DescribeModelPackagingJobRequest.builder().applyMutation(describeModelPackagingJobRequest)).build()));
    }

    default public DescribeProjectResponse describeProject(DescribeProjectRequest describeProjectRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public DescribeProjectResponse describeProject(Consumer<DescribeProjectRequest.Builder> describeProjectRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.describeProject((DescribeProjectRequest)((Object)((DescribeProjectRequest.Builder)DescribeProjectRequest.builder().applyMutation(describeProjectRequest)).build()));
    }

    default public DetectAnomaliesResponse detectAnomalies(DetectAnomaliesRequest detectAnomaliesRequest, RequestBody requestBody) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public DetectAnomaliesResponse detectAnomalies(Consumer<DetectAnomaliesRequest.Builder> detectAnomaliesRequest, RequestBody requestBody) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.detectAnomalies((DetectAnomaliesRequest)((Object)((DetectAnomaliesRequest.Builder)DetectAnomaliesRequest.builder().applyMutation(detectAnomaliesRequest)).build()), requestBody);
    }

    default public DetectAnomaliesResponse detectAnomalies(DetectAnomaliesRequest detectAnomaliesRequest, Path sourcePath) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.detectAnomalies(detectAnomaliesRequest, RequestBody.fromFile((Path)sourcePath));
    }

    default public DetectAnomaliesResponse detectAnomalies(Consumer<DetectAnomaliesRequest.Builder> detectAnomaliesRequest, Path sourcePath) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.detectAnomalies((DetectAnomaliesRequest)((Object)((DetectAnomaliesRequest.Builder)DetectAnomaliesRequest.builder().applyMutation(detectAnomaliesRequest)).build()), sourcePath);
    }

    default public ListDatasetEntriesResponse listDatasetEntries(ListDatasetEntriesRequest listDatasetEntriesRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public ListDatasetEntriesResponse listDatasetEntries(Consumer<ListDatasetEntriesRequest.Builder> listDatasetEntriesRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.listDatasetEntries((ListDatasetEntriesRequest)((Object)((ListDatasetEntriesRequest.Builder)ListDatasetEntriesRequest.builder().applyMutation(listDatasetEntriesRequest)).build()));
    }

    default public ListDatasetEntriesIterable listDatasetEntriesPaginator(ListDatasetEntriesRequest listDatasetEntriesRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public ListDatasetEntriesIterable listDatasetEntriesPaginator(Consumer<ListDatasetEntriesRequest.Builder> listDatasetEntriesRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.listDatasetEntriesPaginator((ListDatasetEntriesRequest)((Object)((ListDatasetEntriesRequest.Builder)ListDatasetEntriesRequest.builder().applyMutation(listDatasetEntriesRequest)).build()));
    }

    default public ListModelPackagingJobsResponse listModelPackagingJobs(ListModelPackagingJobsRequest listModelPackagingJobsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public ListModelPackagingJobsResponse listModelPackagingJobs(Consumer<ListModelPackagingJobsRequest.Builder> listModelPackagingJobsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.listModelPackagingJobs((ListModelPackagingJobsRequest)((Object)((ListModelPackagingJobsRequest.Builder)ListModelPackagingJobsRequest.builder().applyMutation(listModelPackagingJobsRequest)).build()));
    }

    default public ListModelPackagingJobsIterable listModelPackagingJobsPaginator(ListModelPackagingJobsRequest listModelPackagingJobsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public ListModelPackagingJobsIterable listModelPackagingJobsPaginator(Consumer<ListModelPackagingJobsRequest.Builder> listModelPackagingJobsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.listModelPackagingJobsPaginator((ListModelPackagingJobsRequest)((Object)((ListModelPackagingJobsRequest.Builder)ListModelPackagingJobsRequest.builder().applyMutation(listModelPackagingJobsRequest)).build()));
    }

    default public ListModelsResponse listModels(ListModelsRequest listModelsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public ListModelsResponse listModels(Consumer<ListModelsRequest.Builder> listModelsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.listModels((ListModelsRequest)((Object)((ListModelsRequest.Builder)ListModelsRequest.builder().applyMutation(listModelsRequest)).build()));
    }

    default public ListModelsIterable listModelsPaginator(ListModelsRequest listModelsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public ListModelsIterable listModelsPaginator(Consumer<ListModelsRequest.Builder> listModelsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.listModelsPaginator((ListModelsRequest)((Object)((ListModelsRequest.Builder)ListModelsRequest.builder().applyMutation(listModelsRequest)).build()));
    }

    default public ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public ListProjectsResponse listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.listProjects((ListProjectsRequest)((Object)((ListProjectsRequest.Builder)ListProjectsRequest.builder().applyMutation(listProjectsRequest)).build()));
    }

    default public ListProjectsIterable listProjectsPaginator(ListProjectsRequest listProjectsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public ListProjectsIterable listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.listProjectsPaginator((ListProjectsRequest)((Object)((ListProjectsRequest.Builder)ListProjectsRequest.builder().applyMutation(listProjectsRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public StartModelResponse startModel(StartModelRequest startModelRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public StartModelResponse startModel(Consumer<StartModelRequest.Builder> startModelRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.startModel((StartModelRequest)((Object)((StartModelRequest.Builder)StartModelRequest.builder().applyMutation(startModelRequest)).build()));
    }

    default public StartModelPackagingJobResponse startModelPackagingJob(StartModelPackagingJobRequest startModelPackagingJobRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public StartModelPackagingJobResponse startModelPackagingJob(Consumer<StartModelPackagingJobRequest.Builder> startModelPackagingJobRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.startModelPackagingJob((StartModelPackagingJobRequest)((Object)((StartModelPackagingJobRequest.Builder)StartModelPackagingJobRequest.builder().applyMutation(startModelPackagingJobRequest)).build()));
    }

    default public StopModelResponse stopModel(StopModelRequest stopModelRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public StopModelResponse stopModel(Consumer<StopModelRequest.Builder> stopModelRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.stopModel((StopModelRequest)((Object)((StopModelRequest.Builder)StopModelRequest.builder().applyMutation(stopModelRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateDatasetEntriesResponse updateDatasetEntries(UpdateDatasetEntriesRequest updateDatasetEntriesRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        throw new UnsupportedOperationException();
    }

    default public UpdateDatasetEntriesResponse updateDatasetEntries(Consumer<UpdateDatasetEntriesRequest.Builder> updateDatasetEntriesRequest) throws AccessDeniedException, InternalServerException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, LookoutVisionException {
        return this.updateDatasetEntries((UpdateDatasetEntriesRequest)((Object)((UpdateDatasetEntriesRequest.Builder)UpdateDatasetEntriesRequest.builder().applyMutation(updateDatasetEntriesRequest)).build()));
    }

    public static LookoutVisionClient create() {
        return (LookoutVisionClient)LookoutVisionClient.builder().build();
    }

    public static LookoutVisionClientBuilder builder() {
        return new DefaultLookoutVisionClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"lookoutvision");
    }

    default public LookoutVisionServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

