/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutvision.model.S3Location;
import software.amazon.awssdk.services.lookoutvision.model.Tag;
import software.amazon.awssdk.services.lookoutvision.model.TagListCopier;
import software.amazon.awssdk.services.lookoutvision.model.TargetDevice;
import software.amazon.awssdk.services.lookoutvision.model.TargetPlatform;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GreengrassConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GreengrassConfiguration> {
    private static final SdkField<String> COMPILER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilerOptions").getter(GreengrassConfiguration.getter(GreengrassConfiguration::compilerOptions)).setter(GreengrassConfiguration.setter(Builder::compilerOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilerOptions").build()}).build();
    private static final SdkField<String> TARGET_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDevice").getter(GreengrassConfiguration.getter(GreengrassConfiguration::targetDeviceAsString)).setter(GreengrassConfiguration.setter(Builder::targetDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDevice").build()}).build();
    private static final SdkField<TargetPlatform> TARGET_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetPlatform").getter(GreengrassConfiguration.getter(GreengrassConfiguration::targetPlatform)).setter(GreengrassConfiguration.setter(Builder::targetPlatform)).constructor(TargetPlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPlatform").build()}).build();
    private static final SdkField<S3Location> S3_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3OutputLocation").getter(GreengrassConfiguration.getter(GreengrassConfiguration::s3OutputLocation)).setter(GreengrassConfiguration.setter(Builder::s3OutputLocation)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputLocation").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentName").getter(GreengrassConfiguration.getter(GreengrassConfiguration::componentName)).setter(GreengrassConfiguration.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()}).build();
    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentVersion").getter(GreengrassConfiguration.getter(GreengrassConfiguration::componentVersion)).setter(GreengrassConfiguration.setter(Builder::componentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentVersion").build()}).build();
    private static final SdkField<String> COMPONENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentDescription").getter(GreengrassConfiguration.getter(GreengrassConfiguration::componentDescription)).setter(GreengrassConfiguration.setter(Builder::componentDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentDescription").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(GreengrassConfiguration.getter(GreengrassConfiguration::tags)).setter(GreengrassConfiguration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPILER_OPTIONS_FIELD, TARGET_DEVICE_FIELD, TARGET_PLATFORM_FIELD, S3_OUTPUT_LOCATION_FIELD, COMPONENT_NAME_FIELD, COMPONENT_VERSION_FIELD, COMPONENT_DESCRIPTION_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String compilerOptions;
    private final String targetDevice;
    private final TargetPlatform targetPlatform;
    private final S3Location s3OutputLocation;
    private final String componentName;
    private final String componentVersion;
    private final String componentDescription;
    private final List<Tag> tags;

    private GreengrassConfiguration(BuilderImpl builder) {
        this.compilerOptions = builder.compilerOptions;
        this.targetDevice = builder.targetDevice;
        this.targetPlatform = builder.targetPlatform;
        this.s3OutputLocation = builder.s3OutputLocation;
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.componentDescription = builder.componentDescription;
        this.tags = builder.tags;
    }

    public final String compilerOptions() {
        return this.compilerOptions;
    }

    public final TargetDevice targetDevice() {
        return TargetDevice.fromValue(this.targetDevice);
    }

    public final String targetDeviceAsString() {
        return this.targetDevice;
    }

    public final TargetPlatform targetPlatform() {
        return this.targetPlatform;
    }

    public final S3Location s3OutputLocation() {
        return this.s3OutputLocation;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String componentVersion() {
        return this.componentVersion;
    }

    public final String componentDescription() {
        return this.componentDescription;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.compilerOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDeviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetPlatform());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GreengrassConfiguration)) {
            return false;
        }
        GreengrassConfiguration other = (GreengrassConfiguration)obj;
        return Objects.equals(this.compilerOptions(), other.compilerOptions()) && Objects.equals(this.targetDeviceAsString(), other.targetDeviceAsString()) && Objects.equals(this.targetPlatform(), other.targetPlatform()) && Objects.equals(this.s3OutputLocation(), other.s3OutputLocation()) && Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.componentVersion(), other.componentVersion()) && Objects.equals(this.componentDescription(), other.componentDescription()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GreengrassConfiguration").add("CompilerOptions", (Object)this.compilerOptions()).add("TargetDevice", (Object)this.targetDeviceAsString()).add("TargetPlatform", (Object)this.targetPlatform()).add("S3OutputLocation", (Object)this.s3OutputLocation()).add("ComponentName", (Object)this.componentName()).add("ComponentVersion", (Object)this.componentVersion()).add("ComponentDescription", (Object)this.componentDescription()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompilerOptions": {
                return Optional.ofNullable(clazz.cast(this.compilerOptions()));
            }
            case "TargetDevice": {
                return Optional.ofNullable(clazz.cast(this.targetDeviceAsString()));
            }
            case "TargetPlatform": {
                return Optional.ofNullable(clazz.cast(this.targetPlatform()));
            }
            case "S3OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.s3OutputLocation()));
            }
            case "ComponentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "ComponentVersion": {
                return Optional.ofNullable(clazz.cast(this.componentVersion()));
            }
            case "ComponentDescription": {
                return Optional.ofNullable(clazz.cast(this.componentDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GreengrassConfiguration, T> g) {
        return obj -> g.apply((GreengrassConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String compilerOptions;
        private String targetDevice;
        private TargetPlatform targetPlatform;
        private S3Location s3OutputLocation;
        private String componentName;
        private String componentVersion;
        private String componentDescription;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GreengrassConfiguration model) {
            this.compilerOptions(model.compilerOptions);
            this.targetDevice(model.targetDevice);
            this.targetPlatform(model.targetPlatform);
            this.s3OutputLocation(model.s3OutputLocation);
            this.componentName(model.componentName);
            this.componentVersion(model.componentVersion);
            this.componentDescription(model.componentDescription);
            this.tags(model.tags);
        }

        public final String getCompilerOptions() {
            return this.compilerOptions;
        }

        public final void setCompilerOptions(String compilerOptions) {
            this.compilerOptions = compilerOptions;
        }

        @Override
        @Transient
        public final Builder compilerOptions(String compilerOptions) {
            this.compilerOptions = compilerOptions;
            return this;
        }

        public final String getTargetDevice() {
            return this.targetDevice;
        }

        public final void setTargetDevice(String targetDevice) {
            this.targetDevice = targetDevice;
        }

        @Override
        @Transient
        public final Builder targetDevice(String targetDevice) {
            this.targetDevice = targetDevice;
            return this;
        }

        @Override
        @Transient
        public final Builder targetDevice(TargetDevice targetDevice) {
            this.targetDevice(targetDevice == null ? null : targetDevice.toString());
            return this;
        }

        public final TargetPlatform.Builder getTargetPlatform() {
            return this.targetPlatform != null ? this.targetPlatform.toBuilder() : null;
        }

        public final void setTargetPlatform(TargetPlatform.BuilderImpl targetPlatform) {
            this.targetPlatform = targetPlatform != null ? targetPlatform.build() : null;
        }

        @Override
        @Transient
        public final Builder targetPlatform(TargetPlatform targetPlatform) {
            this.targetPlatform = targetPlatform;
            return this;
        }

        public final S3Location.Builder getS3OutputLocation() {
            return this.s3OutputLocation != null ? this.s3OutputLocation.toBuilder() : null;
        }

        public final void setS3OutputLocation(S3Location.BuilderImpl s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation != null ? s3OutputLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder s3OutputLocation(S3Location s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
            return this;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        @Transient
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentVersion() {
            return this.componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        @Transient
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final String getComponentDescription() {
            return this.componentDescription;
        }

        public final void setComponentDescription(String componentDescription) {
            this.componentDescription = componentDescription;
        }

        @Override
        @Transient
        public final Builder componentDescription(String componentDescription) {
            this.componentDescription = componentDescription;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GreengrassConfiguration build() {
            return new GreengrassConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GreengrassConfiguration> {
        public Builder compilerOptions(String var1);

        public Builder targetDevice(String var1);

        public Builder targetDevice(TargetDevice var1);

        public Builder targetPlatform(TargetPlatform var1);

        default public Builder targetPlatform(Consumer<TargetPlatform.Builder> targetPlatform) {
            return this.targetPlatform((TargetPlatform)((TargetPlatform.Builder)TargetPlatform.builder().applyMutation(targetPlatform)).build());
        }

        public Builder s3OutputLocation(S3Location var1);

        default public Builder s3OutputLocation(Consumer<S3Location.Builder> s3OutputLocation) {
            return this.s3OutputLocation((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(s3OutputLocation)).build());
        }

        public Builder componentName(String var1);

        public Builder componentVersion(String var1);

        public Builder componentDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

