/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the evaluation performance of a trained model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelPerformance implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelPerformance.Builder, ModelPerformance> {
    private static final SdkField<Float> F1_SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("F1Score")
            .getter(getter(ModelPerformance::f1Score)).setter(setter(Builder::f1Score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("F1Score").build()).build();

    private static final SdkField<Float> RECALL_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Recall")
            .getter(getter(ModelPerformance::recall)).setter(setter(Builder::recall))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recall").build()).build();

    private static final SdkField<Float> PRECISION_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Precision").getter(getter(ModelPerformance::precision)).setter(setter(Builder::precision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(F1_SCORE_FIELD, RECALL_FIELD,
            PRECISION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float f1Score;

    private final Float recall;

    private final Float precision;

    private ModelPerformance(BuilderImpl builder) {
        this.f1Score = builder.f1Score;
        this.recall = builder.recall;
        this.precision = builder.precision;
    }

    /**
     * <p>
     * The overall F1 score metric for the trained model.
     * </p>
     * 
     * @return The overall F1 score metric for the trained model.
     */
    public final Float f1Score() {
        return f1Score;
    }

    /**
     * <p>
     * The overall recall metric value for the trained model.
     * </p>
     * 
     * @return The overall recall metric value for the trained model.
     */
    public final Float recall() {
        return recall;
    }

    /**
     * <p>
     * The overall precision metric value for the trained model.
     * </p>
     * 
     * @return The overall precision metric value for the trained model.
     */
    public final Float precision() {
        return precision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(f1Score());
        hashCode = 31 * hashCode + Objects.hashCode(recall());
        hashCode = 31 * hashCode + Objects.hashCode(precision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPerformance)) {
            return false;
        }
        ModelPerformance other = (ModelPerformance) obj;
        return Objects.equals(f1Score(), other.f1Score()) && Objects.equals(recall(), other.recall())
                && Objects.equals(precision(), other.precision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelPerformance").add("F1Score", f1Score()).add("Recall", recall())
                .add("Precision", precision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "F1Score":
            return Optional.ofNullable(clazz.cast(f1Score()));
        case "Recall":
            return Optional.ofNullable(clazz.cast(recall()));
        case "Precision":
            return Optional.ofNullable(clazz.cast(precision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPerformance, T> g) {
        return obj -> g.apply((ModelPerformance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelPerformance> {
        /**
         * <p>
         * The overall F1 score metric for the trained model.
         * </p>
         * 
         * @param f1Score
         *        The overall F1 score metric for the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder f1Score(Float f1Score);

        /**
         * <p>
         * The overall recall metric value for the trained model.
         * </p>
         * 
         * @param recall
         *        The overall recall metric value for the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recall(Float recall);

        /**
         * <p>
         * The overall precision metric value for the trained model.
         * </p>
         * 
         * @param precision
         *        The overall precision metric value for the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precision(Float precision);
    }

    static final class BuilderImpl implements Builder {
        private Float f1Score;

        private Float recall;

        private Float precision;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPerformance model) {
            f1Score(model.f1Score);
            recall(model.recall);
            precision(model.precision);
        }

        public final Float getF1Score() {
            return f1Score;
        }

        @Override
        public final Builder f1Score(Float f1Score) {
            this.f1Score = f1Score;
            return this;
        }

        public final void setF1Score(Float f1Score) {
            this.f1Score = f1Score;
        }

        public final Float getRecall() {
            return recall;
        }

        @Override
        public final Builder recall(Float recall) {
            this.recall = recall;
            return this;
        }

        public final void setRecall(Float recall) {
            this.recall = recall;
        }

        public final Float getPrecision() {
            return precision;
        }

        @Override
        public final Builder precision(Float precision) {
            this.precision = precision;
            return this;
        }

        public final void setPrecision(Float precision) {
            this.precision = precision;
        }

        @Override
        public ModelPerformance build() {
            return new ModelPerformance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
