/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelsResponse extends LookoutVisionResponse implements
        ToCopyableBuilder<ListModelsResponse.Builder, ListModelsResponse> {
    private static final SdkField<List<ModelMetadata>> MODELS_FIELD = SdkField
            .<List<ModelMetadata>> builder(MarshallingType.LIST)
            .memberName("Models")
            .getter(getter(ListModelsResponse::models))
            .setter(setter(Builder::models))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Models").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MODELS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ModelMetadata> models;

    private final String nextToken;

    private ListModelsResponse(BuilderImpl builder) {
        super(builder);
        this.models = builder.models;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Models property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasModels() {
        return models != null && !(models instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of model versions in the specified project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasModels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of model versions in the specified project.
     */
    public final List<ModelMetadata> models() {
        return models;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent
     * request to retrieve the next set of models.
     * </p>
     * 
     * @return If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the
     *         subsequent request to retrieve the next set of models.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasModels() ? models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelsResponse)) {
            return false;
        }
        ListModelsResponse other = (ListModelsResponse) obj;
        return hasModels() == other.hasModels() && Objects.equals(models(), other.models())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelsResponse").add("Models", hasModels() ? models() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Models":
            return Optional.ofNullable(clazz.cast(models()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelsResponse, T> g) {
        return obj -> g.apply((ListModelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListModelsResponse> {
        /**
         * <p>
         * A list of model versions in the specified project.
         * </p>
         * 
         * @param models
         *        A list of model versions in the specified project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Collection<ModelMetadata> models);

        /**
         * <p>
         * A list of model versions in the specified project.
         * </p>
         * 
         * @param models
         *        A list of model versions in the specified project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(ModelMetadata... models);

        /**
         * <p>
         * A list of model versions in the specified project.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModelMetadata>.Builder} avoiding the need
         * to create one manually via {@link List<ModelMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModelMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #models(List<ModelMetadata>)}.
         * 
         * @param models
         *        a consumer that will call methods on {@link List<ModelMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #models(List<ModelMetadata>)
         */
        Builder models(Consumer<ModelMetadata.Builder>... models);

        /**
         * <p>
         * If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent
         * request to retrieve the next set of models.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the
         *        subsequent request to retrieve the next set of models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LookoutVisionResponse.BuilderImpl implements Builder {
        private List<ModelMetadata> models = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelsResponse model) {
            super(model);
            models(model.models);
            nextToken(model.nextToken);
        }

        public final Collection<ModelMetadata.Builder> getModels() {
            if (models instanceof SdkAutoConstructList) {
                return null;
            }
            return models != null ? models.stream().map(ModelMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder models(Collection<ModelMetadata> models) {
            this.models = ModelMetadataListCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(ModelMetadata... models) {
            models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<ModelMetadata.Builder>... models) {
            models(Stream.of(models).map(c -> ModelMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModels(Collection<ModelMetadata.BuilderImpl> models) {
            this.models = ModelMetadataListCopier.copyFromBuilder(models);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListModelsResponse build() {
            return new ListModelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
