/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.PositionFiltering;
import software.amazon.awssdk.services.location.model.PricingPlan;
import software.amazon.awssdk.services.location.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrackerRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, CreateTrackerRequest> {
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerName").getter(CreateTrackerRequest.getter(CreateTrackerRequest::trackerName)).setter(CreateTrackerRequest.setter(Builder::trackerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackerName").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(CreateTrackerRequest.getter(CreateTrackerRequest::pricingPlanAsString)).setter(CreateTrackerRequest.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateTrackerRequest.getter(CreateTrackerRequest::kmsKeyId)).setter(CreateTrackerRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> PRICING_PLAN_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlanDataSource").getter(CreateTrackerRequest.getter(CreateTrackerRequest::pricingPlanDataSource)).setter(CreateTrackerRequest.setter(Builder::pricingPlanDataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanDataSource").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateTrackerRequest.getter(CreateTrackerRequest::description)).setter(CreateTrackerRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateTrackerRequest.getter(CreateTrackerRequest::tags)).setter(CreateTrackerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> POSITION_FILTERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PositionFiltering").getter(CreateTrackerRequest.getter(CreateTrackerRequest::positionFilteringAsString)).setter(CreateTrackerRequest.setter(Builder::positionFiltering)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionFiltering").build()}).build();
    private static final SdkField<Boolean> EVENT_BRIDGE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EventBridgeEnabled").getter(CreateTrackerRequest.getter(CreateTrackerRequest::eventBridgeEnabled)).setter(CreateTrackerRequest.setter(Builder::eventBridgeEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeEnabled").build()}).build();
    private static final SdkField<Boolean> KMS_KEY_ENABLE_GEOSPATIAL_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KmsKeyEnableGeospatialQueries").getter(CreateTrackerRequest.getter(CreateTrackerRequest::kmsKeyEnableGeospatialQueries)).setter(CreateTrackerRequest.setter(Builder::kmsKeyEnableGeospatialQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyEnableGeospatialQueries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKER_NAME_FIELD, PRICING_PLAN_FIELD, KMS_KEY_ID_FIELD, PRICING_PLAN_DATA_SOURCE_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, POSITION_FILTERING_FIELD, EVENT_BRIDGE_ENABLED_FIELD, KMS_KEY_ENABLE_GEOSPATIAL_QUERIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTrackerRequest.memberNameToFieldInitializer();
    private final String trackerName;
    private final String pricingPlan;
    private final String kmsKeyId;
    private final String pricingPlanDataSource;
    private final String description;
    private final Map<String, String> tags;
    private final String positionFiltering;
    private final Boolean eventBridgeEnabled;
    private final Boolean kmsKeyEnableGeospatialQueries;

    private CreateTrackerRequest(BuilderImpl builder) {
        super(builder);
        this.trackerName = builder.trackerName;
        this.pricingPlan = builder.pricingPlan;
        this.kmsKeyId = builder.kmsKeyId;
        this.pricingPlanDataSource = builder.pricingPlanDataSource;
        this.description = builder.description;
        this.tags = builder.tags;
        this.positionFiltering = builder.positionFiltering;
        this.eventBridgeEnabled = builder.eventBridgeEnabled;
        this.kmsKeyEnableGeospatialQueries = builder.kmsKeyEnableGeospatialQueries;
    }

    public final String trackerName() {
        return this.trackerName;
    }

    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    @Deprecated
    public final String pricingPlanAsString() {
        return this.pricingPlan;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    @Deprecated
    public final String pricingPlanDataSource() {
        return this.pricingPlanDataSource;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final PositionFiltering positionFiltering() {
        return PositionFiltering.fromValue(this.positionFiltering);
    }

    public final String positionFilteringAsString() {
        return this.positionFiltering;
    }

    public final Boolean eventBridgeEnabled() {
        return this.eventBridgeEnabled;
    }

    public final Boolean kmsKeyEnableGeospatialQueries() {
        return this.kmsKeyEnableGeospatialQueries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.positionFilteringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBridgeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyEnableGeospatialQueries());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrackerRequest)) {
            return false;
        }
        CreateTrackerRequest other = (CreateTrackerRequest)((Object)obj);
        return Objects.equals(this.trackerName(), other.trackerName()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.pricingPlanDataSource(), other.pricingPlanDataSource()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.positionFilteringAsString(), other.positionFilteringAsString()) && Objects.equals(this.eventBridgeEnabled(), other.eventBridgeEnabled()) && Objects.equals(this.kmsKeyEnableGeospatialQueries(), other.kmsKeyEnableGeospatialQueries());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrackerRequest").add("TrackerName", (Object)this.trackerName()).add("PricingPlan", (Object)this.pricingPlanAsString()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PricingPlanDataSource", (Object)this.pricingPlanDataSource()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("PositionFiltering", (Object)this.positionFilteringAsString()).add("EventBridgeEnabled", (Object)this.eventBridgeEnabled()).add("KmsKeyEnableGeospatialQueries", (Object)this.kmsKeyEnableGeospatialQueries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrackerName": {
                return Optional.ofNullable(clazz.cast(this.trackerName()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "PricingPlanDataSource": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanDataSource()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "PositionFiltering": {
                return Optional.ofNullable(clazz.cast(this.positionFilteringAsString()));
            }
            case "EventBridgeEnabled": {
                return Optional.ofNullable(clazz.cast(this.eventBridgeEnabled()));
            }
            case "KmsKeyEnableGeospatialQueries": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyEnableGeospatialQueries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrackerName", TRACKER_NAME_FIELD);
        map.put("PricingPlan", PRICING_PLAN_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("PricingPlanDataSource", PRICING_PLAN_DATA_SOURCE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("PositionFiltering", POSITION_FILTERING_FIELD);
        map.put("EventBridgeEnabled", EVENT_BRIDGE_ENABLED_FIELD);
        map.put("KmsKeyEnableGeospatialQueries", KMS_KEY_ENABLE_GEOSPATIAL_QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrackerRequest, T> g) {
        return obj -> g.apply((CreateTrackerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String trackerName;
        private String pricingPlan;
        private String kmsKeyId;
        private String pricingPlanDataSource;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String positionFiltering;
        private Boolean eventBridgeEnabled;
        private Boolean kmsKeyEnableGeospatialQueries;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrackerRequest model) {
            super(model);
            this.trackerName(model.trackerName);
            this.pricingPlan(model.pricingPlan);
            this.kmsKeyId(model.kmsKeyId);
            this.pricingPlanDataSource(model.pricingPlanDataSource);
            this.description(model.description);
            this.tags(model.tags);
            this.positionFiltering(model.positionFiltering);
            this.eventBridgeEnabled(model.eventBridgeEnabled);
            this.kmsKeyEnableGeospatialQueries(model.kmsKeyEnableGeospatialQueries);
        }

        public final String getTrackerName() {
            return this.trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Deprecated
        public final String getPricingPlanDataSource() {
            return this.pricingPlanDataSource;
        }

        @Deprecated
        public final void setPricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
        }

        @Override
        @Deprecated
        public final Builder pricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getPositionFiltering() {
            return this.positionFiltering;
        }

        public final void setPositionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
        }

        @Override
        public final Builder positionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
            return this;
        }

        @Override
        public final Builder positionFiltering(PositionFiltering positionFiltering) {
            this.positionFiltering(positionFiltering == null ? null : positionFiltering.toString());
            return this;
        }

        public final Boolean getEventBridgeEnabled() {
            return this.eventBridgeEnabled;
        }

        public final void setEventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
        }

        @Override
        public final Builder eventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
            return this;
        }

        public final Boolean getKmsKeyEnableGeospatialQueries() {
            return this.kmsKeyEnableGeospatialQueries;
        }

        public final void setKmsKeyEnableGeospatialQueries(Boolean kmsKeyEnableGeospatialQueries) {
            this.kmsKeyEnableGeospatialQueries = kmsKeyEnableGeospatialQueries;
        }

        @Override
        public final Builder kmsKeyEnableGeospatialQueries(Boolean kmsKeyEnableGeospatialQueries) {
            this.kmsKeyEnableGeospatialQueries = kmsKeyEnableGeospatialQueries;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrackerRequest build() {
            return new CreateTrackerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrackerRequest> {
        public Builder trackerName(String var1);

        @Deprecated
        public Builder pricingPlan(String var1);

        @Deprecated
        public Builder pricingPlan(PricingPlan var1);

        public Builder kmsKeyId(String var1);

        @Deprecated
        public Builder pricingPlanDataSource(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder positionFiltering(String var1);

        public Builder positionFiltering(PositionFiltering var1);

        public Builder eventBridgeEnabled(Boolean var1);

        public Builder kmsKeyEnableGeospatialQueries(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

