/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.LteCellDetailsNetworkMeasurementsListCopier;
import software.amazon.awssdk.services.location.model.LteLocalId;
import software.amazon.awssdk.services.location.model.LteNetworkMeasurements;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LteCellDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LteCellDetails> {
    private static final SdkField<Integer> CELL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CellId").getter(LteCellDetails.getter(LteCellDetails::cellId)).setter(LteCellDetails.setter(Builder::cellId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellId").build()}).build();
    private static final SdkField<Integer> MCC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Mcc").getter(LteCellDetails.getter(LteCellDetails::mcc)).setter(LteCellDetails.setter(Builder::mcc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mcc").build()}).build();
    private static final SdkField<Integer> MNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Mnc").getter(LteCellDetails.getter(LteCellDetails::mnc)).setter(LteCellDetails.setter(Builder::mnc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mnc").build()}).build();
    private static final SdkField<LteLocalId> LOCAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LocalId").getter(LteCellDetails.getter(LteCellDetails::localId)).setter(LteCellDetails.setter(Builder::localId)).constructor(LteLocalId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalId").build()}).build();
    private static final SdkField<List<LteNetworkMeasurements>> NETWORK_MEASUREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkMeasurements").getter(LteCellDetails.getter(LteCellDetails::networkMeasurements)).setter(LteCellDetails.setter(Builder::networkMeasurements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkMeasurements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LteNetworkMeasurements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TIMING_ADVANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimingAdvance").getter(LteCellDetails.getter(LteCellDetails::timingAdvance)).setter(LteCellDetails.setter(Builder::timingAdvance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimingAdvance").build()}).build();
    private static final SdkField<Boolean> NR_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NrCapable").getter(LteCellDetails.getter(LteCellDetails::nrCapable)).setter(LteCellDetails.setter(Builder::nrCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NrCapable").build()}).build();
    private static final SdkField<Integer> RSRP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Rsrp").getter(LteCellDetails.getter(LteCellDetails::rsrp)).setter(LteCellDetails.setter(Builder::rsrp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rsrp").build()}).build();
    private static final SdkField<Float> RSRQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Rsrq").getter(LteCellDetails.getter(LteCellDetails::rsrq)).setter(LteCellDetails.setter(Builder::rsrq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rsrq").build()}).build();
    private static final SdkField<Integer> TAC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Tac").getter(LteCellDetails.getter(LteCellDetails::tac)).setter(LteCellDetails.setter(Builder::tac)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tac").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELL_ID_FIELD, MCC_FIELD, MNC_FIELD, LOCAL_ID_FIELD, NETWORK_MEASUREMENTS_FIELD, TIMING_ADVANCE_FIELD, NR_CAPABLE_FIELD, RSRP_FIELD, RSRQ_FIELD, TAC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LteCellDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer cellId;
    private final Integer mcc;
    private final Integer mnc;
    private final LteLocalId localId;
    private final List<LteNetworkMeasurements> networkMeasurements;
    private final Integer timingAdvance;
    private final Boolean nrCapable;
    private final Integer rsrp;
    private final Float rsrq;
    private final Integer tac;

    private LteCellDetails(BuilderImpl builder) {
        this.cellId = builder.cellId;
        this.mcc = builder.mcc;
        this.mnc = builder.mnc;
        this.localId = builder.localId;
        this.networkMeasurements = builder.networkMeasurements;
        this.timingAdvance = builder.timingAdvance;
        this.nrCapable = builder.nrCapable;
        this.rsrp = builder.rsrp;
        this.rsrq = builder.rsrq;
        this.tac = builder.tac;
    }

    public final Integer cellId() {
        return this.cellId;
    }

    public final Integer mcc() {
        return this.mcc;
    }

    public final Integer mnc() {
        return this.mnc;
    }

    public final LteLocalId localId() {
        return this.localId;
    }

    public final boolean hasNetworkMeasurements() {
        return this.networkMeasurements != null && !(this.networkMeasurements instanceof SdkAutoConstructList);
    }

    public final List<LteNetworkMeasurements> networkMeasurements() {
        return this.networkMeasurements;
    }

    public final Integer timingAdvance() {
        return this.timingAdvance;
    }

    public final Boolean nrCapable() {
        return this.nrCapable;
    }

    public final Integer rsrp() {
        return this.rsrp;
    }

    public final Float rsrq() {
        return this.rsrq;
    }

    public final Integer tac() {
        return this.tac;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cellId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mcc());
        hashCode = 31 * hashCode + Objects.hashCode(this.mnc());
        hashCode = 31 * hashCode + Objects.hashCode(this.localId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkMeasurements() ? this.networkMeasurements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timingAdvance());
        hashCode = 31 * hashCode + Objects.hashCode(this.nrCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.rsrp());
        hashCode = 31 * hashCode + Objects.hashCode(this.rsrq());
        hashCode = 31 * hashCode + Objects.hashCode(this.tac());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LteCellDetails)) {
            return false;
        }
        LteCellDetails other = (LteCellDetails)obj;
        return Objects.equals(this.cellId(), other.cellId()) && Objects.equals(this.mcc(), other.mcc()) && Objects.equals(this.mnc(), other.mnc()) && Objects.equals(this.localId(), other.localId()) && this.hasNetworkMeasurements() == other.hasNetworkMeasurements() && Objects.equals(this.networkMeasurements(), other.networkMeasurements()) && Objects.equals(this.timingAdvance(), other.timingAdvance()) && Objects.equals(this.nrCapable(), other.nrCapable()) && Objects.equals(this.rsrp(), other.rsrp()) && Objects.equals(this.rsrq(), other.rsrq()) && Objects.equals(this.tac(), other.tac());
    }

    public final String toString() {
        return ToString.builder((String)"LteCellDetails").add("CellId", (Object)this.cellId()).add("Mcc", (Object)this.mcc()).add("Mnc", (Object)this.mnc()).add("LocalId", (Object)this.localId()).add("NetworkMeasurements", this.hasNetworkMeasurements() ? this.networkMeasurements() : null).add("TimingAdvance", (Object)this.timingAdvance()).add("NrCapable", (Object)this.nrCapable()).add("Rsrp", (Object)this.rsrp()).add("Rsrq", (Object)this.rsrq()).add("Tac", (Object)this.tac()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CellId": {
                return Optional.ofNullable(clazz.cast(this.cellId()));
            }
            case "Mcc": {
                return Optional.ofNullable(clazz.cast(this.mcc()));
            }
            case "Mnc": {
                return Optional.ofNullable(clazz.cast(this.mnc()));
            }
            case "LocalId": {
                return Optional.ofNullable(clazz.cast(this.localId()));
            }
            case "NetworkMeasurements": {
                return Optional.ofNullable(clazz.cast(this.networkMeasurements()));
            }
            case "TimingAdvance": {
                return Optional.ofNullable(clazz.cast(this.timingAdvance()));
            }
            case "NrCapable": {
                return Optional.ofNullable(clazz.cast(this.nrCapable()));
            }
            case "Rsrp": {
                return Optional.ofNullable(clazz.cast(this.rsrp()));
            }
            case "Rsrq": {
                return Optional.ofNullable(clazz.cast(this.rsrq()));
            }
            case "Tac": {
                return Optional.ofNullable(clazz.cast(this.tac()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CellId", CELL_ID_FIELD);
        map.put("Mcc", MCC_FIELD);
        map.put("Mnc", MNC_FIELD);
        map.put("LocalId", LOCAL_ID_FIELD);
        map.put("NetworkMeasurements", NETWORK_MEASUREMENTS_FIELD);
        map.put("TimingAdvance", TIMING_ADVANCE_FIELD);
        map.put("NrCapable", NR_CAPABLE_FIELD);
        map.put("Rsrp", RSRP_FIELD);
        map.put("Rsrq", RSRQ_FIELD);
        map.put("Tac", TAC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LteCellDetails, T> g) {
        return obj -> g.apply((LteCellDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer cellId;
        private Integer mcc;
        private Integer mnc;
        private LteLocalId localId;
        private List<LteNetworkMeasurements> networkMeasurements = DefaultSdkAutoConstructList.getInstance();
        private Integer timingAdvance;
        private Boolean nrCapable;
        private Integer rsrp;
        private Float rsrq;
        private Integer tac;

        private BuilderImpl() {
        }

        private BuilderImpl(LteCellDetails model) {
            this.cellId(model.cellId);
            this.mcc(model.mcc);
            this.mnc(model.mnc);
            this.localId(model.localId);
            this.networkMeasurements(model.networkMeasurements);
            this.timingAdvance(model.timingAdvance);
            this.nrCapable(model.nrCapable);
            this.rsrp(model.rsrp);
            this.rsrq(model.rsrq);
            this.tac(model.tac);
        }

        public final Integer getCellId() {
            return this.cellId;
        }

        public final void setCellId(Integer cellId) {
            this.cellId = cellId;
        }

        @Override
        public final Builder cellId(Integer cellId) {
            this.cellId = cellId;
            return this;
        }

        public final Integer getMcc() {
            return this.mcc;
        }

        public final void setMcc(Integer mcc) {
            this.mcc = mcc;
        }

        @Override
        public final Builder mcc(Integer mcc) {
            this.mcc = mcc;
            return this;
        }

        public final Integer getMnc() {
            return this.mnc;
        }

        public final void setMnc(Integer mnc) {
            this.mnc = mnc;
        }

        @Override
        public final Builder mnc(Integer mnc) {
            this.mnc = mnc;
            return this;
        }

        public final LteLocalId.Builder getLocalId() {
            return this.localId != null ? this.localId.toBuilder() : null;
        }

        public final void setLocalId(LteLocalId.BuilderImpl localId) {
            this.localId = localId != null ? localId.build() : null;
        }

        @Override
        public final Builder localId(LteLocalId localId) {
            this.localId = localId;
            return this;
        }

        public final List<LteNetworkMeasurements.Builder> getNetworkMeasurements() {
            List<LteNetworkMeasurements.Builder> result = LteCellDetailsNetworkMeasurementsListCopier.copyToBuilder(this.networkMeasurements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkMeasurements(Collection<LteNetworkMeasurements.BuilderImpl> networkMeasurements) {
            this.networkMeasurements = LteCellDetailsNetworkMeasurementsListCopier.copyFromBuilder(networkMeasurements);
        }

        @Override
        public final Builder networkMeasurements(Collection<LteNetworkMeasurements> networkMeasurements) {
            this.networkMeasurements = LteCellDetailsNetworkMeasurementsListCopier.copy(networkMeasurements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkMeasurements(LteNetworkMeasurements ... networkMeasurements) {
            this.networkMeasurements(Arrays.asList(networkMeasurements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkMeasurements(Consumer<LteNetworkMeasurements.Builder> ... networkMeasurements) {
            this.networkMeasurements(Stream.of(networkMeasurements).map(c -> (LteNetworkMeasurements)((LteNetworkMeasurements.Builder)LteNetworkMeasurements.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTimingAdvance() {
            return this.timingAdvance;
        }

        public final void setTimingAdvance(Integer timingAdvance) {
            this.timingAdvance = timingAdvance;
        }

        @Override
        public final Builder timingAdvance(Integer timingAdvance) {
            this.timingAdvance = timingAdvance;
            return this;
        }

        public final Boolean getNrCapable() {
            return this.nrCapable;
        }

        public final void setNrCapable(Boolean nrCapable) {
            this.nrCapable = nrCapable;
        }

        @Override
        public final Builder nrCapable(Boolean nrCapable) {
            this.nrCapable = nrCapable;
            return this;
        }

        public final Integer getRsrp() {
            return this.rsrp;
        }

        public final void setRsrp(Integer rsrp) {
            this.rsrp = rsrp;
        }

        @Override
        public final Builder rsrp(Integer rsrp) {
            this.rsrp = rsrp;
            return this;
        }

        public final Float getRsrq() {
            return this.rsrq;
        }

        public final void setRsrq(Float rsrq) {
            this.rsrq = rsrq;
        }

        @Override
        public final Builder rsrq(Float rsrq) {
            this.rsrq = rsrq;
            return this;
        }

        public final Integer getTac() {
            return this.tac;
        }

        public final void setTac(Integer tac) {
            this.tac = tac;
        }

        @Override
        public final Builder tac(Integer tac) {
            this.tac = tac;
            return this;
        }

        public LteCellDetails build() {
            return new LteCellDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LteCellDetails> {
        public Builder cellId(Integer var1);

        public Builder mcc(Integer var1);

        public Builder mnc(Integer var1);

        public Builder localId(LteLocalId var1);

        default public Builder localId(Consumer<LteLocalId.Builder> localId) {
            return this.localId((LteLocalId)((LteLocalId.Builder)LteLocalId.builder().applyMutation(localId)).build());
        }

        public Builder networkMeasurements(Collection<LteNetworkMeasurements> var1);

        public Builder networkMeasurements(LteNetworkMeasurements ... var1);

        public Builder networkMeasurements(Consumer<LteNetworkMeasurements.Builder> ... var1);

        public Builder timingAdvance(Integer var1);

        public Builder nrCapable(Boolean var1);

        public Builder rsrp(Integer var1);

        public Builder rsrq(Float var1);

        public Builder tac(Integer var1);
    }
}

