/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.DistanceUnit;
import software.amazon.awssdk.services.location.model.ForecastGeofenceEventsDeviceState;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.SpeedUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ForecastGeofenceEventsRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, ForecastGeofenceEventsRequest> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionName").getter(ForecastGeofenceEventsRequest.getter(ForecastGeofenceEventsRequest::collectionName)).setter(ForecastGeofenceEventsRequest.setter(Builder::collectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CollectionName").build()}).build();
    private static final SdkField<ForecastGeofenceEventsDeviceState> DEVICE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceState").getter(ForecastGeofenceEventsRequest.getter(ForecastGeofenceEventsRequest::deviceState)).setter(ForecastGeofenceEventsRequest.setter(Builder::deviceState)).constructor(ForecastGeofenceEventsDeviceState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceState").build()}).build();
    private static final SdkField<Double> TIME_HORIZON_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TimeHorizonMinutes").getter(ForecastGeofenceEventsRequest.getter(ForecastGeofenceEventsRequest::timeHorizonMinutes)).setter(ForecastGeofenceEventsRequest.setter(Builder::timeHorizonMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeHorizonMinutes").build()}).build();
    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistanceUnit").getter(ForecastGeofenceEventsRequest.getter(ForecastGeofenceEventsRequest::distanceUnitAsString)).setter(ForecastGeofenceEventsRequest.setter(Builder::distanceUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()}).build();
    private static final SdkField<String> SPEED_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpeedUnit").getter(ForecastGeofenceEventsRequest.getter(ForecastGeofenceEventsRequest::speedUnitAsString)).setter(ForecastGeofenceEventsRequest.setter(Builder::speedUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeedUnit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ForecastGeofenceEventsRequest.getter(ForecastGeofenceEventsRequest::nextToken)).setter(ForecastGeofenceEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ForecastGeofenceEventsRequest.getter(ForecastGeofenceEventsRequest::maxResults)).setter(ForecastGeofenceEventsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD, DEVICE_STATE_FIELD, TIME_HORIZON_MINUTES_FIELD, DISTANCE_UNIT_FIELD, SPEED_UNIT_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ForecastGeofenceEventsRequest.memberNameToFieldInitializer();
    private final String collectionName;
    private final ForecastGeofenceEventsDeviceState deviceState;
    private final Double timeHorizonMinutes;
    private final String distanceUnit;
    private final String speedUnit;
    private final String nextToken;
    private final Integer maxResults;

    private ForecastGeofenceEventsRequest(BuilderImpl builder) {
        super(builder);
        this.collectionName = builder.collectionName;
        this.deviceState = builder.deviceState;
        this.timeHorizonMinutes = builder.timeHorizonMinutes;
        this.distanceUnit = builder.distanceUnit;
        this.speedUnit = builder.speedUnit;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String collectionName() {
        return this.collectionName;
    }

    public final ForecastGeofenceEventsDeviceState deviceState() {
        return this.deviceState;
    }

    public final Double timeHorizonMinutes() {
        return this.timeHorizonMinutes;
    }

    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(this.distanceUnit);
    }

    public final String distanceUnitAsString() {
        return this.distanceUnit;
    }

    public final SpeedUnit speedUnit() {
        return SpeedUnit.fromValue(this.speedUnit);
    }

    public final String speedUnitAsString() {
        return this.speedUnit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceState());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeHorizonMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.speedUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastGeofenceEventsRequest)) {
            return false;
        }
        ForecastGeofenceEventsRequest other = (ForecastGeofenceEventsRequest)((Object)obj);
        return Objects.equals(this.collectionName(), other.collectionName()) && Objects.equals(this.deviceState(), other.deviceState()) && Objects.equals(this.timeHorizonMinutes(), other.timeHorizonMinutes()) && Objects.equals(this.distanceUnitAsString(), other.distanceUnitAsString()) && Objects.equals(this.speedUnitAsString(), other.speedUnitAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ForecastGeofenceEventsRequest").add("CollectionName", (Object)this.collectionName()).add("DeviceState", (Object)this.deviceState()).add("TimeHorizonMinutes", (Object)this.timeHorizonMinutes()).add("DistanceUnit", (Object)this.distanceUnitAsString()).add("SpeedUnit", (Object)this.speedUnitAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionName": {
                return Optional.ofNullable(clazz.cast(this.collectionName()));
            }
            case "DeviceState": {
                return Optional.ofNullable(clazz.cast(this.deviceState()));
            }
            case "TimeHorizonMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeHorizonMinutes()));
            }
            case "DistanceUnit": {
                return Optional.ofNullable(clazz.cast(this.distanceUnitAsString()));
            }
            case "SpeedUnit": {
                return Optional.ofNullable(clazz.cast(this.speedUnitAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CollectionName", COLLECTION_NAME_FIELD);
        map.put("DeviceState", DEVICE_STATE_FIELD);
        map.put("TimeHorizonMinutes", TIME_HORIZON_MINUTES_FIELD);
        map.put("DistanceUnit", DISTANCE_UNIT_FIELD);
        map.put("SpeedUnit", SPEED_UNIT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ForecastGeofenceEventsRequest, T> g) {
        return obj -> g.apply((ForecastGeofenceEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String collectionName;
        private ForecastGeofenceEventsDeviceState deviceState;
        private Double timeHorizonMinutes;
        private String distanceUnit;
        private String speedUnit;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastGeofenceEventsRequest model) {
            super(model);
            this.collectionName(model.collectionName);
            this.deviceState(model.deviceState);
            this.timeHorizonMinutes(model.timeHorizonMinutes);
            this.distanceUnit(model.distanceUnit);
            this.speedUnit(model.speedUnit);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getCollectionName() {
            return this.collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final ForecastGeofenceEventsDeviceState.Builder getDeviceState() {
            return this.deviceState != null ? this.deviceState.toBuilder() : null;
        }

        public final void setDeviceState(ForecastGeofenceEventsDeviceState.BuilderImpl deviceState) {
            this.deviceState = deviceState != null ? deviceState.build() : null;
        }

        @Override
        public final Builder deviceState(ForecastGeofenceEventsDeviceState deviceState) {
            this.deviceState = deviceState;
            return this;
        }

        public final Double getTimeHorizonMinutes() {
            return this.timeHorizonMinutes;
        }

        public final void setTimeHorizonMinutes(Double timeHorizonMinutes) {
            this.timeHorizonMinutes = timeHorizonMinutes;
        }

        @Override
        public final Builder timeHorizonMinutes(Double timeHorizonMinutes) {
            this.timeHorizonMinutes = timeHorizonMinutes;
            return this;
        }

        public final String getDistanceUnit() {
            return this.distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        public final String getSpeedUnit() {
            return this.speedUnit;
        }

        public final void setSpeedUnit(String speedUnit) {
            this.speedUnit = speedUnit;
        }

        @Override
        public final Builder speedUnit(String speedUnit) {
            this.speedUnit = speedUnit;
            return this;
        }

        @Override
        public final Builder speedUnit(SpeedUnit speedUnit) {
            this.speedUnit(speedUnit == null ? null : speedUnit.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ForecastGeofenceEventsRequest build() {
            return new ForecastGeofenceEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ForecastGeofenceEventsRequest> {
        public Builder collectionName(String var1);

        public Builder deviceState(ForecastGeofenceEventsDeviceState var1);

        default public Builder deviceState(Consumer<ForecastGeofenceEventsDeviceState.Builder> deviceState) {
            return this.deviceState((ForecastGeofenceEventsDeviceState)((ForecastGeofenceEventsDeviceState.Builder)ForecastGeofenceEventsDeviceState.builder().applyMutation(deviceState)).build());
        }

        public Builder timeHorizonMinutes(Double var1);

        public Builder distanceUnit(String var1);

        public Builder distanceUnit(DistanceUnit var1);

        public Builder speedUnit(String var1);

        public Builder speedUnit(SpeedUnit var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

