/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMapGlyphsRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, GetMapGlyphsRequest> {
    private static final SdkField<String> MAP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MapName").getter(GetMapGlyphsRequest.getter(GetMapGlyphsRequest::mapName)).setter(GetMapGlyphsRequest.setter(Builder::mapName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MapName").build()}).build();
    private static final SdkField<String> FONT_STACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontStack").getter(GetMapGlyphsRequest.getter(GetMapGlyphsRequest::fontStack)).setter(GetMapGlyphsRequest.setter(Builder::fontStack)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FontStack").build()}).build();
    private static final SdkField<String> FONT_UNICODE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontUnicodeRange").getter(GetMapGlyphsRequest.getter(GetMapGlyphsRequest::fontUnicodeRange)).setter(GetMapGlyphsRequest.setter(Builder::fontUnicodeRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FontUnicodeRange").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(GetMapGlyphsRequest.getter(GetMapGlyphsRequest::key)).setter(GetMapGlyphsRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_NAME_FIELD, FONT_STACK_FIELD, FONT_UNICODE_RANGE_FIELD, KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMapGlyphsRequest.memberNameToFieldInitializer();
    private final String mapName;
    private final String fontStack;
    private final String fontUnicodeRange;
    private final String key;

    private GetMapGlyphsRequest(BuilderImpl builder) {
        super(builder);
        this.mapName = builder.mapName;
        this.fontStack = builder.fontStack;
        this.fontUnicodeRange = builder.fontUnicodeRange;
        this.key = builder.key;
    }

    public final String mapName() {
        return this.mapName;
    }

    public final String fontStack() {
        return this.fontStack;
    }

    public final String fontUnicodeRange() {
        return this.fontUnicodeRange;
    }

    public final String key() {
        return this.key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mapName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontStack());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontUnicodeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMapGlyphsRequest)) {
            return false;
        }
        GetMapGlyphsRequest other = (GetMapGlyphsRequest)((Object)obj);
        return Objects.equals(this.mapName(), other.mapName()) && Objects.equals(this.fontStack(), other.fontStack()) && Objects.equals(this.fontUnicodeRange(), other.fontUnicodeRange()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"GetMapGlyphsRequest").add("MapName", (Object)this.mapName()).add("FontStack", (Object)this.fontStack()).add("FontUnicodeRange", (Object)this.fontUnicodeRange()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MapName": {
                return Optional.ofNullable(clazz.cast(this.mapName()));
            }
            case "FontStack": {
                return Optional.ofNullable(clazz.cast(this.fontStack()));
            }
            case "FontUnicodeRange": {
                return Optional.ofNullable(clazz.cast(this.fontUnicodeRange()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MapName", MAP_NAME_FIELD);
        map.put("FontStack", FONT_STACK_FIELD);
        map.put("FontUnicodeRange", FONT_UNICODE_RANGE_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMapGlyphsRequest, T> g) {
        return obj -> g.apply((GetMapGlyphsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String mapName;
        private String fontStack;
        private String fontUnicodeRange;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMapGlyphsRequest model) {
            super(model);
            this.mapName(model.mapName);
            this.fontStack(model.fontStack);
            this.fontUnicodeRange(model.fontUnicodeRange);
            this.key(model.key);
        }

        public final String getMapName() {
            return this.mapName;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public final String getFontStack() {
            return this.fontStack;
        }

        public final void setFontStack(String fontStack) {
            this.fontStack = fontStack;
        }

        @Override
        public final Builder fontStack(String fontStack) {
            this.fontStack = fontStack;
            return this;
        }

        public final String getFontUnicodeRange() {
            return this.fontUnicodeRange;
        }

        public final void setFontUnicodeRange(String fontUnicodeRange) {
            this.fontUnicodeRange = fontUnicodeRange;
        }

        @Override
        public final Builder fontUnicodeRange(String fontUnicodeRange) {
            this.fontUnicodeRange = fontUnicodeRange;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMapGlyphsRequest build() {
            return new GetMapGlyphsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMapGlyphsRequest> {
        public Builder mapName(String var1);

        public Builder fontStack(String var1);

        public Builder fontUnicodeRange(String var1);

        public Builder key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

