/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlaceGeometry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlaceGeometry> {
    private static final SdkField<List<Double>> POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Point").getter(PlaceGeometry.getter(PlaceGeometry::point)).setter(PlaceGeometry.setter(Builder::point)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Point").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Point", POINT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Double> point;

    private PlaceGeometry(BuilderImpl builder) {
        this.point = builder.point;
    }

    public final boolean hasPoint() {
        return this.point != null && !(this.point instanceof SdkAutoConstructList);
    }

    public final List<Double> point() {
        return this.point;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPoint() ? this.point() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlaceGeometry)) {
            return false;
        }
        PlaceGeometry other = (PlaceGeometry)obj;
        return this.hasPoint() == other.hasPoint() && Objects.equals(this.point(), other.point());
    }

    public final String toString() {
        return ToString.builder((String)"PlaceGeometry").add("Point", (Object)(this.point() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Point": {
                return Optional.ofNullable(clazz.cast(this.point()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PlaceGeometry, T> g) {
        return obj -> g.apply((PlaceGeometry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Double> point = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlaceGeometry model) {
            this.point(model.point);
        }

        public final Collection<Double> getPoint() {
            if (this.point instanceof SdkAutoConstructList) {
                return null;
            }
            return this.point;
        }

        public final void setPoint(Collection<Double> point) {
            this.point = PositionCopier.copy(point);
        }

        @Override
        public final Builder point(Collection<Double> point) {
            this.point = PositionCopier.copy(point);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder point(Double ... point) {
            this.point(Arrays.asList(point));
            return this;
        }

        public PlaceGeometry build() {
            return new PlaceGeometry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlaceGeometry> {
        public Builder point(Collection<Double> var1);

        public Builder point(Double ... var1);
    }
}

