/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponseEntry;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponseEntryListCopier;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRouteCalculatorsResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, ListRouteCalculatorsResponse> {
    private static final SdkField<List<ListRouteCalculatorsResponseEntry>> ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entries").getter(ListRouteCalculatorsResponse.getter(ListRouteCalculatorsResponse::entries)).setter(ListRouteCalculatorsResponse.setter(Builder::entries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListRouteCalculatorsResponseEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRouteCalculatorsResponse.getter(ListRouteCalculatorsResponse::nextToken)).setter(ListRouteCalculatorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Entries", ENTRIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ListRouteCalculatorsResponseEntry> entries;
    private final String nextToken;

    private ListRouteCalculatorsResponse(BuilderImpl builder) {
        super(builder);
        this.entries = builder.entries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEntries() {
        return this.entries != null && !(this.entries instanceof SdkAutoConstructList);
    }

    public final List<ListRouteCalculatorsResponseEntry> entries() {
        return this.entries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntries() ? this.entries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRouteCalculatorsResponse)) {
            return false;
        }
        ListRouteCalculatorsResponse other = (ListRouteCalculatorsResponse)((Object)obj);
        return this.hasEntries() == other.hasEntries() && Objects.equals(this.entries(), other.entries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRouteCalculatorsResponse").add("Entries", this.hasEntries() ? this.entries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRouteCalculatorsResponse, T> g) {
        return obj -> g.apply((ListRouteCalculatorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private List<ListRouteCalculatorsResponseEntry> entries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRouteCalculatorsResponse model) {
            super(model);
            this.entries(model.entries);
            this.nextToken(model.nextToken);
        }

        public final List<ListRouteCalculatorsResponseEntry.Builder> getEntries() {
            List<ListRouteCalculatorsResponseEntry.Builder> result = ListRouteCalculatorsResponseEntryListCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<ListRouteCalculatorsResponseEntry.BuilderImpl> entries) {
            this.entries = ListRouteCalculatorsResponseEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<ListRouteCalculatorsResponseEntry> entries) {
            this.entries = ListRouteCalculatorsResponseEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(ListRouteCalculatorsResponseEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<ListRouteCalculatorsResponseEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (ListRouteCalculatorsResponseEntry)((ListRouteCalculatorsResponseEntry.Builder)ListRouteCalculatorsResponseEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRouteCalculatorsResponse build() {
            return new ListRouteCalculatorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRouteCalculatorsResponse> {
        public Builder entries(Collection<ListRouteCalculatorsResponseEntry> var1);

        public Builder entries(ListRouteCalculatorsResponseEntry ... var1);

        public Builder entries(Consumer<ListRouteCalculatorsResponseEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

