/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.BatchDeleteGeofenceRequestGeofenceIdsListCopier;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteGeofenceRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, BatchDeleteGeofenceRequest> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionName").getter(BatchDeleteGeofenceRequest.getter(BatchDeleteGeofenceRequest::collectionName)).setter(BatchDeleteGeofenceRequest.setter(Builder::collectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CollectionName").build()}).build();
    private static final SdkField<List<String>> GEOFENCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GeofenceIds").getter(BatchDeleteGeofenceRequest.getter(BatchDeleteGeofenceRequest::geofenceIds)).setter(BatchDeleteGeofenceRequest.setter(Builder::geofenceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD, GEOFENCE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CollectionName", COLLECTION_NAME_FIELD);
            this.put("GeofenceIds", GEOFENCE_IDS_FIELD);
        }
    });
    private final String collectionName;
    private final List<String> geofenceIds;

    private BatchDeleteGeofenceRequest(BuilderImpl builder) {
        super(builder);
        this.collectionName = builder.collectionName;
        this.geofenceIds = builder.geofenceIds;
    }

    public final String collectionName() {
        return this.collectionName;
    }

    public final boolean hasGeofenceIds() {
        return this.geofenceIds != null && !(this.geofenceIds instanceof SdkAutoConstructList);
    }

    public final List<String> geofenceIds() {
        return this.geofenceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeofenceIds() ? this.geofenceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteGeofenceRequest)) {
            return false;
        }
        BatchDeleteGeofenceRequest other = (BatchDeleteGeofenceRequest)((Object)obj);
        return Objects.equals(this.collectionName(), other.collectionName()) && this.hasGeofenceIds() == other.hasGeofenceIds() && Objects.equals(this.geofenceIds(), other.geofenceIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteGeofenceRequest").add("CollectionName", (Object)this.collectionName()).add("GeofenceIds", this.hasGeofenceIds() ? this.geofenceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionName": {
                return Optional.ofNullable(clazz.cast(this.collectionName()));
            }
            case "GeofenceIds": {
                return Optional.ofNullable(clazz.cast(this.geofenceIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteGeofenceRequest, T> g) {
        return obj -> g.apply((BatchDeleteGeofenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String collectionName;
        private List<String> geofenceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteGeofenceRequest model) {
            super(model);
            this.collectionName(model.collectionName);
            this.geofenceIds(model.geofenceIds);
        }

        public final String getCollectionName() {
            return this.collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final Collection<String> getGeofenceIds() {
            if (this.geofenceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.geofenceIds;
        }

        public final void setGeofenceIds(Collection<String> geofenceIds) {
            this.geofenceIds = BatchDeleteGeofenceRequestGeofenceIdsListCopier.copy(geofenceIds);
        }

        @Override
        public final Builder geofenceIds(Collection<String> geofenceIds) {
            this.geofenceIds = BatchDeleteGeofenceRequestGeofenceIdsListCopier.copy(geofenceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geofenceIds(String ... geofenceIds) {
            this.geofenceIds(Arrays.asList(geofenceIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteGeofenceRequest build() {
            return new BatchDeleteGeofenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteGeofenceRequest> {
        public Builder collectionName(String var1);

        public Builder geofenceIds(Collection<String> var1);

        public Builder geofenceIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

