/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType;
import software.amazon.awssdk.services.location.model.PropertyMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ForecastedEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ForecastedEvent> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventId").getter(ForecastedEvent.getter(ForecastedEvent::eventId)).setter(ForecastedEvent.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()}).build();
    private static final SdkField<String> GEOFENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeofenceId").getter(ForecastedEvent.getter(ForecastedEvent::geofenceId)).setter(ForecastedEvent.setter(Builder::geofenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceId").build()}).build();
    private static final SdkField<Boolean> IS_DEVICE_IN_GEOFENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDeviceInGeofence").getter(ForecastedEvent.getter(ForecastedEvent::isDeviceInGeofence)).setter(ForecastedEvent.setter(Builder::isDeviceInGeofence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDeviceInGeofence").build()}).build();
    private static final SdkField<Double> NEAREST_DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("NearestDistance").getter(ForecastedEvent.getter(ForecastedEvent::nearestDistance)).setter(ForecastedEvent.setter(Builder::nearestDistance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NearestDistance").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventType").getter(ForecastedEvent.getter(ForecastedEvent::eventTypeAsString)).setter(ForecastedEvent.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()}).build();
    private static final SdkField<Instant> FORECASTED_BREACH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ForecastedBreachTime").getter(ForecastedEvent.getter(ForecastedEvent::forecastedBreachTime)).setter(ForecastedEvent.setter(Builder::forecastedBreachTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastedBreachTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, String>> GEOFENCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("GeofenceProperties").getter(ForecastedEvent.getter(ForecastedEvent::geofenceProperties)).setter(ForecastedEvent.setter(Builder::geofenceProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, GEOFENCE_ID_FIELD, IS_DEVICE_IN_GEOFENCE_FIELD, NEAREST_DISTANCE_FIELD, EVENT_TYPE_FIELD, FORECASTED_BREACH_TIME_FIELD, GEOFENCE_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventId;
    private final String geofenceId;
    private final Boolean isDeviceInGeofence;
    private final Double nearestDistance;
    private final String eventType;
    private final Instant forecastedBreachTime;
    private final Map<String, String> geofenceProperties;

    private ForecastedEvent(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.geofenceId = builder.geofenceId;
        this.isDeviceInGeofence = builder.isDeviceInGeofence;
        this.nearestDistance = builder.nearestDistance;
        this.eventType = builder.eventType;
        this.forecastedBreachTime = builder.forecastedBreachTime;
        this.geofenceProperties = builder.geofenceProperties;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String geofenceId() {
        return this.geofenceId;
    }

    public final Boolean isDeviceInGeofence() {
        return this.isDeviceInGeofence;
    }

    public final Double nearestDistance() {
        return this.nearestDistance;
    }

    public final ForecastedGeofenceEventType eventType() {
        return ForecastedGeofenceEventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final Instant forecastedBreachTime() {
        return this.forecastedBreachTime;
    }

    public final boolean hasGeofenceProperties() {
        return this.geofenceProperties != null && !(this.geofenceProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> geofenceProperties() {
        return this.geofenceProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.geofenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDeviceInGeofence());
        hashCode = 31 * hashCode + Objects.hashCode(this.nearestDistance());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastedBreachTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeofenceProperties() ? this.geofenceProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastedEvent)) {
            return false;
        }
        ForecastedEvent other = (ForecastedEvent)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.geofenceId(), other.geofenceId()) && Objects.equals(this.isDeviceInGeofence(), other.isDeviceInGeofence()) && Objects.equals(this.nearestDistance(), other.nearestDistance()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.forecastedBreachTime(), other.forecastedBreachTime()) && this.hasGeofenceProperties() == other.hasGeofenceProperties() && Objects.equals(this.geofenceProperties(), other.geofenceProperties());
    }

    public final String toString() {
        return ToString.builder((String)"ForecastedEvent").add("EventId", (Object)this.eventId()).add("GeofenceId", (Object)this.geofenceId()).add("IsDeviceInGeofence", (Object)this.isDeviceInGeofence()).add("NearestDistance", (Object)this.nearestDistance()).add("EventType", (Object)this.eventTypeAsString()).add("ForecastedBreachTime", (Object)this.forecastedBreachTime()).add("GeofenceProperties", (Object)(this.geofenceProperties() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "GeofenceId": {
                return Optional.ofNullable(clazz.cast(this.geofenceId()));
            }
            case "IsDeviceInGeofence": {
                return Optional.ofNullable(clazz.cast(this.isDeviceInGeofence()));
            }
            case "NearestDistance": {
                return Optional.ofNullable(clazz.cast(this.nearestDistance()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "ForecastedBreachTime": {
                return Optional.ofNullable(clazz.cast(this.forecastedBreachTime()));
            }
            case "GeofenceProperties": {
                return Optional.ofNullable(clazz.cast(this.geofenceProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForecastedEvent, T> g) {
        return obj -> g.apply((ForecastedEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private String geofenceId;
        private Boolean isDeviceInGeofence;
        private Double nearestDistance;
        private String eventType;
        private Instant forecastedBreachTime;
        private Map<String, String> geofenceProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastedEvent model) {
            this.eventId(model.eventId);
            this.geofenceId(model.geofenceId);
            this.isDeviceInGeofence(model.isDeviceInGeofence);
            this.nearestDistance(model.nearestDistance);
            this.eventType(model.eventType);
            this.forecastedBreachTime(model.forecastedBreachTime);
            this.geofenceProperties(model.geofenceProperties);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getGeofenceId() {
            return this.geofenceId;
        }

        public final void setGeofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
        }

        @Override
        public final Builder geofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
            return this;
        }

        public final Boolean getIsDeviceInGeofence() {
            return this.isDeviceInGeofence;
        }

        public final void setIsDeviceInGeofence(Boolean isDeviceInGeofence) {
            this.isDeviceInGeofence = isDeviceInGeofence;
        }

        @Override
        public final Builder isDeviceInGeofence(Boolean isDeviceInGeofence) {
            this.isDeviceInGeofence = isDeviceInGeofence;
            return this;
        }

        public final Double getNearestDistance() {
            return this.nearestDistance;
        }

        public final void setNearestDistance(Double nearestDistance) {
            this.nearestDistance = nearestDistance;
        }

        @Override
        public final Builder nearestDistance(Double nearestDistance) {
            this.nearestDistance = nearestDistance;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(ForecastedGeofenceEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final Instant getForecastedBreachTime() {
            return this.forecastedBreachTime;
        }

        public final void setForecastedBreachTime(Instant forecastedBreachTime) {
            this.forecastedBreachTime = forecastedBreachTime;
        }

        @Override
        public final Builder forecastedBreachTime(Instant forecastedBreachTime) {
            this.forecastedBreachTime = forecastedBreachTime;
            return this;
        }

        public final Map<String, String> getGeofenceProperties() {
            if (this.geofenceProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.geofenceProperties;
        }

        public final void setGeofenceProperties(Map<String, String> geofenceProperties) {
            this.geofenceProperties = PropertyMapCopier.copy(geofenceProperties);
        }

        @Override
        public final Builder geofenceProperties(Map<String, String> geofenceProperties) {
            this.geofenceProperties = PropertyMapCopier.copy(geofenceProperties);
            return this;
        }

        public ForecastedEvent build() {
            return new ForecastedEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ForecastedEvent> {
        public Builder eventId(String var1);

        public Builder geofenceId(String var1);

        public Builder isDeviceInGeofence(Boolean var1);

        public Builder nearestDistance(Double var1);

        public Builder eventType(String var1);

        public Builder eventType(ForecastedGeofenceEventType var1);

        public Builder forecastedBreachTime(Instant var1);

        public Builder geofenceProperties(Map<String, String> var1);
    }
}

