/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationClient;
import software.amazon.awssdk.services.location.internal.UserAgentUtils;
import software.amazon.awssdk.services.location.model.ForecastGeofenceEventsRequest;
import software.amazon.awssdk.services.location.model.ForecastGeofenceEventsResponse;
import software.amazon.awssdk.services.location.model.ForecastedEvent;

public class ForecastGeofenceEventsIterable
implements SdkIterable<ForecastGeofenceEventsResponse> {
    private final LocationClient client;
    private final ForecastGeofenceEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ForecastGeofenceEventsIterable(LocationClient client, ForecastGeofenceEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ForecastGeofenceEventsResponseFetcher();
    }

    public Iterator<ForecastGeofenceEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ForecastedEvent> forecastedEvents() {
        Function<ForecastGeofenceEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.forecastedEvents() != null) {
                return response.forecastedEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ForecastGeofenceEventsResponseFetcher
    implements SyncPageFetcher<ForecastGeofenceEventsResponse> {
        private ForecastGeofenceEventsResponseFetcher() {
        }

        public boolean hasNextPage(ForecastGeofenceEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ForecastGeofenceEventsResponse nextPage(ForecastGeofenceEventsResponse previousPage) {
            if (previousPage == null) {
                return ForecastGeofenceEventsIterable.this.client.forecastGeofenceEvents(ForecastGeofenceEventsIterable.this.firstRequest);
            }
            return ForecastGeofenceEventsIterable.this.client.forecastGeofenceEvents((ForecastGeofenceEventsRequest)((Object)ForecastGeofenceEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

