/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrackerResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, CreateTrackerResponse> {
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerName").getter(CreateTrackerResponse.getter(CreateTrackerResponse::trackerName)).setter(CreateTrackerResponse.setter(Builder::trackerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackerName").build()}).build();
    private static final SdkField<String> TRACKER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerArn").getter(CreateTrackerResponse.getter(CreateTrackerResponse::trackerArn)).setter(CreateTrackerResponse.setter(Builder::trackerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackerArn").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(CreateTrackerResponse.getter(CreateTrackerResponse::createTime)).setter(CreateTrackerResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKER_NAME_FIELD, TRACKER_ARN_FIELD, CREATE_TIME_FIELD));
    private final String trackerName;
    private final String trackerArn;
    private final Instant createTime;

    private CreateTrackerResponse(BuilderImpl builder) {
        super(builder);
        this.trackerName = builder.trackerName;
        this.trackerArn = builder.trackerArn;
        this.createTime = builder.createTime;
    }

    public final String trackerName() {
        return this.trackerName;
    }

    public final String trackerArn() {
        return this.trackerArn;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrackerResponse)) {
            return false;
        }
        CreateTrackerResponse other = (CreateTrackerResponse)((Object)obj);
        return Objects.equals(this.trackerName(), other.trackerName()) && Objects.equals(this.trackerArn(), other.trackerArn()) && Objects.equals(this.createTime(), other.createTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrackerResponse").add("TrackerName", (Object)this.trackerName()).add("TrackerArn", (Object)this.trackerArn()).add("CreateTime", (Object)this.createTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrackerName": {
                return Optional.ofNullable(clazz.cast(this.trackerName()));
            }
            case "TrackerArn": {
                return Optional.ofNullable(clazz.cast(this.trackerArn()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrackerResponse, T> g) {
        return obj -> g.apply((CreateTrackerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private String trackerName;
        private String trackerArn;
        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrackerResponse model) {
            super(model);
            this.trackerName(model.trackerName);
            this.trackerArn(model.trackerArn);
            this.createTime(model.createTime);
        }

        public final String getTrackerName() {
            return this.trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final String getTrackerArn() {
            return this.trackerArn;
        }

        public final void setTrackerArn(String trackerArn) {
            this.trackerArn = trackerArn;
        }

        @Override
        public final Builder trackerArn(String trackerArn) {
            this.trackerArn = trackerArn;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        public CreateTrackerResponse build() {
            return new CreateTrackerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrackerResponse> {
        public Builder trackerName(String var1);

        public Builder trackerArn(String var1);

        public Builder createTime(Instant var1);
    }
}

