/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPlaceIndexesResponse extends LocationResponse implements
        ToCopyableBuilder<ListPlaceIndexesResponse.Builder, ListPlaceIndexesResponse> {
    private static final SdkField<List<ListPlaceIndexesResponseEntry>> ENTRIES_FIELD = SdkField
            .<List<ListPlaceIndexesResponseEntry>> builder(MarshallingType.LIST)
            .memberName("Entries")
            .getter(getter(ListPlaceIndexesResponse::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListPlaceIndexesResponseEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListPlaceIndexesResponseEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPlaceIndexesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ListPlaceIndexesResponseEntry> entries;

    private final String nextToken;

    private ListPlaceIndexesResponse(BuilderImpl builder) {
        super(builder);
        this.entries = builder.entries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the place index resources that exist in your Amazon Web Services account
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntries} method.
     * </p>
     * 
     * @return Lists the place index resources that exist in your Amazon Web Services account
     */
    public final List<ListPlaceIndexesResponseEntry> entries() {
        return entries;
    }

    /**
     * <p>
     * A pagination token indicating that there are additional pages available. You can use the token in a new request
     * to fetch the next page of results.
     * </p>
     * 
     * @return A pagination token indicating that there are additional pages available. You can use the token in a new
     *         request to fetch the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlaceIndexesResponse)) {
            return false;
        }
        ListPlaceIndexesResponse other = (ListPlaceIndexesResponse) obj;
        return hasEntries() == other.hasEntries() && Objects.equals(entries(), other.entries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPlaceIndexesResponse").add("Entries", hasEntries() ? entries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPlaceIndexesResponse, T> g) {
        return obj -> g.apply((ListPlaceIndexesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPlaceIndexesResponse> {
        /**
         * <p>
         * Lists the place index resources that exist in your Amazon Web Services account
         * </p>
         * 
         * @param entries
         *        Lists the place index resources that exist in your Amazon Web Services account
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<ListPlaceIndexesResponseEntry> entries);

        /**
         * <p>
         * Lists the place index resources that exist in your Amazon Web Services account
         * </p>
         * 
         * @param entries
         *        Lists the place index resources that exist in your Amazon Web Services account
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(ListPlaceIndexesResponseEntry... entries);

        /**
         * <p>
         * Lists the place index resources that exist in your Amazon Web Services account
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.location.model.ListPlaceIndexesResponseEntry.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.location.model.ListPlaceIndexesResponseEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.location.model.ListPlaceIndexesResponseEntry.Builder#build()} is
         * called immediately and its result is passed to {@link #entries(List<ListPlaceIndexesResponseEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.location.model.ListPlaceIndexesResponseEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(java.util.Collection<ListPlaceIndexesResponseEntry>)
         */
        Builder entries(Consumer<ListPlaceIndexesResponseEntry.Builder>... entries);

        /**
         * <p>
         * A pagination token indicating that there are additional pages available. You can use the token in a new
         * request to fetch the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token indicating that there are additional pages available. You can use the token in a
         *        new request to fetch the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private List<ListPlaceIndexesResponseEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlaceIndexesResponse model) {
            super(model);
            entries(model.entries);
            nextToken(model.nextToken);
        }

        public final List<ListPlaceIndexesResponseEntry.Builder> getEntries() {
            List<ListPlaceIndexesResponseEntry.Builder> result = ListPlaceIndexesResponseEntryListCopier
                    .copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<ListPlaceIndexesResponseEntry.BuilderImpl> entries) {
            this.entries = ListPlaceIndexesResponseEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<ListPlaceIndexesResponseEntry> entries) {
            this.entries = ListPlaceIndexesResponseEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(ListPlaceIndexesResponseEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<ListPlaceIndexesResponseEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> ListPlaceIndexesResponseEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPlaceIndexesResponse build() {
            return new ListPlaceIndexesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
