/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateDevicePositionResponse extends LocationResponse implements
        ToCopyableBuilder<BatchUpdateDevicePositionResponse.Builder, BatchUpdateDevicePositionResponse> {
    private static final SdkField<List<BatchUpdateDevicePositionError>> ERRORS_FIELD = SdkField
            .<List<BatchUpdateDevicePositionError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchUpdateDevicePositionResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateDevicePositionError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateDevicePositionError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD));

    private final List<BatchUpdateDevicePositionError> errors;

    private BatchUpdateDevicePositionResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains error details for each device that failed to update its position.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Contains error details for each device that failed to update its position.
     */
    public final List<BatchUpdateDevicePositionError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateDevicePositionResponse)) {
            return false;
        }
        BatchUpdateDevicePositionResponse other = (BatchUpdateDevicePositionResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateDevicePositionResponse").add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateDevicePositionResponse, T> g) {
        return obj -> g.apply((BatchUpdateDevicePositionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateDevicePositionResponse> {
        /**
         * <p>
         * Contains error details for each device that failed to update its position.
         * </p>
         * 
         * @param errors
         *        Contains error details for each device that failed to update its position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchUpdateDevicePositionError> errors);

        /**
         * <p>
         * Contains error details for each device that failed to update its position.
         * </p>
         * 
         * @param errors
         *        Contains error details for each device that failed to update its position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchUpdateDevicePositionError... errors);

        /**
         * <p>
         * Contains error details for each device that failed to update its position.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionError.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionError.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<BatchUpdateDevicePositionError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchUpdateDevicePositionError>)
         */
        Builder errors(Consumer<BatchUpdateDevicePositionError.Builder>... errors);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private List<BatchUpdateDevicePositionError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateDevicePositionResponse model) {
            super(model);
            errors(model.errors);
        }

        public final List<BatchUpdateDevicePositionError.Builder> getErrors() {
            List<BatchUpdateDevicePositionError.Builder> result = BatchUpdateDevicePositionErrorListCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchUpdateDevicePositionError.BuilderImpl> errors) {
            this.errors = BatchUpdateDevicePositionErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchUpdateDevicePositionError> errors) {
            this.errors = BatchUpdateDevicePositionErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchUpdateDevicePositionError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchUpdateDevicePositionError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchUpdateDevicePositionError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateDevicePositionResponse build() {
            return new BatchUpdateDevicePositionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
