/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.PositionFiltering;
import software.amazon.awssdk.services.location.model.PricingPlan;
import software.amazon.awssdk.services.location.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrackerRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, CreateTrackerRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateTrackerRequest.getter(CreateTrackerRequest::description)).setter(CreateTrackerRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> EVENT_BRIDGE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EventBridgeEnabled").getter(CreateTrackerRequest.getter(CreateTrackerRequest::eventBridgeEnabled)).setter(CreateTrackerRequest.setter(Builder::eventBridgeEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeEnabled").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateTrackerRequest.getter(CreateTrackerRequest::kmsKeyId)).setter(CreateTrackerRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> POSITION_FILTERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PositionFiltering").getter(CreateTrackerRequest.getter(CreateTrackerRequest::positionFilteringAsString)).setter(CreateTrackerRequest.setter(Builder::positionFiltering)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionFiltering").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(CreateTrackerRequest.getter(CreateTrackerRequest::pricingPlanAsString)).setter(CreateTrackerRequest.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<String> PRICING_PLAN_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlanDataSource").getter(CreateTrackerRequest.getter(CreateTrackerRequest::pricingPlanDataSource)).setter(CreateTrackerRequest.setter(Builder::pricingPlanDataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanDataSource").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateTrackerRequest.getter(CreateTrackerRequest::tags)).setter(CreateTrackerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerName").getter(CreateTrackerRequest.getter(CreateTrackerRequest::trackerName)).setter(CreateTrackerRequest.setter(Builder::trackerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackerName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, EVENT_BRIDGE_ENABLED_FIELD, KMS_KEY_ID_FIELD, POSITION_FILTERING_FIELD, PRICING_PLAN_FIELD, PRICING_PLAN_DATA_SOURCE_FIELD, TAGS_FIELD, TRACKER_NAME_FIELD));
    private final String description;
    private final Boolean eventBridgeEnabled;
    private final String kmsKeyId;
    private final String positionFiltering;
    private final String pricingPlan;
    private final String pricingPlanDataSource;
    private final Map<String, String> tags;
    private final String trackerName;

    private CreateTrackerRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.eventBridgeEnabled = builder.eventBridgeEnabled;
        this.kmsKeyId = builder.kmsKeyId;
        this.positionFiltering = builder.positionFiltering;
        this.pricingPlan = builder.pricingPlan;
        this.pricingPlanDataSource = builder.pricingPlanDataSource;
        this.tags = builder.tags;
        this.trackerName = builder.trackerName;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean eventBridgeEnabled() {
        return this.eventBridgeEnabled;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final PositionFiltering positionFiltering() {
        return PositionFiltering.fromValue(this.positionFiltering);
    }

    public final String positionFilteringAsString() {
        return this.positionFiltering;
    }

    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    @Deprecated
    public final String pricingPlanAsString() {
        return this.pricingPlan;
    }

    @Deprecated
    public final String pricingPlanDataSource() {
        return this.pricingPlanDataSource;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String trackerName() {
        return this.trackerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBridgeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.positionFilteringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrackerRequest)) {
            return false;
        }
        CreateTrackerRequest other = (CreateTrackerRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.eventBridgeEnabled(), other.eventBridgeEnabled()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.positionFilteringAsString(), other.positionFilteringAsString()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString()) && Objects.equals(this.pricingPlanDataSource(), other.pricingPlanDataSource()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.trackerName(), other.trackerName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrackerRequest").add("Description", (Object)this.description()).add("EventBridgeEnabled", (Object)this.eventBridgeEnabled()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PositionFiltering", (Object)this.positionFilteringAsString()).add("PricingPlan", (Object)this.pricingPlanAsString()).add("PricingPlanDataSource", (Object)this.pricingPlanDataSource()).add("Tags", this.hasTags() ? this.tags() : null).add("TrackerName", (Object)this.trackerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EventBridgeEnabled": {
                return Optional.ofNullable(clazz.cast(this.eventBridgeEnabled()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "PositionFiltering": {
                return Optional.ofNullable(clazz.cast(this.positionFilteringAsString()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
            case "PricingPlanDataSource": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanDataSource()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TrackerName": {
                return Optional.ofNullable(clazz.cast(this.trackerName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrackerRequest, T> g) {
        return obj -> g.apply((CreateTrackerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String description;
        private Boolean eventBridgeEnabled;
        private String kmsKeyId;
        private String positionFiltering;
        private String pricingPlan;
        private String pricingPlanDataSource;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String trackerName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrackerRequest model) {
            super(model);
            this.description(model.description);
            this.eventBridgeEnabled(model.eventBridgeEnabled);
            this.kmsKeyId(model.kmsKeyId);
            this.positionFiltering(model.positionFiltering);
            this.pricingPlan(model.pricingPlan);
            this.pricingPlanDataSource(model.pricingPlanDataSource);
            this.tags(model.tags);
            this.trackerName(model.trackerName);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEventBridgeEnabled() {
            return this.eventBridgeEnabled;
        }

        public final void setEventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
        }

        @Override
        public final Builder eventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPositionFiltering() {
            return this.positionFiltering;
        }

        public final void setPositionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
        }

        @Override
        public final Builder positionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
            return this;
        }

        @Override
        public final Builder positionFiltering(PositionFiltering positionFiltering) {
            this.positionFiltering(positionFiltering == null ? null : positionFiltering.toString());
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        @Deprecated
        public final String getPricingPlanDataSource() {
            return this.pricingPlanDataSource;
        }

        @Deprecated
        public final void setPricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
        }

        @Override
        @Deprecated
        public final Builder pricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getTrackerName() {
            return this.trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrackerRequest build() {
            return new CreateTrackerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrackerRequest> {
        public Builder description(String var1);

        public Builder eventBridgeEnabled(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder positionFiltering(String var1);

        public Builder positionFiltering(PositionFiltering var1);

        @Deprecated
        public Builder pricingPlan(String var1);

        @Deprecated
        public Builder pricingPlan(PricingPlan var1);

        @Deprecated
        public Builder pricingPlanDataSource(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder trackerName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

