/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.BoundingBoxCopier;
import software.amazon.awssdk.services.location.model.CountryCodeListCopier;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchPlaceIndexForSuggestionsRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, SearchPlaceIndexForSuggestionsRequest> {
    private static final SdkField<List<Double>> BIAS_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BiasPosition").getter(SearchPlaceIndexForSuggestionsRequest.getter(SearchPlaceIndexForSuggestionsRequest::biasPosition)).setter(SearchPlaceIndexForSuggestionsRequest.setter(Builder::biasPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BiasPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> FILTER_B_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterBBox").getter(SearchPlaceIndexForSuggestionsRequest.getter(SearchPlaceIndexForSuggestionsRequest::filterBBox)).setter(SearchPlaceIndexForSuggestionsRequest.setter(Builder::filterBBox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterBBox").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FILTER_COUNTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterCountries").getter(SearchPlaceIndexForSuggestionsRequest.getter(SearchPlaceIndexForSuggestionsRequest::filterCountries)).setter(SearchPlaceIndexForSuggestionsRequest.setter(Builder::filterCountries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCountries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(SearchPlaceIndexForSuggestionsRequest.getter(SearchPlaceIndexForSuggestionsRequest::indexName)).setter(SearchPlaceIndexForSuggestionsRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("IndexName").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(SearchPlaceIndexForSuggestionsRequest.getter(SearchPlaceIndexForSuggestionsRequest::language)).setter(SearchPlaceIndexForSuggestionsRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchPlaceIndexForSuggestionsRequest.getter(SearchPlaceIndexForSuggestionsRequest::maxResults)).setter(SearchPlaceIndexForSuggestionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(SearchPlaceIndexForSuggestionsRequest.getter(SearchPlaceIndexForSuggestionsRequest::text)).setter(SearchPlaceIndexForSuggestionsRequest.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIAS_POSITION_FIELD, FILTER_B_BOX_FIELD, FILTER_COUNTRIES_FIELD, INDEX_NAME_FIELD, LANGUAGE_FIELD, MAX_RESULTS_FIELD, TEXT_FIELD));
    private final List<Double> biasPosition;
    private final List<Double> filterBBox;
    private final List<String> filterCountries;
    private final String indexName;
    private final String language;
    private final Integer maxResults;
    private final String text;

    private SearchPlaceIndexForSuggestionsRequest(BuilderImpl builder) {
        super(builder);
        this.biasPosition = builder.biasPosition;
        this.filterBBox = builder.filterBBox;
        this.filterCountries = builder.filterCountries;
        this.indexName = builder.indexName;
        this.language = builder.language;
        this.maxResults = builder.maxResults;
        this.text = builder.text;
    }

    public final boolean hasBiasPosition() {
        return this.biasPosition != null && !(this.biasPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> biasPosition() {
        return this.biasPosition;
    }

    public final boolean hasFilterBBox() {
        return this.filterBBox != null && !(this.filterBBox instanceof SdkAutoConstructList);
    }

    public final List<Double> filterBBox() {
        return this.filterBBox;
    }

    public final boolean hasFilterCountries() {
        return this.filterCountries != null && !(this.filterCountries instanceof SdkAutoConstructList);
    }

    public final List<String> filterCountries() {
        return this.filterCountries;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String language() {
        return this.language;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String text() {
        return this.text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBiasPosition() ? this.biasPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterBBox() ? this.filterBBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterCountries() ? this.filterCountries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForSuggestionsRequest)) {
            return false;
        }
        SearchPlaceIndexForSuggestionsRequest other = (SearchPlaceIndexForSuggestionsRequest)((Object)obj);
        return this.hasBiasPosition() == other.hasBiasPosition() && Objects.equals(this.biasPosition(), other.biasPosition()) && this.hasFilterBBox() == other.hasFilterBBox() && Objects.equals(this.filterBBox(), other.filterBBox()) && this.hasFilterCountries() == other.hasFilterCountries() && Objects.equals(this.filterCountries(), other.filterCountries()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.text(), other.text());
    }

    public final String toString() {
        return ToString.builder((String)"SearchPlaceIndexForSuggestionsRequest").add("BiasPosition", (Object)(this.biasPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("FilterBBox", (Object)(this.filterBBox() == null ? null : "*** Sensitive Data Redacted ***")).add("FilterCountries", this.hasFilterCountries() ? this.filterCountries() : null).add("IndexName", (Object)this.indexName()).add("Language", (Object)this.language()).add("MaxResults", (Object)this.maxResults()).add("Text", (Object)(this.text() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BiasPosition": {
                return Optional.ofNullable(clazz.cast(this.biasPosition()));
            }
            case "FilterBBox": {
                return Optional.ofNullable(clazz.cast(this.filterBBox()));
            }
            case "FilterCountries": {
                return Optional.ofNullable(clazz.cast(this.filterCountries()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForSuggestionsRequest, T> g) {
        return obj -> g.apply((SearchPlaceIndexForSuggestionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private List<Double> biasPosition = DefaultSdkAutoConstructList.getInstance();
        private List<Double> filterBBox = DefaultSdkAutoConstructList.getInstance();
        private List<String> filterCountries = DefaultSdkAutoConstructList.getInstance();
        private String indexName;
        private String language;
        private Integer maxResults;
        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForSuggestionsRequest model) {
            super(model);
            this.biasPosition(model.biasPosition);
            this.filterBBox(model.filterBBox);
            this.filterCountries(model.filterCountries);
            this.indexName(model.indexName);
            this.language(model.language);
            this.maxResults(model.maxResults);
            this.text(model.text);
        }

        public final Collection<Double> getBiasPosition() {
            if (this.biasPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.biasPosition;
        }

        public final void setBiasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
        }

        @Override
        public final Builder biasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder biasPosition(Double ... biasPosition) {
            this.biasPosition(Arrays.asList(biasPosition));
            return this;
        }

        public final Collection<Double> getFilterBBox() {
            if (this.filterBBox instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterBBox;
        }

        public final void setFilterBBox(Collection<Double> filterBBox) {
            this.filterBBox = BoundingBoxCopier.copy(filterBBox);
        }

        @Override
        public final Builder filterBBox(Collection<Double> filterBBox) {
            this.filterBBox = BoundingBoxCopier.copy(filterBBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterBBox(Double ... filterBBox) {
            this.filterBBox(Arrays.asList(filterBBox));
            return this;
        }

        public final Collection<String> getFilterCountries() {
            if (this.filterCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterCountries;
        }

        public final void setFilterCountries(Collection<String> filterCountries) {
            this.filterCountries = CountryCodeListCopier.copy(filterCountries);
        }

        @Override
        public final Builder filterCountries(Collection<String> filterCountries) {
            this.filterCountries = CountryCodeListCopier.copy(filterCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterCountries(String ... filterCountries) {
            this.filterCountries(Arrays.asList(filterCountries));
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchPlaceIndexForSuggestionsRequest build() {
            return new SearchPlaceIndexForSuggestionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchPlaceIndexForSuggestionsRequest> {
        public Builder biasPosition(Collection<Double> var1);

        public Builder biasPosition(Double ... var1);

        public Builder filterBBox(Collection<Double> var1);

        public Builder filterBBox(Double ... var1);

        public Builder filterCountries(Collection<String> var1);

        public Builder filterCountries(String ... var1);

        public Builder indexName(String var1);

        public Builder language(String var1);

        public Builder maxResults(Integer var1);

        public Builder text(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

