/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationClient;
import software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest;
import software.amazon.awssdk.services.location.model.ListPlaceIndexesResponse;
import software.amazon.awssdk.services.location.model.ListPlaceIndexesResponseEntry;

public class ListPlaceIndexesIterable
implements SdkIterable<ListPlaceIndexesResponse> {
    private final LocationClient client;
    private final ListPlaceIndexesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPlaceIndexesIterable(LocationClient client, ListPlaceIndexesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPlaceIndexesResponseFetcher();
    }

    public Iterator<ListPlaceIndexesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListPlaceIndexesResponseEntry> entries() {
        Function<ListPlaceIndexesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPlaceIndexesResponseFetcher
    implements SyncPageFetcher<ListPlaceIndexesResponse> {
        private ListPlaceIndexesResponseFetcher() {
        }

        public boolean hasNextPage(ListPlaceIndexesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPlaceIndexesResponse nextPage(ListPlaceIndexesResponse previousPage) {
            if (previousPage == null) {
                return ListPlaceIndexesIterable.this.client.listPlaceIndexes(ListPlaceIndexesIterable.this.firstRequest);
            }
            return ListPlaceIndexesIterable.this.client.listPlaceIndexes((ListPlaceIndexesRequest)((Object)ListPlaceIndexesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

