/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationClient;
import software.amazon.awssdk.services.location.model.ListGeofenceResponseEntry;
import software.amazon.awssdk.services.location.model.ListGeofencesRequest;
import software.amazon.awssdk.services.location.model.ListGeofencesResponse;

public class ListGeofencesIterable
implements SdkIterable<ListGeofencesResponse> {
    private final LocationClient client;
    private final ListGeofencesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGeofencesIterable(LocationClient client, ListGeofencesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGeofencesResponseFetcher();
    }

    public Iterator<ListGeofencesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListGeofenceResponseEntry> entries() {
        Function<ListGeofencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGeofencesResponseFetcher
    implements SyncPageFetcher<ListGeofencesResponse> {
        private ListGeofencesResponseFetcher() {
        }

        public boolean hasNextPage(ListGeofencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGeofencesResponse nextPage(ListGeofencesResponse previousPage) {
            if (previousPage == null) {
                return ListGeofencesIterable.this.client.listGeofences(ListGeofencesIterable.this.firstRequest);
            }
            return ListGeofencesIterable.this.client.listGeofences((ListGeofencesRequest)((Object)ListGeofencesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

