/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationAsyncClient;
import software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest;
import software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponse;
import software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponseEntry;

public class ListGeofenceCollectionsPublisher
implements SdkPublisher<ListGeofenceCollectionsResponse> {
    private final LocationAsyncClient client;
    private final ListGeofenceCollectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGeofenceCollectionsPublisher(LocationAsyncClient client, ListGeofenceCollectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGeofenceCollectionsPublisher(LocationAsyncClient client, ListGeofenceCollectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGeofenceCollectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGeofenceCollectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListGeofenceCollectionsResponseEntry> entries() {
        Function<ListGeofenceCollectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGeofenceCollectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGeofenceCollectionsResponseFetcher
    implements AsyncPageFetcher<ListGeofenceCollectionsResponse> {
        private ListGeofenceCollectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListGeofenceCollectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGeofenceCollectionsResponse> nextPage(ListGeofenceCollectionsResponse previousPage) {
            if (previousPage == null) {
                return ListGeofenceCollectionsPublisher.this.client.listGeofenceCollections(ListGeofenceCollectionsPublisher.this.firstRequest);
            }
            return ListGeofenceCollectionsPublisher.this.client.listGeofenceCollections((ListGeofenceCollectionsRequest)((Object)ListGeofenceCollectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

