/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MapConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MapConfiguration> {
    private static final SdkField<String> STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Style").getter(MapConfiguration.getter(MapConfiguration::style)).setter(MapConfiguration.setter(Builder::style)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Style").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STYLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String style;

    private MapConfiguration(BuilderImpl builder) {
        this.style = builder.style;
    }

    public final String style() {
        return this.style;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.style());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapConfiguration)) {
            return false;
        }
        MapConfiguration other = (MapConfiguration)obj;
        return Objects.equals(this.style(), other.style());
    }

    public final String toString() {
        return ToString.builder((String)"MapConfiguration").add("Style", (Object)this.style()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Style": {
                return Optional.ofNullable(clazz.cast(this.style()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MapConfiguration, T> g) {
        return obj -> g.apply((MapConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String style;

        private BuilderImpl() {
        }

        private BuilderImpl(MapConfiguration model) {
            this.style(model.style);
        }

        public final String getStyle() {
            return this.style;
        }

        @Override
        public final Builder style(String style) {
            this.style = style;
            return this;
        }

        public final void setStyle(String style) {
            this.style = style;
        }

        public MapConfiguration build() {
            return new MapConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MapConfiguration> {
        public Builder style(String var1);
    }
}

