/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGeofencesResponse extends LocationResponse implements
        ToCopyableBuilder<ListGeofencesResponse.Builder, ListGeofencesResponse> {
    private static final SdkField<List<ListGeofenceResponseEntry>> ENTRIES_FIELD = SdkField
            .<List<ListGeofenceResponseEntry>> builder(MarshallingType.LIST)
            .memberName("Entries")
            .getter(getter(ListGeofencesResponse::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListGeofenceResponseEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListGeofenceResponseEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListGeofencesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ListGeofenceResponseEntry> entries;

    private final String nextToken;

    private ListGeofencesResponse(BuilderImpl builder) {
        super(builder);
        this.entries = builder.entries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Entries property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of geofences stored in the geofence collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains a list of geofences stored in the geofence collection.
     */
    public final List<ListGeofenceResponseEntry> entries() {
        return entries;
    }

    /**
     * <p>
     * A pagination token indicating there are additional pages available. You can use the token in a following request
     * to fetch the next set of results.
     * </p>
     * 
     * @return A pagination token indicating there are additional pages available. You can use the token in a following
     *         request to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeofencesResponse)) {
            return false;
        }
        ListGeofencesResponse other = (ListGeofencesResponse) obj;
        return hasEntries() == other.hasEntries() && Objects.equals(entries(), other.entries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGeofencesResponse").add("Entries", hasEntries() ? entries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGeofencesResponse, T> g) {
        return obj -> g.apply((ListGeofencesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListGeofencesResponse> {
        /**
         * <p>
         * Contains a list of geofences stored in the geofence collection.
         * </p>
         * 
         * @param entries
         *        Contains a list of geofences stored in the geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<ListGeofenceResponseEntry> entries);

        /**
         * <p>
         * Contains a list of geofences stored in the geofence collection.
         * </p>
         * 
         * @param entries
         *        Contains a list of geofences stored in the geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(ListGeofenceResponseEntry... entries);

        /**
         * <p>
         * Contains a list of geofences stored in the geofence collection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ListGeofenceResponseEntry>.Builder}
         * avoiding the need to create one manually via {@link List<ListGeofenceResponseEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ListGeofenceResponseEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #entries(List<ListGeofenceResponseEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on {@link List<ListGeofenceResponseEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(List<ListGeofenceResponseEntry>)
         */
        Builder entries(Consumer<ListGeofenceResponseEntry.Builder>... entries);

        /**
         * <p>
         * A pagination token indicating there are additional pages available. You can use the token in a following
         * request to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token indicating there are additional pages available. You can use the token in a
         *        following request to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private List<ListGeofenceResponseEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeofencesResponse model) {
            super(model);
            entries(model.entries);
            nextToken(model.nextToken);
        }

        public final Collection<ListGeofenceResponseEntry.Builder> getEntries() {
            if (entries instanceof SdkAutoConstructList) {
                return null;
            }
            return entries != null ? entries.stream().map(ListGeofenceResponseEntry::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder entries(Collection<ListGeofenceResponseEntry> entries) {
            this.entries = ListGeofenceResponseEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(ListGeofenceResponseEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<ListGeofenceResponseEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> ListGeofenceResponseEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntries(Collection<ListGeofenceResponseEntry.BuilderImpl> entries) {
            this.entries = ListGeofenceResponseEntryListCopier.copyFromBuilder(entries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGeofencesResponse build() {
            return new ListGeofencesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
