/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDevicePositionRequest extends LocationRequest implements
        ToCopyableBuilder<GetDevicePositionRequest.Builder, GetDevicePositionRequest> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(GetDevicePositionRequest::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DeviceId").build()).build();

    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackerName").getter(getter(GetDevicePositionRequest::trackerName)).setter(setter(Builder::trackerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TrackerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD,
            TRACKER_NAME_FIELD));

    private final String deviceId;

    private final String trackerName;

    private GetDevicePositionRequest(BuilderImpl builder) {
        super(builder);
        this.deviceId = builder.deviceId;
        this.trackerName = builder.trackerName;
    }

    /**
     * <p>
     * The device whose position you want to retreieve.
     * </p>
     * 
     * @return The device whose position you want to retreieve.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The tracker resource receiving the position update.
     * </p>
     * 
     * @return The tracker resource receiving the position update.
     */
    public final String trackerName() {
        return trackerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(trackerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePositionRequest)) {
            return false;
        }
        GetDevicePositionRequest other = (GetDevicePositionRequest) obj;
        return Objects.equals(deviceId(), other.deviceId()) && Objects.equals(trackerName(), other.trackerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDevicePositionRequest").add("DeviceId", deviceId()).add("TrackerName", trackerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "TrackerName":
            return Optional.ofNullable(clazz.cast(trackerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDevicePositionRequest, T> g) {
        return obj -> g.apply((GetDevicePositionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDevicePositionRequest> {
        /**
         * <p>
         * The device whose position you want to retreieve.
         * </p>
         * 
         * @param deviceId
         *        The device whose position you want to retreieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The tracker resource receiving the position update.
         * </p>
         * 
         * @param trackerName
         *        The tracker resource receiving the position update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackerName(String trackerName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String deviceId;

        private String trackerName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePositionRequest model) {
            super(model);
            deviceId(model.deviceId);
            trackerName(model.trackerName);
        }

        public final String getDeviceId() {
            return deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final String getTrackerName() {
            return trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDevicePositionRequest build() {
            return new GetDevicePositionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
