/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMapRequest extends LocationRequest implements
        ToCopyableBuilder<CreateMapRequest.Builder, CreateMapRequest> {
    private static final SdkField<MapConfiguration> CONFIGURATION_FIELD = SdkField
            .<MapConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(CreateMapRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(MapConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateMapRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> MAP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MapName").getter(getter(CreateMapRequest::mapName)).setter(setter(Builder::mapName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapName").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(CreateMapRequest::pricingPlanAsString)).setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            DESCRIPTION_FIELD, MAP_NAME_FIELD, PRICING_PLAN_FIELD));

    private final MapConfiguration configuration;

    private final String description;

    private final String mapName;

    private final String pricingPlan;

    private CreateMapRequest(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.mapName = builder.mapName;
        this.pricingPlan = builder.pricingPlan;
    }

    /**
     * <p>
     * Specifies the map style selected from an available data provider.
     * </p>
     * 
     * @return Specifies the map style selected from an available data provider.
     */
    public final MapConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * An optional description for the map resource.
     * </p>
     * 
     * @return An optional description for the map resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name for the map resource.
     * </p>
     * <p>
     * Requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), and underscores (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be a unique map resource name.
     * </p>
     * </li>
     * <li>
     * <p>
     * No spaces allowed. For example, <code>ExampleMap</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name for the map resource.</p>
     *         <p>
     *         Requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), and underscores (_).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be a unique map resource name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         No spaces allowed. For example, <code>ExampleMap</code>.
     *         </p>
     *         </li>
     */
    public final String mapName() {
        return mapName;
    }

    /**
     * <p>
     * Specifies the pricing plan for your map resource. There's three pricing plan options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RequestBasedUsage</code> — Selects the "Request-Based Usage" pricing plan.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MobileAssetTracking</code> — Selects the "Mobile Asset Tracking" pricing plan.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MobileAssetManagement</code> — Selects the "Mobile Asset Management" pricing plan.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For additional details and restrictions on each pricing plan option, see the <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Specifies the pricing plan for your map resource. There's three pricing plan options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RequestBasedUsage</code> — Selects the "Request-Based Usage" pricing plan.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MobileAssetTracking</code> — Selects the "Mobile Asset Tracking" pricing plan.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MobileAssetManagement</code> — Selects the "Mobile Asset Management" pricing plan.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For additional details and restrictions on each pricing plan option, see the <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * @see PricingPlan
     */
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * <p>
     * Specifies the pricing plan for your map resource. There's three pricing plan options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RequestBasedUsage</code> — Selects the "Request-Based Usage" pricing plan.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MobileAssetTracking</code> — Selects the "Mobile Asset Tracking" pricing plan.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MobileAssetManagement</code> — Selects the "Mobile Asset Management" pricing plan.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For additional details and restrictions on each pricing plan option, see the <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Specifies the pricing plan for your map resource. There's three pricing plan options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RequestBasedUsage</code> — Selects the "Request-Based Usage" pricing plan.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MobileAssetTracking</code> — Selects the "Mobile Asset Tracking" pricing plan.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MobileAssetManagement</code> — Selects the "Mobile Asset Management" pricing plan.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For additional details and restrictions on each pricing plan option, see the <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * @see PricingPlan
     */
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(mapName());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMapRequest)) {
            return false;
        }
        CreateMapRequest other = (CreateMapRequest) obj;
        return Objects.equals(configuration(), other.configuration()) && Objects.equals(description(), other.description())
                && Objects.equals(mapName(), other.mapName())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMapRequest").add("Configuration", configuration()).add("Description", description())
                .add("MapName", mapName()).add("PricingPlan", pricingPlanAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "MapName":
            return Optional.ofNullable(clazz.cast(mapName()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMapRequest, T> g) {
        return obj -> g.apply((CreateMapRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMapRequest> {
        /**
         * <p>
         * Specifies the map style selected from an available data provider.
         * </p>
         * 
         * @param configuration
         *        Specifies the map style selected from an available data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(MapConfiguration configuration);

        /**
         * <p>
         * Specifies the map style selected from an available data provider.
         * </p>
         * This is a convenience that creates an instance of the {@link MapConfiguration.Builder} avoiding the need to
         * create one manually via {@link MapConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MapConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(MapConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link MapConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(MapConfiguration)
         */
        default Builder configuration(Consumer<MapConfiguration.Builder> configuration) {
            return configuration(MapConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * An optional description for the map resource.
         * </p>
         * 
         * @param description
         *        An optional description for the map resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name for the map resource.
         * </p>
         * <p>
         * Requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), and underscores (_).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be a unique map resource name.
         * </p>
         * </li>
         * <li>
         * <p>
         * No spaces allowed. For example, <code>ExampleMap</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mapName
         *        The name for the map resource.</p>
         *        <p>
         *        Requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), and underscores (_).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be a unique map resource name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        No spaces allowed. For example, <code>ExampleMap</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapName(String mapName);

        /**
         * <p>
         * Specifies the pricing plan for your map resource. There's three pricing plan options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RequestBasedUsage</code> — Selects the "Request-Based Usage" pricing plan.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MobileAssetTracking</code> — Selects the "Mobile Asset Tracking" pricing plan.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MobileAssetManagement</code> — Selects the "Mobile Asset Management" pricing plan.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For additional details and restrictions on each pricing plan option, see the <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * </p>
         * 
         * @param pricingPlan
         *        Specifies the pricing plan for your map resource. There's three pricing plan options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RequestBasedUsage</code> — Selects the "Request-Based Usage" pricing plan.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MobileAssetTracking</code> — Selects the "Mobile Asset Tracking" pricing plan.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MobileAssetManagement</code> — Selects the "Mobile Asset Management" pricing plan.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For additional details and restrictions on each pricing plan option, see the <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * Specifies the pricing plan for your map resource. There's three pricing plan options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RequestBasedUsage</code> — Selects the "Request-Based Usage" pricing plan.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MobileAssetTracking</code> — Selects the "Mobile Asset Tracking" pricing plan.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MobileAssetManagement</code> — Selects the "Mobile Asset Management" pricing plan.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For additional details and restrictions on each pricing plan option, see the <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * </p>
         * 
         * @param pricingPlan
         *        Specifies the pricing plan for your map resource. There's three pricing plan options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RequestBasedUsage</code> — Selects the "Request-Based Usage" pricing plan.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MobileAssetTracking</code> — Selects the "Mobile Asset Tracking" pricing plan.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MobileAssetManagement</code> — Selects the "Mobile Asset Management" pricing plan.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For additional details and restrictions on each pricing plan option, see the <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(PricingPlan pricingPlan);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private MapConfiguration configuration;

        private String description;

        private String mapName;

        private String pricingPlan;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMapRequest model) {
            super(model);
            configuration(model.configuration);
            description(model.description);
            mapName(model.mapName);
            pricingPlan(model.pricingPlan);
        }

        public final MapConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(MapConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(MapConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getMapName() {
            return mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        public final String getPricingPlan() {
            return pricingPlan;
        }

        @Override
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMapRequest build() {
            return new CreateMapRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
