/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDevicePositionRequest extends LocationRequest implements
        ToCopyableBuilder<BatchGetDevicePositionRequest.Builder, BatchGetDevicePositionRequest> {
    private static final SdkField<List<String>> DEVICE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeviceIds")
            .getter(getter(BatchGetDevicePositionRequest::deviceIds))
            .setter(setter(Builder::deviceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackerName").getter(getter(BatchGetDevicePositionRequest::trackerName))
            .setter(setter(Builder::trackerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TrackerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_IDS_FIELD,
            TRACKER_NAME_FIELD));

    private final List<String> deviceIds;

    private final String trackerName;

    private BatchGetDevicePositionRequest(BuilderImpl builder) {
        super(builder);
        this.deviceIds = builder.deviceIds;
        this.trackerName = builder.trackerName;
    }

    /**
     * Returns true if the DeviceIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDeviceIds() {
        return deviceIds != null && !(deviceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Devices whose position you want to retrieve.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For example, for two devices: <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDeviceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Devices whose position you want to retrieve.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For example, for two devices: <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code>
     *         </p>
     *         </li>
     */
    public final List<String> deviceIds() {
        return deviceIds;
    }

    /**
     * <p>
     * The tracker resource retrieving the device position.
     * </p>
     * 
     * @return The tracker resource retrieving the device position.
     */
    public final String trackerName() {
        return trackerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceIds() ? deviceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trackerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDevicePositionRequest)) {
            return false;
        }
        BatchGetDevicePositionRequest other = (BatchGetDevicePositionRequest) obj;
        return hasDeviceIds() == other.hasDeviceIds() && Objects.equals(deviceIds(), other.deviceIds())
                && Objects.equals(trackerName(), other.trackerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetDevicePositionRequest").add("DeviceIds", hasDeviceIds() ? deviceIds() : null)
                .add("TrackerName", trackerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceIds":
            return Optional.ofNullable(clazz.cast(deviceIds()));
        case "TrackerName":
            return Optional.ofNullable(clazz.cast(trackerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDevicePositionRequest, T> g) {
        return obj -> g.apply((BatchGetDevicePositionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetDevicePositionRequest> {
        /**
         * <p>
         * Devices whose position you want to retrieve.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For example, for two devices: <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param deviceIds
         *        Devices whose position you want to retrieve.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For example, for two devices: <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIds(Collection<String> deviceIds);

        /**
         * <p>
         * Devices whose position you want to retrieve.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For example, for two devices: <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param deviceIds
         *        Devices whose position you want to retrieve.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For example, for two devices: <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIds(String... deviceIds);

        /**
         * <p>
         * The tracker resource retrieving the device position.
         * </p>
         * 
         * @param trackerName
         *        The tracker resource retrieving the device position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackerName(String trackerName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private List<String> deviceIds = DefaultSdkAutoConstructList.getInstance();

        private String trackerName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDevicePositionRequest model) {
            super(model);
            deviceIds(model.deviceIds);
            trackerName(model.trackerName);
        }

        public final Collection<String> getDeviceIds() {
            if (deviceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceIds;
        }

        @Override
        public final Builder deviceIds(Collection<String> deviceIds) {
            this.deviceIds = BatchGetDevicePositionRequestDeviceIdsListCopier.copy(deviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceIds(String... deviceIds) {
            deviceIds(Arrays.asList(deviceIds));
            return this;
        }

        public final void setDeviceIds(Collection<String> deviceIds) {
            this.deviceIds = BatchGetDevicePositionRequestDeviceIdsListCopier.copy(deviceIds);
        }

        public final String getTrackerName() {
            return trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetDevicePositionRequest build() {
            return new BatchGetDevicePositionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
