/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.services.location.model.SearchForTextResult;
import software.amazon.awssdk.services.location.model.SearchForTextResultListCopier;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchPlaceIndexForTextResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, SearchPlaceIndexForTextResponse> {
    private static final SdkField<List<SearchForTextResult>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Results").getter(SearchPlaceIndexForTextResponse.getter(SearchPlaceIndexForTextResponse::results)).setter(SearchPlaceIndexForTextResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchForTextResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SearchPlaceIndexForTextSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Summary").getter(SearchPlaceIndexForTextResponse.getter(SearchPlaceIndexForTextResponse::summary)).setter(SearchPlaceIndexForTextResponse.setter(Builder::summary)).constructor(SearchPlaceIndexForTextSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, SUMMARY_FIELD));
    private final List<SearchForTextResult> results;
    private final SearchPlaceIndexForTextSummary summary;

    private SearchPlaceIndexForTextResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.summary = builder.summary;
    }

    public boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public List<SearchForTextResult> results() {
        return this.results;
    }

    public SearchPlaceIndexForTextSummary summary() {
        return this.summary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForTextResponse)) {
            return false;
        }
        SearchPlaceIndexForTextResponse other = (SearchPlaceIndexForTextResponse)((Object)obj);
        return this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results()) && Objects.equals(this.summary(), other.summary());
    }

    public String toString() {
        return ToString.builder((String)"SearchPlaceIndexForTextResponse").add("Results", this.hasResults() ? this.results() : null).add("Summary", (Object)this.summary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForTextResponse, T> g) {
        return obj -> g.apply((SearchPlaceIndexForTextResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private List<SearchForTextResult> results = DefaultSdkAutoConstructList.getInstance();
        private SearchPlaceIndexForTextSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForTextResponse model) {
            super(model);
            this.results(model.results);
            this.summary(model.summary);
        }

        public final Collection<SearchForTextResult.Builder> getResults() {
            if (this.results instanceof SdkAutoConstructList) {
                return null;
            }
            return this.results != null ? (Collection)this.results.stream().map(SearchForTextResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder results(Collection<SearchForTextResult> results) {
            this.results = SearchForTextResultListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(SearchForTextResult ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<SearchForTextResult.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (SearchForTextResult)((SearchForTextResult.Builder)SearchForTextResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResults(Collection<SearchForTextResult.BuilderImpl> results) {
            this.results = SearchForTextResultListCopier.copyFromBuilder(results);
        }

        public final SearchPlaceIndexForTextSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        @Override
        public final Builder summary(SearchPlaceIndexForTextSummary summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(SearchPlaceIndexForTextSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public SearchPlaceIndexForTextResponse build() {
            return new SearchPlaceIndexForTextResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchPlaceIndexForTextResponse> {
        public Builder results(Collection<SearchForTextResult> var1);

        public Builder results(SearchForTextResult ... var1);

        public Builder results(Consumer<SearchForTextResult.Builder> ... var1);

        public Builder summary(SearchPlaceIndexForTextSummary var1);

        default public Builder summary(Consumer<SearchPlaceIndexForTextSummary.Builder> summary) {
            return this.summary((SearchPlaceIndexForTextSummary)((SearchPlaceIndexForTextSummary.Builder)SearchPlaceIndexForTextSummary.builder().applyMutation(summary)).build());
        }
    }
}

