/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutGeofenceResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, PutGeofenceResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(PutGeofenceResponse.getter(PutGeofenceResponse::createTime)).setter(PutGeofenceResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> GEOFENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeofenceId").getter(PutGeofenceResponse.getter(PutGeofenceResponse::geofenceId)).setter(PutGeofenceResponse.setter(Builder::geofenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceId").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(PutGeofenceResponse.getter(PutGeofenceResponse::updateTime)).setter(PutGeofenceResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, GEOFENCE_ID_FIELD, UPDATE_TIME_FIELD));
    private final Instant createTime;
    private final String geofenceId;
    private final Instant updateTime;

    private PutGeofenceResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.geofenceId = builder.geofenceId;
        this.updateTime = builder.updateTime;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public String geofenceId() {
        return this.geofenceId;
    }

    public Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.geofenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutGeofenceResponse)) {
            return false;
        }
        PutGeofenceResponse other = (PutGeofenceResponse)((Object)obj);
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.geofenceId(), other.geofenceId()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public String toString() {
        return ToString.builder((String)"PutGeofenceResponse").add("CreateTime", (Object)this.createTime()).add("GeofenceId", (Object)this.geofenceId()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "GeofenceId": {
                return Optional.ofNullable(clazz.cast(this.geofenceId()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutGeofenceResponse, T> g) {
        return obj -> g.apply((PutGeofenceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private Instant createTime;
        private String geofenceId;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PutGeofenceResponse model) {
            super(model);
            this.createTime(model.createTime);
            this.geofenceId(model.geofenceId);
            this.updateTime(model.updateTime);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final String getGeofenceId() {
            return this.geofenceId;
        }

        @Override
        public final Builder geofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
            return this;
        }

        public final void setGeofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public PutGeofenceResponse build() {
            return new PutGeofenceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutGeofenceResponse> {
        public Builder createTime(Instant var1);

        public Builder geofenceId(String var1);

        public Builder updateTime(Instant var1);
    }
}

