/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.PricingPlan;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrackerRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, CreateTrackerRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateTrackerRequest.getter(CreateTrackerRequest::description)).setter(CreateTrackerRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(CreateTrackerRequest.getter(CreateTrackerRequest::pricingPlanAsString)).setter(CreateTrackerRequest.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerName").getter(CreateTrackerRequest.getter(CreateTrackerRequest::trackerName)).setter(CreateTrackerRequest.setter(Builder::trackerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackerName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, PRICING_PLAN_FIELD, TRACKER_NAME_FIELD));
    private final String description;
    private final String pricingPlan;
    private final String trackerName;

    private CreateTrackerRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.pricingPlan = builder.pricingPlan;
        this.trackerName = builder.trackerName;
    }

    public String description() {
        return this.description;
    }

    public PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    public String pricingPlanAsString() {
        return this.pricingPlan;
    }

    public String trackerName() {
        return this.trackerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrackerRequest)) {
            return false;
        }
        CreateTrackerRequest other = (CreateTrackerRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString()) && Objects.equals(this.trackerName(), other.trackerName());
    }

    public String toString() {
        return ToString.builder((String)"CreateTrackerRequest").add("Description", (Object)this.description()).add("PricingPlan", (Object)this.pricingPlanAsString()).add("TrackerName", (Object)this.trackerName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
            case "TrackerName": {
                return Optional.ofNullable(clazz.cast(this.trackerName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrackerRequest, T> g) {
        return obj -> g.apply((CreateTrackerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String description;
        private String pricingPlan;
        private String trackerName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrackerRequest model) {
            super(model);
            this.description(model.description);
            this.pricingPlan(model.pricingPlan);
            this.trackerName(model.trackerName);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        @Override
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        public final String getTrackerName() {
            return this.trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrackerRequest build() {
            return new CreateTrackerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrackerRequest> {
        public Builder description(String var1);

        public Builder pricingPlan(String var1);

        public Builder pricingPlan(PricingPlan var1);

        public Builder trackerName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

